/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.UploadDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Upload
extends AbstractWidget
implements ValidationErrorAware {
    private static final String UPLOAD_EL = "upload";
    private static final String VALUE_EL = "value";
    private static final String VALIDATION_MSG_EL = "validation-message";
    private final UploadDefinition uploadDefinition;
    private Part part;
    private ValidationError validationError;

    public Upload(UploadDefinition uploadDefinition) {
        super(uploadDefinition);
        this.uploadDefinition = uploadDefinition;
    }

    public UploadDefinition getUploadDefinition() {
        return this.uploadDefinition;
    }

    public WidgetDefinition getDefinition() {
        return this.uploadDefinition;
    }

    public Object getValue() {
        return this.part;
    }

    public void setValue(Object object) {
        if (object != null && !(object instanceof Part)) {
            throw new RuntimeException("The value of an upload widget must be of type " + Part.class + ".");
        }
        this.part = (Part)object;
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        Object obj = formContext.getRequest().get(this.getRequestParameterName());
        if (obj instanceof Part) {
            Part requestPart = (Part)obj;
            if (this.part != null) {
                this.part.dispose();
            }
            requestPart.setDisposeWithRequest(false);
            this.part = requestPart;
            this.validationError = null;
        } else if (obj != null || this.getForm().getSubmitWidget() == this) {
            if (this.part != null) {
                this.part.dispose();
                this.part = null;
            }
            this.validationError = null;
        }
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            return true;
        }
        if (this.part == null) {
            if (this.uploadDefinition.isRequired()) {
                this.validationError = new ValidationError(new I18nMessage("general.field-required", "forms"));
            }
        } else {
            String mimeTypes = this.uploadDefinition.getMimeTypes();
            if (mimeTypes != null) {
                StringTokenizer tok = new StringTokenizer(this.uploadDefinition.getMimeTypes(), ", ");
                this.validationError = new ValidationError(new I18nMessage("upload.invalid-type", "forms"));
                String contentType = this.part.getMimeType();
                while (tok.hasMoreTokens()) {
                    if (!tok.nextToken().equals(contentType)) continue;
                    this.validationError = null;
                }
            } else {
                this.validationError = null;
            }
        }
        return this.validationError == null ? super.validate() : false;
    }

    public ValidationError getValidationError() {
        return this.validationError;
    }

    public void setValidationError(ValidationError error) {
        this.validationError = error;
    }

    public String getXMLElementName() {
        return UPLOAD_EL;
    }

    public AttributesImpl getXMLElementAttributes() {
        AttributesImpl attrs = super.getXMLElementAttributes();
        attrs.addCDATAAttribute("id", this.getRequestParameterName());
        attrs.addCDATAAttribute("required", String.valueOf(this.uploadDefinition.isRequired()));
        if (this.uploadDefinition.getMimeTypes() != null) {
            attrs.addCDATAAttribute("mime-types", this.uploadDefinition.getMimeTypes());
        }
        return attrs;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        if (this.part != null) {
            String name = (String)this.part.getHeaders().get("filename");
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            contentHandler.characters(name.toCharArray(), 0, name.length());
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
        }
        if (this.validationError != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            this.validationError.generateSaxFragment(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message");
        }
    }
}

