/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.generation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.ArrayStack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JXMacrosHelper {
    private XMLConsumer cocoonConsumer;
    private ArrayStack stack = new ArrayStack();
    private Map classes;
    private static final String VALIDATION_ERROR = "validation-error";

    public static JXMacrosHelper createHelper(XMLConsumer consumer) {
        return new JXMacrosHelper(consumer);
    }

    public JXMacrosHelper(XMLConsumer consumer) {
        this.cocoonConsumer = consumer;
    }

    public void startForm(Form form, Map attributes) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            attrs.addCDATAAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        this.cocoonConsumer.startPrefixMapping("fi", "http://apache.org/cocoon/forms/1.0#instance");
        this.cocoonConsumer.startElement("http://apache.org/cocoon/forms/1.0#instance", "form-template", "fi:form-template", (Attributes)attrs);
    }

    public void endForm() throws SAXException {
        this.cocoonConsumer.endElement("http://apache.org/cocoon/forms/1.0#instance", "form-template", "fi:form-template");
        this.cocoonConsumer.endPrefixMapping("fi");
    }

    public void flushRoot(Object obj) throws SAXException {
        Object stackObj = this.stack.pop();
        if (stackObj != obj) {
            throw new IllegalStateException("Flushing on wrong widget (expected " + stackObj + ", got " + obj + ")");
        }
        ((RootBufferingPipe)((Object)this.stack.pop())).flushRoot();
    }

    public Widget getWidget(Widget currentWidget, String path) {
        Widget result = currentWidget.lookupWidget(path);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Widget '" + currentWidget + "' has no child named '" + path + "'");
    }

    public Repeater getRepeater(Widget currentWidget, String id) {
        Widget child = this.getWidget(currentWidget, id);
        if (child instanceof Repeater) {
            return (Repeater)child;
        }
        throw new IllegalArgumentException("Widget '" + child + "' is not a repeater");
    }

    public void generateWidget(Widget widget, Locale locale) throws SAXException {
        RootBufferingPipe pipe = new RootBufferingPipe(this.cocoonConsumer);
        this.stack.push((Object)pipe);
        this.stack.push((Object)widget);
        widget.generateSaxFragment((ContentHandler)((Object)pipe), locale);
    }

    public void generateWidgetLabel(Widget widget, String id) throws SAXException {
        this.getWidget(widget, id).generateLabel((ContentHandler)this.cocoonConsumer);
    }

    public void generateRepeaterWidgetLabel(Widget widget, String id, String widgetId) throws SAXException {
        this.getRepeater(widget, id).generateWidgetLabel(widgetId, (ContentHandler)this.cocoonConsumer);
    }

    public void generateRepeaterSize(Widget widget, String id) throws SAXException {
        this.getRepeater(widget, id).generateSize((ContentHandler)this.cocoonConsumer);
    }

    public void generateValidationError(ValidationError error) throws SAXException {
        RootBufferingPipe pipe = new RootBufferingPipe(this.cocoonConsumer);
        this.stack.push((Object)pipe);
        this.stack.push((Object)error);
        pipe.startElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_ERROR, "fi:validation-error", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
        error.generateSaxFragment((ContentHandler)((Object)pipe));
        pipe.endElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_ERROR, "fi:validation-error");
    }

    public boolean isValidationError(Object object) {
        return object instanceof ValidationError;
    }

    public void defineClassBody(Form form, String id, Object body) {
        if (this.classes == null) {
            this.classes = new HashMap();
        }
        this.classes.put(id, body);
    }

    public Object getClassBody(String id) {
        Object result;
        Object v0 = result = this.classes == null ? null : this.classes.get(id);
        if (result == null) {
            throw new IllegalArgumentException("No class '" + id + "' has been defined.");
        }
        return result;
    }

    public boolean isSelectedCase(Widget unionWidget, String caseValue) {
        String value = (String)unionWidget.getValue();
        return caseValue.equals(value != null ? value : "");
    }

    public boolean isVisible(Widget widget) {
        return widget.getCombinedState().isDisplayingValues();
    }

    private static class RootBufferingPipe
    extends AbstractXMLPipe {
        private int depth = 0;
        private String rootUri;
        private String rootLoc;
        private String rootRaw;

        public RootBufferingPipe(XMLConsumer next) {
            this.setConsumer(next);
        }

        public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
            if (this.depth == 0) {
                this.rootUri = uri;
                this.rootLoc = loc;
                this.rootRaw = raw;
            }
            ++this.depth;
            super.startElement(uri, loc, raw, a);
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            --this.depth;
            if (this.depth > 0) {
                super.endElement(uri, loc, raw);
            }
        }

        public void flushRoot() throws SAXException {
            if (this.depth != 0) {
                throw new IllegalStateException("Depth is not zero");
            }
            super.endElement(this.rootUri, this.rootLoc, this.rootRaw);
        }
    }
}

