/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.taglib.BodyContent;
import org.apache.cocoon.taglib.BodyTag;
import org.apache.cocoon.taglib.IterationTag;
import org.apache.cocoon.taglib.Tag;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.AbstractXMLProducer;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.map.StaticBucketMap;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class TagTransformer
extends AbstractXMLProducer
implements Transformer,
Serviceable,
Configurable,
Disposable,
Recyclable {
    private int recordingLevel;
    private int skipLevel;
    private String transformerHint;
    private ServiceSelector transformerSelector;
    private final ArrayStack tagStack = new ArrayStack();
    private final ArrayStack tagSelectorStack = new ArrayStack();
    private final ArrayStack tagTransformerStack = new ArrayStack();
    private ServiceSelector tagNamespaceSelector;
    private Tag currentTag;
    private XMLConsumer currentConsumer;
    private XMLConsumer currentConsumerBackup;
    private XMLSerializer xmlSerializer;
    private SourceResolver resolver;
    private Map objectModel;
    private Parameters parameters;
    private ServiceManager manager;
    private final String[] paramArray = new String[1];
    private static Map TAG_PROPERTIES_MAP = new StaticBucketMap();
    static /* synthetic */ Class class$java$lang$String;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.tagNamespaceSelector = (ServiceSelector)manager.lookup(Tag.ROLE + "Selector");
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.transformerHint = conf.getChild("transformer-hint").getValue(null);
        if (this.transformerHint != null) {
            try {
                this.transformerSelector = (ServiceSelector)this.manager.lookup(Transformer.ROLE + "Selector");
            }
            catch (ServiceException e) {
                String message = "Can't lookup transformer selector";
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(message, (Throwable)e);
                }
                throw new ConfigurationException(message, (Throwable)e);
            }
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws IOException, SAXException {
        this.resolver = resolver;
        this.objectModel = objectModel;
        this.parameters = parameters;
    }

    public void recycle() {
        this.recordingLevel = 0;
        this.skipLevel = 0;
        this.resolver = null;
        this.objectModel = null;
        this.parameters = null;
        this.currentTag = null;
        this.currentConsumer = null;
        this.currentConsumerBackup = null;
        if (this.xmlSerializer != null) {
            this.manager.release((Object)this.xmlSerializer);
            this.xmlSerializer = null;
        }
        while (!this.tagStack.isEmpty()) {
            Tag tag = (Tag)this.tagStack.pop();
            if (tag == null) continue;
            ComponentSelector tagSelector = (ComponentSelector)this.tagSelectorStack.pop();
            tagSelector.release((Component)tag);
            this.tagNamespaceSelector.release((Object)tagSelector);
        }
        while (!this.tagTransformerStack.isEmpty()) {
            Transformer transformer = (Transformer)this.tagTransformerStack.pop();
            this.transformerSelector.release((Object)transformer);
        }
        if (!this.tagSelectorStack.isEmpty()) {
            this.getLogger().fatalError("recycle: internal Error, tagSelectorStack not empty");
            this.tagSelectorStack.clear();
        }
        super.recycle();
    }

    public void dispose() {
        this.manager.release((Object)this.tagNamespaceSelector);
        this.tagNamespaceSelector = null;
        if (this.transformerSelector != null) {
            this.manager.release((Object)this.transformerSelector);
            this.transformerSelector = null;
        }
    }

    public void setConsumer(XMLConsumer consumer) {
        this.currentConsumer = consumer;
        super.setConsumer(consumer);
    }

    public void setDocumentLocator(Locator locator) {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.currentConsumer.startDocument();
    }

    public void endDocument() throws SAXException {
        this.currentConsumer.endDocument();
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.processingInstruction(target, data);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.endDTD();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.endPrefixMapping(prefix);
    }

    public void startCDATA() throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.startCDATA();
    }

    public void endCDATA() throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.endCDATA();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.recordingLevel > 0) {
            ++this.recordingLevel;
            this.currentConsumer.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (this.skipLevel > 0) {
            ++this.skipLevel;
            return;
        }
        Tag tag = null;
        if (namespaceURI != null && namespaceURI.length() > 0) {
            ComponentSelector tagSelector = null;
            try {
                tagSelector = (ComponentSelector)this.tagNamespaceSelector.select((Object)namespaceURI);
                this.tagSelectorStack.push((Object)tagSelector);
                tag = (Tag)tagSelector.select((Object)localName);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("startElement: Got tag " + qName);
                }
                this.setupTag(tag, qName, atts);
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.tagStack.push(tag);
        if (tag == null) {
            this.currentConsumer.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        int eval = tag.doStartTag(namespaceURI, localName, qName, atts);
        switch (eval) {
            case 0: {
                this.skipLevel = 0;
                if (!(tag instanceof IterationTag)) break;
                this.startRecording();
                break;
            }
            case 1: {
                this.skipLevel = 1;
                break;
            }
            default: {
                String tagName = tag.getClass().getName();
                this.getLogger().warn("Bad return value from doStartTag(" + tagName + "): " + eval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Object saxFragment = null;
        if (this.recordingLevel > 0) {
            if (--this.recordingLevel > 0) {
                this.currentConsumer.endElement(namespaceURI, localName, qName);
                return;
            }
            saxFragment = this.endRecording();
        }
        if (this.skipLevel > 0 && --this.skipLevel > 0) {
            return;
        }
        Tag tag = (Tag)this.tagStack.pop();
        if (tag == null) {
            this.currentConsumer.endElement(namespaceURI, localName, qName);
            return;
        }
        ComponentSelector tagSelector = (ComponentSelector)this.tagSelectorStack.pop();
        try {
            block17: {
                if (saxFragment != null) {
                    IterationTag iterTag = (IterationTag)tag;
                    XMLDeserializer xmlDeserializer = null;
                    try {
                        try {
                            xmlDeserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                            xmlDeserializer.setConsumer((XMLConsumer)this);
                            XMLConsumer backup = this.currentConsumer;
                            if (tag instanceof BodyTag) {
                                SaxBuffer content = new SaxBuffer();
                                this.currentConsumer = content;
                                ((BodyTag)tag).setBodyContent(new BodyContent(content, backup));
                                ((BodyTag)tag).doInitBody();
                            }
                            do {
                                xmlDeserializer.deserialize(saxFragment);
                            } while (iterTag.doAfterBody() != 1);
                            if (tag instanceof BodyTag) {
                                this.currentConsumer = backup;
                            }
                        }
                        catch (ServiceException e) {
                            throw new SAXException("Can't obtain XMLDeserializer", (Exception)((Object)e));
                        }
                        Object var12_12 = null;
                        if (xmlDeserializer == null) break block17;
                    }
                    catch (Throwable throwable) {
                        Object var12_13 = null;
                        if (xmlDeserializer == null) throw throwable;
                        this.manager.release((Object)xmlDeserializer);
                        throw throwable;
                    }
                    this.manager.release((Object)xmlDeserializer);
                }
            }
            tag.doEndTag(namespaceURI, localName, qName);
            this.currentTag = tag.getParent();
            if (tag == this.currentConsumer) {
                this.popConsumer();
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("endElement: Release tag " + qName);
            }
            tagSelector.release((Component)tag);
            this.tagNamespaceSelector.release((Object)tagSelector);
            if (this.transformerSelector == null) throw throwable;
            if (!(tag instanceof XMLProducer)) throw throwable;
            this.getLogger().debug("endElement: Release transformer");
            Transformer transformer = (Transformer)this.tagTransformerStack.pop();
            this.transformerSelector.release((Object)transformer);
            throw throwable;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("endElement: Release tag " + qName);
        }
        tagSelector.release((Component)tag);
        this.tagNamespaceSelector.release((Object)tagSelector);
        if (this.transformerSelector == null) return;
        if (!(tag instanceof XMLProducer)) return;
        this.getLogger().debug("endElement: Release transformer");
        Transformer transformer = (Transformer)this.tagTransformerStack.pop();
        this.transformerSelector.release((Object)transformer);
    }

    public void startEntity(String name) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.startEntity(name);
    }

    public void endEntity(String name) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.endEntity(name);
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.skippedEntity(name);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.characters(ch, start, length);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.comment(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.skipLevel > 0) {
            return;
        }
        this.currentConsumer.ignorableWhitespace(ch, start, length);
    }

    private void setupTag(Tag tag, String name, Attributes atts) throws SAXException {
        tag.setParent(this.currentTag);
        if (tag instanceof XMLProducer) {
            XMLConsumer tagConsumer;
            if (this.transformerSelector != null) {
                Transformer tagTransformer = null;
                try {
                    tagTransformer = (Transformer)this.transformerSelector.select((Object)this.transformerHint);
                    this.tagTransformerStack.push((Object)tagTransformer);
                    tagTransformer.setConsumer(this.currentConsumer);
                    tagTransformer.setup(this.resolver, this.objectModel, null, this.parameters);
                }
                catch (SAXException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SAXException("Failed to setup tag transformer " + this.transformerHint, e);
                }
                tagConsumer = tagTransformer;
            } else {
                tagConsumer = this.currentConsumer;
            }
            ((XMLProducer)tag).setConsumer(tagConsumer);
        }
        try {
            tag.setup(this.resolver, this.objectModel, this.parameters);
        }
        catch (IOException e) {
            throw new SAXException("Could not set up tag " + name, e);
        }
        if (tag instanceof XMLConsumer) {
            this.currentConsumer = (XMLConsumer)tag;
        }
        this.currentTag = tag;
        for (int i = 0; i < atts.getLength(); ++i) {
            String attributeValue;
            String attributeName = atts.getLocalName(i);
            this.paramArray[0] = attributeValue = atts.getValue(i);
            try {
                Method method = TagTransformer.getWriteMethod(tag.getClass(), attributeName);
                method.invoke((Object)tag, (Object[])this.paramArray);
                continue;
            }
            catch (Throwable e) {
                if (!this.getLogger().isInfoEnabled()) continue;
                this.getLogger().info("Tag " + name + " attribute " + attributeName + " not set", e);
            }
        }
    }

    private void startRecording() throws SAXException {
        try {
            this.xmlSerializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
        }
        catch (ServiceException e) {
            throw new SAXException("Can't lookup XMLSerializer", (Exception)((Object)e));
        }
        this.currentConsumerBackup = this.currentConsumer;
        this.currentConsumer = this.xmlSerializer;
        this.recordingLevel = 1;
    }

    private Object endRecording() {
        this.currentConsumer = this.currentConsumerBackup;
        this.currentConsumerBackup = null;
        Object saxFragment = this.xmlSerializer.getSAXFragment();
        this.manager.release((Object)this.xmlSerializer);
        this.xmlSerializer = null;
        return saxFragment;
    }

    private void popConsumer() {
        for (Tag loop = this.currentTag; loop != null; loop = loop.getParent()) {
            if (!(loop instanceof XMLConsumer)) continue;
            this.currentConsumer = (XMLConsumer)loop;
            return;
        }
        this.currentConsumer = this.xmlConsumer;
    }

    private static Method getWriteMethod(Class type, String propertyName) throws IntrospectionException {
        Map map = TagTransformer.getWriteMethodMap(type);
        Method method = (Method)map.get(propertyName);
        if (method == null) {
            throw new IntrospectionException("No such property: " + propertyName);
        }
        return method;
    }

    private static Map getWriteMethodMap(Class beanClass) throws IntrospectionException {
        HashMap<String, Method> map = (HashMap<String, Method>)TAG_PROPERTIES_MAP.get(beanClass);
        if (map != null) {
            return map;
        }
        BeanInfo info = Introspector.getBeanInfo(beanClass);
        if (info != null) {
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            map = new HashMap<String, Method>(pds.length * 4 / 3, 1.0f);
            for (int i = 0; i < pds.length; ++i) {
                PropertyDescriptor pd = pds[i];
                String name = pd.getName();
                Method method = pd.getWriteMethod();
                Class<?> type = pd.getPropertyType();
                if (type != (class$java$lang$String == null ? TagTransformer.class$("java.lang.String") : class$java$lang$String)) continue;
                map.put(name, method);
            }
        }
        TAG_PROPERTIES_MAP.put(beanClass, map);
        return map;
    }
}

