/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import java.util.StringTokenizer;

public class ColorCode {
    private static final int _red = 0;
    private static final int _green = 1;
    private static final int _blue = 2;
    private static final int _component_count = 3;
    private int[] _components = new int[3];
    private String rgbstring = null;

    public ColorCode(String value) throws IOException {
        this.rgbstring = value;
        if (value == null) {
            throw new IOException("cannot process a null color code");
        }
        StringTokenizer tokenizer = new StringTokenizer(value.trim(), ":");
        if (tokenizer.countTokens() != 3) {
            throw new IOException("color code must have exactly 3 components, no more, no less");
        }
        for (int j = 0; j < 3; ++j) {
            try {
                this._components[j] = Integer.parseInt(tokenizer.nextToken(), 16);
            }
            catch (Exception e) {
                throw new IOException("cannot parse component #" + j + " (" + e.getMessage() + ")");
            }
            if (this._components[j] >= 0 && this._components[j] <= 65535) continue;
            throw new IOException("Component #" + j + " is out of range");
        }
    }

    public int getRed() {
        return this._components[0];
    }

    public int getGreen() {
        return this._components[1];
    }

    public int getBlue() {
        return this._components[2];
    }

    public String toString() {
        return this.rgbstring;
    }
}

