/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;

public class Offsets {
    private static final int _component_count = 4;
    private double[] _components = new double[4];

    public Offsets(String value) throws IOException {
        if (value == null) {
            throw new IOException("cannot process a null offsets string");
        }
        char[] input = value.trim().toCharArray();
        int index = 0;
        for (int j = 0; j < 4; ++j) {
            int tailIndex;
            while (index < input.length && Character.isWhitespace(input[index])) {
                ++index;
            }
            if (index == input.length) {
                throw new IOException("insufficient offsets in string");
            }
            for (tailIndex = index; tailIndex < input.length && !Character.isWhitespace(input[tailIndex]); ++tailIndex) {
            }
            this._components[j] = NumericConverter.extractDouble(new String(input, index, tailIndex - index)).doubleValue();
            index = tailIndex;
        }
        if (new String(input, index, input.length - index).trim().length() != 0) {
            throw new IOException("Too much data in string for 4 offsets");
        }
    }

    public double[] getComponents() {
        return this._components;
    }
}

