/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.types;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.types.BooleanResult;

public class BooleanConverter {
    private static final String[] _true_values = new String[]{"1", "true"};
    private static final String[] _false_values = new String[]{"0", "false"};
    private static final BooleanResult _true_result = new BooleanResult(true);
    private static final BooleanResult _false_result = new BooleanResult(false);

    private BooleanConverter() {
    }

    public static BooleanResult extractBoolean(String value) {
        int k;
        String input = value == null ? "" : value.trim();
        BooleanResult result = null;
        for (k = 0; k < _true_values.length; ++k) {
            if (!_true_values[k].equalsIgnoreCase(input)) continue;
            result = _true_result;
            break;
        }
        if (result == null) {
            for (k = 0; k < _false_values.length; ++k) {
                if (!_false_values[k].equalsIgnoreCase(input)) continue;
                result = _false_result;
                break;
            }
        }
        if (result == null) {
            result = new BooleanResult(new IOException("\"" + input + "\" is not a boolean value"));
        }
        return result;
    }
}

