/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.types;

import java.io.IOException;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.components.elementprocessor.types.NumericResult;
import org.apache.cocoon.components.elementprocessor.types.Validator;

public class NumericConverter {
    private static final Validator _non_negative_validator = new Validator(){

        public IOException validate(Number number) {
            IOException e = null;
            if (number.intValue() < 0) {
                e = new IOException("\"" + number.intValue() + "\" is not a non-negative integer");
            }
            return e;
        }
    };
    private static final Validator _positive_validator = new Validator(){

        public IOException validate(Number number) {
            IOException e = null;
            if (number.intValue() < 1) {
                e = new IOException("\"" + number.intValue() + "\" is not a positive integer");
            }
            return e;
        }
    };

    private NumericConverter() {
    }

    public static NumericResult extractDouble(String value) {
        return NumericConverter.extractDouble(value, null);
    }

    public static NumericResult extractDouble(String value, Validator validator) {
        String input = value == null ? "" : value.trim();
        NumericResult result = null;
        try {
            Double number = new Double(input);
            IOException exception = null;
            if (validator != null) {
                exception = validator.validate(number);
            }
            result = exception == null ? new NumericResult(number) : new NumericResult(exception);
        }
        catch (NumberFormatException ignored) {
            result = new NumericResult((IOException)new CascadingIOException("\"" + input + "\" does not represent a double value", (Throwable)ignored));
        }
        return result;
    }

    public static NumericResult extractInteger(String value) {
        return NumericConverter.extractInteger(value, null);
    }

    public static NumericResult extractInteger(String value, Validator validator) {
        String input = value == null ? "" : value.trim();
        NumericResult result = null;
        try {
            Integer number = new Integer(input);
            IOException exception = null;
            if (validator != null) {
                exception = validator.validate(number);
            }
            result = exception == null ? new NumericResult(number) : new NumericResult(exception);
        }
        catch (NumberFormatException ignored) {
            result = new NumericResult((IOException)new CascadingIOException("\"" + input + "\" does not represent an integer value", (Throwable)ignored));
        }
        return result;
    }

    public static NumericResult extractPositiveInteger(String value) {
        return NumericConverter.extractInteger(value, _positive_validator);
    }

    public static NumericResult extractNonNegativeInteger(String value) {
        return NumericConverter.extractInteger(value, _non_negative_validator);
    }
}

