/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.cocoon.components.search.IndexHelperField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.helpers.AttributesImpl;

public class LuceneIndexContentHandler
implements ContentHandler {
    public static final String LUCENE_URI = "http://apache.org/cocoon/lucene/1.0";
    public static final String LUCENE_ATTR_TO_TEXT_ATTRIBUTE = "text-attr";
    StringBuffer bodyText = new StringBuffer();
    private List documents;
    private Document bodyDocument = new Document();
    private Stack elementStack;
    private HashSet fieldTags;

    public LuceneIndexContentHandler() {
        this.documents = new ArrayList();
        this.documents.add(this.bodyDocument);
        this.elementStack = new Stack();
        this.fieldTags = new HashSet();
    }

    public void setFieldTags(HashSet fieldTags) {
        this.fieldTags = fieldTags;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public List allDocuments() {
        return this.documents;
    }

    public Iterator iterator() {
        return this.documents.iterator();
    }

    public void characters(char[] ch, int start, int length) {
        if (ch.length > 0 && start >= 0 && length > 1) {
            if (this.elementStack.size() > 0) {
                IndexHelperField tos = (IndexHelperField)this.elementStack.peek();
                tos.appendText(ch, start, length);
            }
            this.bodyText.append(' ');
            this.bodyText.append(ch, start, length);
        }
    }

    public void endDocument() {
        this.bodyDocument.add(Field.UnStored((String)"body", (String)this.bodyText.toString()));
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        IndexHelperField tos = (IndexHelperField)this.elementStack.pop();
        String lname = tos.getLocalFieldName();
        StringBuffer text = tos.getText();
        Attributes atts = tos.getAttributes();
        boolean attributesToText = atts.getIndex(LUCENE_URI, LUCENE_ATTR_TO_TEXT_ATTRIBUTE) != -1;
        for (int i = 0; i < atts.getLength(); ++i) {
            if (LUCENE_URI.equals(atts.getURI(i))) continue;
            String atts_lname = atts.getLocalName(i);
            String atts_value = atts.getValue(i);
            this.bodyDocument.add(Field.UnStored((String)(lname + "@" + atts_lname), (String)atts_value));
            if (!attributesToText) continue;
            text.append(' ');
            text.append(atts_value);
            this.bodyText.append(' ');
            this.bodyText.append(atts_value);
        }
        if (text != null && text.length() > 0) {
            if (this.isFieldTag(lname)) {
                this.bodyDocument.add(Field.UnIndexed((String)lname, (String)text.toString()));
            }
            this.bodyDocument.add(Field.UnStored((String)lname, (String)text.toString()));
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void skippedEntity(String name) {
    }

    public void startDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        IndexHelperField ihf = new IndexHelperField(localName, qName, new AttributesImpl(atts));
        this.elementStack.push(ihf);
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    private boolean isFieldTag(String tag) {
        if (this.fieldTags == null) {
            return false;
        }
        Iterator i = this.fieldTags.iterator();
        while (i.hasNext()) {
            if (!tag.equals(i.next())) continue;
            return true;
        }
        return false;
    }
}

