/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.UberspectImpl;
import org.apache.velocity.util.introspection.VelMethod;
import org.apache.velocity.util.introspection.VelPropertyGet;
import org.apache.velocity.util.introspection.VelPropertySet;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class VelocityGenerator
extends ServiceableGenerator
implements Initializable,
Configurable,
LogSystem {
    private static final String CONTEXT_RESOLVER_KEY = "resolver";
    private static final String CONTEXT_SOURCE_CACHE_KEY = "source-cache";
    private VelocityEngine tmplEngine;
    private boolean tmplEngineInitialized;
    private DefaultContext resolverContext;
    private org.apache.velocity.context.Context velocityContext;
    private boolean activeFlag;
    static /* synthetic */ Class class$java$lang$Object;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.resolverContext = new DefaultContext();
        this.tmplEngine = new VelocityEngine();
        this.tmplEngine.setProperty("runtime.introspector.uberspect", (Object)JSIntrospector.class.getName());
        this.tmplEngine.setProperty("runtime.log.logsystem", (Object)this);
        this.tmplEngine.setProperty("cocoon.resource.loader.class", (Object)TemplateLoader.class.getName());
        this.tmplEngine.setProperty("cocoon.resource.loader.cache", (Object)configuration.getAttribute("usecache", "false"));
        this.tmplEngine.setProperty("cocoon.resource.loader.modificationCheckInterval", (Object)configuration.getAttribute("checkInterval", "0"));
        this.tmplEngine.setProperty("cocoon.resource.loader.context", (Object)this.resolverContext);
        Configuration[] properties = configuration.getChildren("property");
        for (int i = 0; i < properties.length; ++i) {
            Configuration c = properties[i];
            String name = c.getAttribute("name");
            if (name.startsWith("runtime.log") || name.indexOf(".resource.loader.") != -1) {
                if (!this.getLogger().isInfoEnabled()) continue;
                this.getLogger().info("ignoring disallowed property '" + name + "'.");
                continue;
            }
            this.tmplEngine.setProperty(name, (Object)c.getAttribute("value"));
        }
        ArrayList<String> resourceLoaders = new ArrayList<String>();
        Configuration[] loaders = configuration.getChildren("resource-loader");
        for (int i = 0; i < loaders.length; ++i) {
            Configuration loader = loaders[i];
            String name = loader.getAttribute("name");
            if (name.equals("cocoon")) {
                if (!this.getLogger().isInfoEnabled()) continue;
                this.getLogger().info("'cocoon' resource loader already defined.");
                continue;
            }
            resourceLoaders.add(name);
            String prefix = name + ".resource.loader.";
            String type = loader.getAttribute("class");
            this.tmplEngine.setProperty(prefix + "class", (Object)type);
            Configuration[] loaderProperties = loader.getChildren("property");
            for (int j = 0; j < loaderProperties.length; ++j) {
                Configuration c = loaderProperties[j];
                String propName = c.getAttribute("name");
                this.tmplEngine.setProperty(prefix + propName, (Object)c.getAttribute("value"));
            }
        }
        StringBuffer buffer = new StringBuffer("cocoon");
        Iterator it = resourceLoaders.iterator();
        while (it.hasNext()) {
            buffer.append(',');
            buffer.append((String)it.next());
        }
        this.tmplEngine.setProperty("resource.loader", (Object)buffer.toString());
    }

    public void initialize() throws Exception {
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters params) throws ProcessingException, SAXException, IOException {
        if (this.activeFlag) {
            throw new IllegalStateException("setup called on recyclable sitemap component before properly recycling previous state");
        }
        super.setup(resolver, objectModel, src, params);
        this.resolverContext.put((Object)CONTEXT_RESOLVER_KEY, (Object)resolver);
        this.resolverContext.put((Object)CONTEXT_SOURCE_CACHE_KEY, new HashMap());
        final Object bean = FlowHelper.getContextObject((Map)objectModel);
        if (bean != null) {
            PropertyDescriptor[] props;
            final WebContinuation kont = FlowHelper.getWebContinuation((Map)objectModel);
            JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(bean.getClass());
            DynamicPropertyHandler h = null;
            if (bi.isDynamic()) {
                Class cl = bi.getDynamicPropertyHandlerClass();
                try {
                    h = (DynamicPropertyHandler)cl.newInstance();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    h = null;
                }
                props = null;
            } else {
                h = null;
                props = bi.getPropertyDescriptors();
            }
            final DynamicPropertyHandler handler = h;
            this.velocityContext = new org.apache.velocity.context.Context(){

                public Object put(String key, Object value) {
                    if (key.equals("flowContext") || key.equals("continuation")) {
                        return value;
                    }
                    if (handler != null) {
                        handler.setProperty(bean, key, value);
                        return value;
                    }
                    for (int i = 0; i < props.length; ++i) {
                        if (!props[i].getName().equals(key)) continue;
                        try {
                            return props[i].getWriteMethod().invoke(bean, value);
                        }
                        catch (Exception ignored) {
                            break;
                        }
                    }
                    return value;
                }

                public boolean containsKey(Object key) {
                    if (key.equals("flowContext") || key.equals("continuation")) {
                        return true;
                    }
                    if (handler != null) {
                        String[] result = handler.getPropertyNames(bean);
                        for (int i = 0; i < result.length; ++i) {
                            if (!key.equals(result[i])) continue;
                            return true;
                        }
                    } else {
                        for (int i = 0; i < props.length; ++i) {
                            if (!key.equals(props[i].getName())) continue;
                            return true;
                        }
                    }
                    return false;
                }

                public Object[] getKeys() {
                    Object[] result = null;
                    if (handler != null) {
                        result = handler.getPropertyNames(bean);
                    } else {
                        result = new Object[props.length];
                        for (int i = 0; i < props.length; ++i) {
                            result[i] = props[i].getName();
                        }
                    }
                    HashSet<Object> set = new HashSet<Object>();
                    for (int i = 0; i < result.length; ++i) {
                        set.add(result[i]);
                    }
                    set.add("flowContext");
                    set.add("continuation");
                    result = new Object[set.size()];
                    set.toArray(result);
                    return result;
                }

                public Object get(String key) {
                    if (key.equals("flowContext")) {
                        return bean;
                    }
                    if (key.equals("continuation")) {
                        return kont;
                    }
                    if (handler != null) {
                        return handler.getProperty(bean, key);
                    }
                    for (int i = 0; i < props.length; ++i) {
                        if (!props[i].getName().equals(key)) continue;
                        try {
                            return props[i].getReadMethod().invoke(bean, null);
                        }
                        catch (Exception ignored) {
                            break;
                        }
                    }
                    return null;
                }

                public Object remove(Object key) {
                    return key;
                }
            };
        }
        this.velocityContext = new ChainedContext(this.velocityContext, ObjectModelHelper.getRequest((Map)objectModel), ObjectModelHelper.getResponse((Map)objectModel), ObjectModelHelper.getContext((Map)objectModel), params);
        this.velocityContext.put("template", (Object)src);
        this.activeFlag = true;
    }

    public void recycle() {
        this.activeFlag = false;
        try {
            Map sourceCache = (Map)this.resolverContext.get((Object)CONTEXT_SOURCE_CACHE_KEY);
            Iterator it = sourceCache.values().iterator();
            while (it.hasNext()) {
                this.resolver.release((Source)it.next());
            }
        }
        catch (ContextException contextException) {
            // empty catch block
        }
        this.velocityContext = null;
        super.recycle();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (!this.activeFlag) {
            throw new IllegalStateException("generate called on sitemap component before setup.");
        }
        SAXParser parser = null;
        StringWriter w = new StringWriter();
        try {
            parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processing File: " + this.source);
            }
            if (!this.tmplEngineInitialized) {
                this.tmplEngine.init();
                this.tmplEngineInitialized = true;
            }
            this.tmplEngine.mergeTemplate(this.source, this.velocityContext, (Writer)w);
            InputSource xmlInput = new InputSource(new StringReader(w.toString()));
            xmlInput.setSystemId(this.source);
            parser.parse(xmlInput, (ContentHandler)this.xmlConsumer);
        }
        catch (IOException e) {
            this.getLogger().warn("VelocityGenerator.generate()", (Throwable)e);
            throw new ResourceNotFoundException("Could not get Resource for VelocityGenerator", (Throwable)e);
        }
        catch (SAXParseException e) {
            String lineStr;
            int line = e.getLineNumber();
            int column = e.getColumnNumber();
            if (line <= 0) {
                line = Integer.MAX_VALUE;
            }
            BufferedReader reader = new BufferedReader(new StringReader(w.toString()));
            StringBuffer message = new StringBuffer(e.getMessage());
            message.append(" In generated document:\n");
            for (int i = 0; i < line && (lineStr = reader.readLine()) != null; ++i) {
                message.append(lineStr);
                message.append("\n");
            }
            if (column > 0) {
                message.append(StringUtils.leftPad((String)"^\n", (int)(column + 1)));
            }
            SAXParseException pe = new SAXParseException(message.toString(), e.getPublicId(), "(Document generated from template " + e.getSystemId() + ")", e.getLineNumber(), e.getColumnNumber(), null);
            this.getLogger().error("VelocityGenerator.generate()", (Throwable)pe);
            throw pe;
        }
        catch (SAXException e) {
            this.getLogger().error("VelocityGenerator.generate()", (Throwable)e);
            throw e;
        }
        catch (ServiceException e) {
            this.getLogger().error("Could not get parser", (Throwable)e);
            throw new ProcessingException("Exception in VelocityGenerator.generate()", (Throwable)e);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLogger().error("Could not get parser", (Throwable)e);
            throw new ProcessingException("Exception in VelocityGenerator.generate()", (Throwable)e);
        }
        finally {
            this.manager.release((Object)parser);
        }
    }

    public void init(RuntimeServices rs) throws Exception {
    }

    public void logVelocityMessage(int level, String message) {
        switch (level) {
            case 2: {
                this.getLogger().warn(message);
                break;
            }
            case 1: {
                this.getLogger().info(message);
                break;
            }
            case 0: {
                this.getLogger().debug(message);
                break;
            }
            case 3: {
                this.getLogger().error(message);
                break;
            }
            default: {
                this.getLogger().info(message);
            }
        }
    }

    public static class TemplateLoader
    extends ResourceLoader {
        private org.apache.avalon.framework.context.Context resolverContext;

        public void init(ExtendedProperties config) {
            this.resolverContext = (org.apache.avalon.framework.context.Context)config.get((Object)"context");
            if (this.resolverContext == null) {
                throw new IllegalArgumentException("Runtime Cocoon resolver context not specified in resource loader configuration.");
            }
        }

        public InputStream getResourceStream(String systemId) throws org.apache.velocity.exception.ResourceNotFoundException {
            try {
                return this.resolveSource(systemId).getInputStream();
            }
            catch (org.apache.velocity.exception.ResourceNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new org.apache.velocity.exception.ResourceNotFoundException("Unable to resolve source: " + ex);
            }
        }

        public boolean isSourceModified(Resource resource) {
            long lastModified = 0L;
            try {
                lastModified = this.resolveSource(resource.getName()).getLastModified();
            }
            catch (Exception ex) {
                this.rsvc.warn((Object)("Unable to determine last modified for resource: " + resource.getName() + ": " + ex));
            }
            return lastModified > 0L ? lastModified != resource.getLastModified() : true;
        }

        public long getLastModified(Resource resource) {
            long lastModified = 0L;
            try {
                lastModified = this.resolveSource(resource.getName()).getLastModified();
            }
            catch (Exception ex) {
                this.rsvc.warn((Object)("Unable to determine last modified for resource: " + resource.getName() + ": " + ex));
            }
            return lastModified;
        }

        private Source resolveSource(String systemId) throws org.apache.velocity.exception.ResourceNotFoundException {
            Map sourceCache;
            try {
                sourceCache = (Map)this.resolverContext.get((Object)VelocityGenerator.CONTEXT_SOURCE_CACHE_KEY);
            }
            catch (ContextException ignore) {
                throw new org.apache.velocity.exception.ResourceNotFoundException("Runtime Cocoon source cache not specified in resource loader resolver context.");
            }
            Source source = (Source)sourceCache.get(systemId);
            if (source == null) {
                try {
                    SourceResolver resolver = (SourceResolver)this.resolverContext.get((Object)VelocityGenerator.CONTEXT_RESOLVER_KEY);
                    source = resolver.resolveURI(systemId);
                }
                catch (ContextException ex) {
                    throw new org.apache.velocity.exception.ResourceNotFoundException("No Cocoon source resolver associated with current request.");
                }
                catch (Exception ex) {
                    throw new org.apache.velocity.exception.ResourceNotFoundException("Unable to resolve source: " + ex);
                }
            }
            sourceCache.put(systemId, source);
            return source;
        }
    }

    public static class JSIntrospector
    extends UberspectImpl {
        public Iterator getIterator(Object obj, Info i) throws Exception {
            if (!(obj instanceof Scriptable)) {
                return super.getIterator(obj, i);
            }
            if (obj instanceof NativeArray) {
                return new NativeArrayIterator((NativeArray)obj);
            }
            return new ScriptableIterator((Scriptable)obj);
        }

        public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) throws Exception {
            if (!(obj instanceof Scriptable)) {
                return super.getMethod(obj, methodName, args, i);
            }
            return new JSMethod((Scriptable)obj, methodName);
        }

        public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) throws Exception {
            if (!(obj instanceof Scriptable)) {
                return super.getPropertyGet(obj, identifier, i);
            }
            return new JSPropertyGet((Scriptable)obj, identifier);
        }

        public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) throws Exception {
            if (!(obj instanceof Scriptable)) {
                return super.getPropertySet(obj, identifier, arg, i);
            }
            return new JSPropertySet((Scriptable)obj, identifier);
        }

        public static class ScriptableIterator
        implements Iterator {
            Scriptable scope;
            Object[] ids;
            int index;

            public ScriptableIterator(Scriptable scope) {
                this.scope = scope;
                this.ids = scope.getIds();
                this.index = 0;
            }

            public boolean hasNext() {
                return this.index < this.ids.length;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object next() {
                org.mozilla.javascript.Context.enter();
                try {
                    Object result = ScriptableObject.getProperty((Scriptable)this.scope, (String)this.ids[this.index++].toString());
                    if (result == Undefined.instance || result == Scriptable.NOT_FOUND) {
                        result = null;
                    } else {
                        while (result instanceof Wrapper) {
                            result = ((Wrapper)result).unwrap();
                        }
                    }
                    Object object = result;
                    return object;
                }
                finally {
                    org.mozilla.javascript.Context.exit();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                org.mozilla.javascript.Context.enter();
                try {
                    this.scope.delete(this.ids[this.index].toString());
                }
                finally {
                    org.mozilla.javascript.Context.exit();
                }
            }
        }

        public static class NativeArrayIterator
        implements Iterator {
            NativeArray arr;
            int index;

            public NativeArrayIterator(NativeArray arr) {
                this.arr = arr;
                this.index = 0;
            }

            public boolean hasNext() {
                return this.index < (int)this.arr.jsGet_length();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object next() {
                org.mozilla.javascript.Context.enter();
                try {
                    Object result = this.arr.get(this.index++, (Scriptable)this.arr);
                    if (result == Undefined.instance || result == Scriptable.NOT_FOUND) {
                        result = null;
                    } else {
                        while (result instanceof Wrapper) {
                            result = ((Wrapper)result).unwrap();
                        }
                    }
                    Object object = result;
                    return object;
                }
                finally {
                    org.mozilla.javascript.Context.exit();
                }
            }

            public void remove() {
                this.arr.delete(this.index);
            }
        }

        public static class JSPropertySet
        implements VelPropertySet {
            Scriptable scope;
            String name;

            public JSPropertySet(Scriptable scope, String name) {
                this.scope = scope;
                this.name = name;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object thisArg, Object rhs) throws Exception {
                org.mozilla.javascript.Context.enter();
                try {
                    Object arg = rhs;
                    Scriptable thisObj = !(thisArg instanceof Scriptable) ? org.mozilla.javascript.Context.toObject((Object)thisArg, (Scriptable)this.scope) : (Scriptable)thisArg;
                    if (!(arg == null || arg instanceof Number || arg instanceof Boolean || arg instanceof String || arg instanceof Scriptable)) {
                        arg = org.mozilla.javascript.Context.toObject((Object)arg, (Scriptable)this.scope);
                    }
                    ScriptableObject.putProperty((Scriptable)thisObj, (String)this.name, (Object)arg);
                    Object object = rhs;
                    return object;
                }
                finally {
                    org.mozilla.javascript.Context.exit();
                }
            }

            public boolean isCacheable() {
                return false;
            }

            public String getMethodName() {
                return this.name;
            }
        }

        public static class JSPropertyGet
        implements VelPropertyGet {
            Scriptable scope;
            String name;

            public JSPropertyGet(Scriptable scope, String name) {
                this.scope = scope;
                this.name = name;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object thisArg) throws Exception {
                org.mozilla.javascript.Context.enter();
                try {
                    Scriptable thisObj = !(thisArg instanceof Scriptable) ? org.mozilla.javascript.Context.toObject((Object)thisArg, (Scriptable)this.scope) : (Scriptable)thisArg;
                    Object result = ScriptableObject.getProperty((Scriptable)thisObj, (String)this.name);
                    if (result == Undefined.instance || result == Scriptable.NOT_FOUND) {
                        result = null;
                    } else {
                        while (result instanceof Wrapper) {
                            result = ((Wrapper)result).unwrap();
                        }
                    }
                    Object object = result;
                    return object;
                }
                finally {
                    org.mozilla.javascript.Context.exit();
                }
            }

            public boolean isCacheable() {
                return false;
            }

            public String getMethodName() {
                return this.name;
            }
        }

        public static class JSMethod
        implements VelMethod {
            Scriptable scope;
            String name;

            public JSMethod(Scriptable scope, String name) {
                this.scope = scope;
                this.name = name;
            }

            public Object invoke(Object thisArg, Object[] args) throws Exception {
                org.mozilla.javascript.Context cx = org.mozilla.javascript.Context.enter();
                try {
                    Scriptable thisObj = !(thisArg instanceof Scriptable) ? org.mozilla.javascript.Context.toObject((Object)thisArg, (Scriptable)this.scope) : (Scriptable)thisArg;
                    Object result = ScriptableObject.getProperty((Scriptable)thisObj, (String)this.name);
                    Object[] newArgs = null;
                    if (args != null) {
                        newArgs = new Object[args.length];
                        for (int i = 0; i < args.length; ++i) {
                            newArgs[i] = args[i];
                            if (args[i] == null || args[i] instanceof Number || args[i] instanceof Boolean || args[i] instanceof String || args[i] instanceof Scriptable) continue;
                            newArgs[i] = org.mozilla.javascript.Context.toObject((Object)args[i], (Scriptable)this.scope);
                        }
                    }
                    if ((result = ScriptRuntime.call((org.mozilla.javascript.Context)cx, (Object)result, (Object)thisObj, (Object[])newArgs, (Scriptable)this.scope)) == Undefined.instance || result == Scriptable.NOT_FOUND) {
                        result = null;
                    } else {
                        while (result instanceof Wrapper) {
                            result = ((Wrapper)result).unwrap();
                        }
                    }
                    Object object = result;
                    return object;
                }
                catch (JavaScriptException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    org.mozilla.javascript.Context.exit();
                }
            }

            public boolean isCacheable() {
                return false;
            }

            public String getMethodName() {
                return this.name;
            }

            public Class getReturnType() {
                return class$java$lang$Object == null ? (class$java$lang$Object = VelocityGenerator.class$("java.lang.Object")) : class$java$lang$Object;
            }
        }
    }

    public static class ChainedContext
    extends VelocityContext {
        private Request request;
        private Response response;
        private Session session;
        private Context application;
        private Parameters parameters;
        public static final String REQUEST = "request";
        public static final String RESPONSE = "response";
        public static final String SESSION = "session";
        public static final String APPLICATION = "context";
        public static final String PARAMETERS = "parameters";

        public ChainedContext(org.apache.velocity.context.Context ctx, Request request, Response response, Context application, Parameters parameters) {
            super(null, ctx);
            this.request = request;
            this.response = response;
            this.session = request.getSession(false);
            this.application = application;
            this.parameters = parameters;
        }

        public Object internalGet(String key) {
            if (key.equals(REQUEST)) {
                return this.request;
            }
            if (key.equals(RESPONSE)) {
                return this.response;
            }
            if (key.equals(SESSION)) {
                return this.session;
            }
            if (key.equals(APPLICATION)) {
                return this.application;
            }
            if (key.equals(PARAMETERS)) {
                return this.parameters;
            }
            Object o = null;
            o = super.internalGet(key);
            if (o == null && (o = this.request.getAttribute(key)) == null) {
                if (this.session != null) {
                    o = this.session.getAttribute(key);
                }
                if (o == null) {
                    o = this.application.getAttribute(key);
                }
            }
            return o;
        }
    }
}

