/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import org.exolab.castor.xml.XMLFieldDescriptor;

public class XMLFieldDescriptors {
    private int DEFAULT_SIZE;
    private XMLFieldDescriptor[] elements;
    private int initialSize;
    private int elementCount;

    public XMLFieldDescriptors() {
        this.initialSize = this.DEFAULT_SIZE = 11;
        this.elementCount = 0;
        this.elements = new XMLFieldDescriptor[this.DEFAULT_SIZE];
    }

    public XMLFieldDescriptors(int size) {
        this.initialSize = this.DEFAULT_SIZE = 11;
        this.elementCount = 0;
        this.initialSize = size;
        this.elements = new XMLFieldDescriptor[size];
    }

    public boolean add(XMLFieldDescriptor descriptor) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (this.elements[i] != descriptor) continue;
            return false;
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        this.elements[this.elementCount++] = descriptor;
        return true;
    }

    public void clear() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elements[i] = null;
        }
        this.elementCount = 0;
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return obj;
    }

    public boolean contains(XMLFieldDescriptor descriptor) {
        return this.indexOf(descriptor) >= 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XMLFieldDescriptors)) {
            return false;
        }
        XMLFieldDescriptors descs = (XMLFieldDescriptors)obj;
        if (descs.elementCount != this.elementCount) {
            return false;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            XMLFieldDescriptor e1 = this.get(i);
            XMLFieldDescriptor e2 = descs.elements[i];
            if (e1 != null ? e1.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    public XMLFieldDescriptor get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[index];
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.elementCount; ++i) {
            XMLFieldDescriptor obj = this.elements[i];
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public int indexOf(XMLFieldDescriptor descriptor) {
        if (descriptor == null) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.elementCount; ++i) {
                if (!descriptor.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public XMLFieldDescriptor remove(int index) {
        if (index < 0 || index > this.elementCount) {
            return null;
        }
        XMLFieldDescriptor desc = this.elements[index];
        this.shiftDown(index + 1);
        --this.elementCount;
        return desc;
    }

    public boolean remove(XMLFieldDescriptor descriptor) {
        int index = this.indexOf(descriptor);
        if (index > -1) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public void trimToSize() {
        if (this.elements.length == this.elementCount) {
            return;
        }
        XMLFieldDescriptor[] pointer = this.elements;
        this.elements = new XMLFieldDescriptor[this.elementCount];
        System.arraycopy(pointer, 0, this.elements, 0, this.elementCount);
        pointer = null;
    }

    public int size() {
        return this.elementCount;
    }

    public XMLFieldDescriptor[] toArray() {
        XMLFieldDescriptor[] objArray = new XMLFieldDescriptor[this.elementCount];
        System.arraycopy(this.elements, 0, objArray, 0, this.elementCount);
        return objArray;
    }

    public XMLFieldDescriptor[] toArray(XMLFieldDescriptor[] dst) {
        return this.toArray(dst, 0);
    }

    public XMLFieldDescriptor[] toArray(XMLFieldDescriptor[] dst, int offset) {
        XMLFieldDescriptor[] objArray = null;
        objArray = dst.length >= this.elementCount ? dst : new XMLFieldDescriptor[this.elementCount];
        System.arraycopy(this.elements, 0, objArray, offset, this.elementCount);
        return objArray;
    }

    private void increaseSize() {
        XMLFieldDescriptor[] pointer = this.elements;
        int length = pointer.length > 0 ? pointer.length : 1;
        this.elements = new XMLFieldDescriptor[length * 3 / 2 + 1];
        System.arraycopy(pointer, 0, this.elements, 0, pointer.length);
        pointer = null;
    }

    private void shiftDown(int index) {
        if (index <= 0 || index >= this.elementCount) {
            return;
        }
        System.arraycopy(this.elements, index, this.elements, index - 1, this.elementCount - index);
        this.elements[this.elementCount - 1] = null;
    }

    private void shiftUp(int index) {
        if (index == this.elementCount) {
            return;
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        System.arraycopy(this.elements, index, this.elements, index + 1, this.elementCount - index);
    }
}

