/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.memory.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.memory.util.DoubleLinkedListNode;

public class DoubleLinkedList {
    int size = 0;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$memory$util$DoubleLinkedList == null ? (class$org$apache$jcs$engine$memory$util$DoubleLinkedList = DoubleLinkedList.class$("org.apache.jcs.engine.memory.util.DoubleLinkedList")) : class$org$apache$jcs$engine$memory$util$DoubleLinkedList));
    private DoubleLinkedListNode first;
    private DoubleLinkedListNode last;
    static /* synthetic */ Class class$org$apache$jcs$engine$memory$util$DoubleLinkedList;

    public void addLast(DoubleLinkedListNode me) {
        if (this.first == null) {
            this.first = me;
        } else {
            this.last.next = me;
            me.prev = this.last;
        }
        this.last = me;
        ++this.size;
    }

    public synchronized void addFirst(DoubleLinkedListNode me) {
        if (this.last == null) {
            this.last = me;
        } else {
            this.first.prev = me;
            me.next = this.first;
        }
        this.first = me;
        ++this.size;
    }

    public DoubleLinkedListNode getLast() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"returning last node");
        }
        return this.last;
    }

    public DoubleLinkedListNode getFirst() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"returning fist node");
        }
        return this.first;
    }

    public synchronized void makeFirst(DoubleLinkedListNode ln) {
        if (ln.prev == null) {
            return;
        }
        ln.prev.next = ln.next;
        if (ln.next == null) {
            this.last = ln.prev;
            this.last.next = null;
        } else {
            ln.next.prev = ln.prev;
        }
        this.first.prev = ln;
        ln.next = this.first;
        ln.prev = null;
        this.first = ln;
    }

    public synchronized void removeAll() {
        DoubleLinkedListNode me = this.first;
        while (me != null) {
            DoubleLinkedListNode next;
            if (me.prev != null) {
                me.prev = null;
            }
            me = next = me.next;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public synchronized boolean remove(DoubleLinkedListNode me) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removing node");
        }
        if (me.next == null) {
            if (me.prev == null) {
                if (me == this.first && me == this.last) {
                    this.last = null;
                    this.first = null;
                }
            } else {
                this.last = me.prev;
                this.last.next = null;
                me.prev = null;
            }
        } else if (me.prev == null) {
            this.first = me.next;
            this.first.prev = null;
            me.next = null;
        } else {
            me.prev.next = me.next;
            me.next.prev = me.prev;
            me.next = null;
            me.prev = null;
        }
        --this.size;
        return true;
    }

    public DoubleLinkedListNode removeLast() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removing last node");
        }
        DoubleLinkedListNode temp = this.last;
        if (this.last != null) {
            this.remove(this.last);
        }
        return temp;
    }

    public int size() {
        return this.size;
    }

    public void debugDumpEntries() {
        log.debug((Object)"dumping Entries");
        DoubleLinkedListNode me = this.first;
        while (me != null) {
            log.debug((Object)("dump Entries> payload= '" + me.payload + "'"));
            me = me.next;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

