/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.client.xmldb;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.client.xmldb.CommonConfigurable;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class DatabaseImpl
extends CommonConfigurable
implements Database {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$client$xmldb$DatabaseImpl == null ? (class$org$apache$xindice$client$xmldb$DatabaseImpl = DatabaseImpl.class$("org.apache.xindice.client.xmldb.DatabaseImpl")) : class$org$apache$xindice$client$xmldb$DatabaseImpl));
    protected Database driver;
    public static final String XMLRPC_URI = "xindice://";
    public static final String EMBED_URI = "xindice-embed://";
    public static final String MANAGED_URI = "xindice-managed://";
    public static final String INSTANCE_NAME = "xindice, xindice-embed, xindice-managed";
    private static final String[] INSTANCE_NAMES = new String[]{"xindice", "xindice-embed", "xindice-managed"};
    public static final String CONFORMANCE_LEVEL = "0";
    static /* synthetic */ Class class$org$apache$xindice$client$xmldb$DatabaseImpl;

    public String getName() throws XMLDBException {
        return INSTANCE_NAME;
    }

    public String[] getNames() throws XMLDBException {
        return INSTANCE_NAMES;
    }

    public Collection getCollection(String uri, String username, String password) throws XMLDBException {
        this.createDriver(uri);
        return this.driver.getCollection(uri, username, password);
    }

    public String getConformanceLevel() throws XMLDBException {
        return CONFORMANCE_LEVEL;
    }

    public boolean acceptsURI(String uri) throws XMLDBException {
        if (uri != null && uri.length() > 0 && this.knownPrefix(uri)) {
            this.createDriver(uri);
            return this.driver.acceptsURI(uri);
        }
        return false;
    }

    protected void createDriver(String uri) throws XMLDBException {
        if (this.driver == null) {
            if (uri == null) {
                throw new XMLDBException(5, 801, "The URI is null");
            }
            if (uri.startsWith(XMLRPC_URI)) {
                this.driver = new org.apache.xindice.client.xmldb.xmlrpc.DatabaseImpl(this);
            } else if (uri.startsWith(EMBED_URI)) {
                this.driver = new org.apache.xindice.client.xmldb.embed.DatabaseImpl(this);
            } else if (uri.startsWith(MANAGED_URI)) {
                this.driver = new org.apache.xindice.client.xmldb.managed.DatabaseImpl(this);
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("The URI '" + uri + "' is not handled by Xindice"));
                }
                throw new XMLDBException(5, 800, "The URI '" + uri + "' is not handled by Xindice");
            }
        }
    }

    protected boolean knownPrefix(String uri) {
        return uri.startsWith(XMLRPC_URI) || uri.startsWith(EMBED_URI) || uri.startsWith(MANAGED_URI);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

