/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.client.xmldb.embed;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.xindice.client.xmldb.ResourceSetImpl;
import org.apache.xindice.client.xmldb.XindiceCollection;
import org.apache.xindice.client.xmldb.resources.BinaryResourceImpl;
import org.apache.xindice.client.xmldb.resources.XMLResourceImpl;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.Database;
import org.apache.xindice.core.FaultCodes;
import org.apache.xindice.core.data.NodeSet;
import org.apache.xindice.core.meta.MetaData;
import org.apache.xindice.core.query.QueryUtil;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.XMLResource;

public class CollectionImpl
extends XindiceCollection {
    private Database db = null;
    private Collection col = null;

    public CollectionImpl(Database db, String collPath) throws XMLDBException {
        super(collPath);
        this.db = db;
        String collName = "/";
        int colIndex = collPath.indexOf(47, 1);
        if (colIndex != -1 && (collName = collPath.substring(colIndex)).equals("")) {
            collName = "/";
        }
        try {
            this.col = db.getCollection(collName);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(201, "Collection not available: " + collPath, e);
        }
        if (this.col == null) {
            throw new XMLDBException(200, "Collection not found: " + collPath);
        }
    }

    public Resource getResource(String id) throws XMLDBException {
        this.checkOpen();
        try {
            Object entry = this.col.getEntry(id);
            if (entry == null) {
                return null;
            }
            if (entry instanceof Document) {
                DocumentImpl doc = (DocumentImpl)entry;
                return new XMLResourceImpl(id, id, this, doc.getSymbols(), doc.getDataBytes());
            }
            if (entry instanceof byte[]) {
                return new BinaryResourceImpl(id, this, (byte[])entry);
            }
            throw new XMLDBException(302, "Internal error: Unexpected resource type " + entry.getClass().getName());
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException("Resource not available: " + id, e);
        }
    }

    public int getResourceCount() throws XMLDBException {
        this.checkOpen();
        try {
            return (int)this.col.getDocumentCount();
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void storeResource(Resource res) throws XMLDBException {
        if (res.getContent() == null) {
            throw new XMLDBException(301, "No resource data");
        }
        this.checkOpen();
        if (res instanceof BinaryResource) {
            Object content = res.getContent();
            if (!(content instanceof byte[])) {
                throw new XMLDBException(301, "The contents of a binary resource must have type byte[].");
            }
            byte[] bytes = (byte[])content;
            try {
                if (res.getId() != null) {
                    this.col.insertBinary(res.getId(), bytes);
                }
                String name = this.col.insertBinary(bytes).toString();
                ((BinaryResourceImpl)res).setId(name);
            }
            catch (Exception e) {
                throw FaultCodes.createXMLDBException(301, "Invalid resource:" + res.getId(), e);
            }
        } else if (res instanceof XMLResource) {
            try {
                String name = "";
                Node content = ((XMLResourceImpl)res).getContentAsDOM();
                if (content != null && content instanceof Document) {
                    if (res.getId() != null) {
                        this.col.insertDocument(res.getId(), (Document)content);
                    }
                    name = this.col.insertDocument((Document)content).toString();
                    ((XMLResourceImpl)res).setId(name);
                }
                throw new XMLDBException(301, "A resource must be a document in order to be stored.");
            }
            catch (Exception e) {
                throw FaultCodes.createXMLDBException(301, "Invalid resource: " + res.getId(), e);
            }
        } else {
            throw new XMLDBException(301, "Only XMLResource and BinaryResource supported");
        }
    }

    public boolean isOpen() {
        return this.col != null;
    }

    public String getURI() {
        return "xmldb:xindice-embed://" + this.getCanonicalName();
    }

    public org.xmldb.api.base.Collection getChildCollection(String name) throws XMLDBException {
        if (name.indexOf(47) != -1) {
            throw new XMLDBException(201, "Invalid collection: " + name);
        }
        try {
            return new CollectionImpl(this.db, this.getCanonicalName() + "/" + name);
        }
        catch (XMLDBException e) {
            if (e.errorCode == 200) {
                return null;
            }
            throw e;
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(201, "Invalid collection: " + name, e);
        }
    }

    public String createId() throws XMLDBException {
        this.checkOpen();
        try {
            return this.col.createNewOID().toString();
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void close() throws XMLDBException {
        this.col = null;
        this.db.flushConfig();
    }

    public org.xmldb.api.base.Collection getParentCollection() throws XMLDBException {
        if (this.collPath.lastIndexOf("/") == 0) {
            return null;
        }
        try {
            return new CollectionImpl(this.db, this.collPath.substring(0, this.collPath.lastIndexOf(47)));
        }
        catch (XMLDBException e) {
            if (e.errorCode == 200) {
                return null;
            }
            throw e;
        }
    }

    public void removeResource(Resource res) throws XMLDBException {
        if (res == null || res.getId() == null || res.getId().length() == 0) {
            throw new XMLDBException(301, "Resource passed is null or its ID is empty.");
        }
        this.checkOpen();
        try {
            this.col.remove(res.getId());
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public String[] listChildCollections() throws XMLDBException {
        this.checkOpen();
        try {
            return this.col.listCollections();
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public int getChildCollectionCount() throws XMLDBException {
        this.checkOpen();
        try {
            return (int)this.col.countCollections();
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public String[] listResources() throws XMLDBException {
        this.checkOpen();
        try {
            return this.col.listDocuments();
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public ResourceSet query(String name, String queryLang, String query, Hashtable nsMap) throws XMLDBException {
        this.checkOpen();
        try {
            NodeSet nodeSet = name != null ? this.col.queryDocument(queryLang, query, QueryUtil.mapNamespaces(nsMap), name) : this.col.queryCollection(queryLang, query, QueryUtil.mapNamespaces(nsMap));
            return new ResourceSetImpl(this, QueryUtil.queryResultsToDOM(nodeSet));
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(641, "Query error: " + e.getMessage(), e);
        }
    }

    public org.xmldb.api.base.Collection createCollection(String name) throws XMLDBException {
        this.checkOpen();
        try {
            DocumentImpl doc = new DocumentImpl();
            Element colEle = doc.createElement("collection");
            colEle.setAttribute("compressed", "true");
            colEle.setAttribute("name", name);
            doc.appendChild(colEle);
            Element filEle = doc.createElement("filer");
            filEle.setAttribute("class", "org.apache.xindice.core.filer.BTreeFiler");
            colEle.appendChild(filEle);
            return this.createCollection(name, doc);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(201, 0, "Cannot create child collection", e);
        }
    }

    public org.xmldb.api.base.Collection createCollection(String path, Document configuration) throws XMLDBException {
        this.checkOpen();
        try {
            Configuration config = new Configuration(configuration.getDocumentElement(), false);
            this.col.createCollection(path, config);
            CollectionImpl col = this;
            if (path.indexOf("/") != -1) {
                StringTokenizer st = new StringTokenizer(path, "/");
                while (col != null && st.hasMoreTokens()) {
                    path = st.nextToken().trim();
                    if (path.length() == 0) continue;
                    if (!st.hasMoreTokens()) break;
                    col = col.getChildCollection(path);
                }
            }
            return col.getChildCollection(path);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(201, 0, "Cannot create child collection", e);
        }
    }

    public void removeCollection(String childName) throws XMLDBException {
        if (null == childName || childName.length() == 0) {
            throw new XMLDBException(200, 200, "Cannot remove child collection '" + childName + "': Name is empty");
        }
        this.checkOpen();
        try {
            this.col.dropCollection(this.col.getCollection(childName));
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(201, 0, "Cannot remove child collection '" + childName + "'", e);
        }
    }

    public String[] listIndexers() throws XMLDBException {
        this.checkOpen();
        try {
            return this.col.listIndexers();
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void createIndexer(Document configuration) throws XMLDBException {
        this.checkOpen();
        try {
            this.col.createIndexer(new Configuration(configuration, false));
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void dropIndexer(String name) throws XMLDBException {
        this.checkOpen();
        try {
            this.col.dropIndexer(this.col.getIndexer(name));
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void shutdown() throws XMLDBException {
        try {
            this.db.close();
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public MetaData getMetaData(String id) throws XMLDBException {
        try {
            if (id == null) {
                return this.col.getCollectionMeta();
            }
            return this.col.getDocumentMeta(id);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void setMetaData(String id, MetaData meta) throws XMLDBException {
        try {
            if (id == null) {
                this.col.setCollectionMeta(meta);
            } else {
                this.col.setDocumentMeta(id, meta);
            }
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }
}

