/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.client.xmldb.xmlrpc;

import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.client.xmldb.CommonConfigurable;
import org.apache.xindice.client.xmldb.xmlrpc.CollectionImpl;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class DatabaseImpl
extends CommonConfigurable
implements Database {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$client$xmldb$xmlrpc$DatabaseImpl == null ? (class$org$apache$xindice$client$xmldb$xmlrpc$DatabaseImpl = DatabaseImpl.class$("org.apache.xindice.client.xmldb.xmlrpc.DatabaseImpl")) : class$org$apache$xindice$client$xmldb$xmlrpc$DatabaseImpl));
    private static final String PROP_SERVICE_LOCATION = "service-location";
    private static final String SYSPROP_SERVICE_LOCATION = "xindice.xmlrpc.service-location";
    private static final String PROP_XMLRPC_DRIVER = "xmlrpc-driver";
    private static final String SYSPROP_XMLRPC_DRIVER = "xindice.xmlrpc.driver";
    private static final String PROP_XMLRPC_USER = "xmlrpc-user";
    private static final String SYSPROP_XMLRPC_USER = "xindice.xmlrpc.user";
    private static final String PROP_XMLRPC_PASSWORD = "xmlrpc-password";
    private static final String SYSPROP_XMLRPC_PASSWORD = "xindice.xmlrpc.password";
    private static final String DEFAULT_XMLRPC_DRIVER = "xerces";
    private static final String DEFAULT_SERVICE_LOCATION = "/xindice/";
    public static final String DRIVER_NAME = "xindice";
    private static final String CONFORMANCE_LEVEL = "0";
    private static boolean xmlRpcInitialized;
    private String serviceLocation;
    private String basicUser;
    private String basicPassword;
    static /* synthetic */ Class class$org$apache$xindice$client$xmldb$xmlrpc$DatabaseImpl;

    public DatabaseImpl() {
    }

    public DatabaseImpl(CommonConfigurable config) {
        super(config);
    }

    public boolean acceptsURI(String uri) throws XMLDBException {
        return uri != null && uri.startsWith(this.getName() + "://");
    }

    private void initialize() throws XMLDBException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!xmlRpcInitialized) {
                XmlRpc.setEncoding((String)"UTF8");
                XmlRpc.setKeepAlive((boolean)true);
                String xmlrpcDriver = this.getProperty(PROP_XMLRPC_DRIVER);
                if (xmlrpcDriver == null && (xmlrpcDriver = System.getProperty(SYSPROP_XMLRPC_DRIVER)) == null) {
                    xmlrpcDriver = DEFAULT_XMLRPC_DRIVER;
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using SAX Driver: '" + xmlrpcDriver + "'"));
                    }
                    XmlRpc.setDriver((String)xmlrpcDriver);
                }
                catch (Exception e) {
                    throw new XMLDBException(1, "SAX Driver " + xmlrpcDriver + " is not available", (Throwable)e);
                }
            }
            xmlRpcInitialized = true;
        }
    }

    private XmlRpcClient connect(String hostPort) throws XMLDBException {
        this.initialize();
        DatabaseImpl databaseImpl = this;
        synchronized (databaseImpl) {
            if (this.serviceLocation == null) {
                this.serviceLocation = this.getProperty(PROP_SERVICE_LOCATION);
                if (this.serviceLocation == null) {
                    this.serviceLocation = System.getProperty(SYSPROP_SERVICE_LOCATION);
                    if (this.serviceLocation == null) {
                        this.serviceLocation = DEFAULT_SERVICE_LOCATION;
                    }
                }
                if (!this.serviceLocation.startsWith("/")) {
                    this.serviceLocation = "/" + this.serviceLocation;
                }
                if (!this.serviceLocation.endsWith("/")) {
                    this.serviceLocation = this.serviceLocation + "/";
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using Service Location: '" + this.serviceLocation + "'"));
                }
                this.basicUser = this.getProperty(PROP_XMLRPC_USER);
                if (this.basicUser == null) {
                    this.basicUser = System.getProperty(SYSPROP_XMLRPC_USER);
                }
                if (this.basicUser != null) {
                    this.basicPassword = this.getProperty(PROP_XMLRPC_PASSWORD);
                    if (this.basicPassword == null) {
                        this.basicPassword = System.getProperty(SYSPROP_XMLRPC_PASSWORD);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using Basic authentication. User: '" + this.basicUser + "', password: '" + this.basicPassword + "'"));
                    }
                }
            }
        }
        String xmlRpcURL = "http://" + hostPort + this.serviceLocation;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using URI: '" + xmlRpcURL + "'"));
            }
            XmlRpcClient client = new XmlRpcClient(xmlRpcURL);
            if (this.basicUser != null) {
                client.setBasicAuthentication(this.basicUser, this.basicPassword);
            }
            return client;
        }
        catch (MalformedURLException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public Collection getCollection(String uri, String userName, String password) throws XMLDBException {
        if (!this.acceptsURI(uri)) {
            throw new XMLDBException(5, "Invalid URL: " + uri);
        }
        int firstSlash = (uri = uri.substring(this.getName().length() + 3)).indexOf(47);
        if (firstSlash == -1) {
            throw new XMLDBException(5, "Invalid URL (must have '/'): " + uri);
        }
        String collPath = uri.substring(firstSlash);
        if (!collPath.startsWith("/")) {
            throw new XMLDBException(5, "Invalid URL (collection name must start with '/'): " + uri);
        }
        String hostPort = uri.substring(0, firstSlash);
        if (hostPort.equals("")) {
            hostPort = "127.0.0.1:8888";
        }
        try {
            return new CollectionImpl(this.connect(hostPort), collPath);
        }
        catch (XMLDBException e) {
            if (e.errorCode == 200) {
                return null;
            }
            throw e;
        }
    }

    public String getName() throws XMLDBException {
        return DRIVER_NAME;
    }

    public String[] getNames() throws XMLDBException {
        return new String[]{this.getName()};
    }

    public String getConformanceLevel() throws XMLDBException {
        return CONFORMANCE_LEVEL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

