/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.meta;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.xml.TextWriter;
import org.apache.xindice.xml.XMLSerializable;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaData
implements XMLSerializable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$meta$MetaData == null ? (class$org$apache$xindice$core$meta$MetaData = MetaData.class$("org.apache.xindice.core.meta.MetaData")) : class$org$apache$xindice$core$meta$MetaData));
    public static final short UNKNOWN = 0;
    public static final short COLLECTION = 1;
    public static final short DOCUMENT = 2;
    public static final short LINK = 3;
    public static final String NS_URI = "http://apache.org/xindice/metadata";
    public static final boolean USE_NS = true;
    private static final String E_META = "meta";
    private static final String E_SYSTEM = "system";
    private static final String E_ATTRS = "attrs";
    private static final String E_ATTR = "attr";
    private static final String E_CUSTOM = "custom";
    private static final String E_CREATED = "created";
    private static final String E_MODIFIED = "modified";
    private static final String A_NAME = "name";
    private static final String A_VALUE = "value";
    private static final String A_TYPE = "type";
    private static final String A_HREF = "href";
    private static final Enumeration EMPTY = new Vector().elements();
    private transient boolean dirty;
    private transient long created;
    private transient long modified;
    private transient String owner;
    private short type = 0;
    private String link;
    private Hashtable attrs;
    private Document custom;
    static /* synthetic */ Class class$org$apache$xindice$core$meta$MetaData;

    public MetaData() {
    }

    public MetaData(String owner) {
        this.owner = owner;
    }

    public MetaData(short type, String owner, long created, long modified) {
        this.type = type;
        this.owner = owner;
        this.created = created;
        this.modified = modified;
    }

    public MetaData(Element elem) {
        this.streamFromXML(elem);
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public long getCreatedTime() {
        return this.created;
    }

    public long getLastModifiedTime() {
        return this.modified;
    }

    public short getType() {
        return this.type;
    }

    public String getOwner() {
        return this.owner;
    }

    public Enumeration getAttributeKeys() {
        if (null == this.attrs) {
            return EMPTY;
        }
        return this.attrs.keys();
    }

    public Object getAttribute(Object name) {
        if (null == this.attrs) {
            return null;
        }
        return this.attrs.get(name);
    }

    public Boolean getAttributeAsBoolean(Object name) {
        Object o = this.getAttribute(name);
        if (null == o) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return new Boolean(n.intValue() != 0);
        }
        return Boolean.valueOf(o.toString());
    }

    public Integer getAttributeAsInteger(Object name) {
        Object o = this.getAttribute(name);
        if (null == o) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return new Integer(n.intValue());
        }
        try {
            int v = Integer.parseInt(o.toString());
            return new Integer(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getAttributeAsLong(Object name) {
        Object o = this.getAttribute(name);
        if (null == o) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return new Long(n.longValue());
        }
        try {
            long v = Long.parseLong(o.toString());
            return new Long(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Short getAttributeAsShort(Object name) {
        Object o = this.getAttribute(name);
        if (null == o) {
            return null;
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return new Short(n.shortValue());
        }
        try {
            short v = Short.parseShort(o.toString());
            return new Short(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object setAttribute(Object name, Object value) {
        Object prev;
        if (null == this.attrs) {
            this.attrs = new Hashtable();
            this.dirty = true;
        }
        if ((prev = this.attrs.put(name, value)) == null || !prev.equals(value)) {
            this.dirty = true;
        }
        return prev;
    }

    public Object removeAttribute(Object name) {
        if (null == this.attrs) {
            return null;
        }
        Object prev = this.attrs.remove(name);
        if (null != prev) {
            this.dirty = true;
        }
        return prev;
    }

    public Document getCustomDocument() {
        return this.custom;
    }

    public void setCustomDocument(Document doc) {
        this.custom = doc;
        this.dirty = true;
    }

    public void copyFrom(MetaData meta) {
        this.created = meta.getCreatedTime();
        this.modified = meta.getLastModifiedTime();
        this.owner = meta.getOwner();
        this.type = meta.getType();
        this.copyDataFrom(meta);
    }

    public void copyDataFrom(MetaData meta) {
        this.link = meta.getLinkTargetURI();
        this.attrs = null;
        Enumeration e = meta.getAttributeKeys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = meta.getAttribute(key);
            if (null == this.attrs) {
                this.attrs = new Hashtable();
            }
            this.attrs.put(key, value);
        }
        this.custom = null;
        Document doc = meta.getCustomDocument();
        if (null != doc) {
            this.custom = new DocumentImpl();
            this.custom.appendChild(this.custom.importNode(doc.getDocumentElement(), true));
        }
        this.dirty = false;
    }

    public String getLinkTargetURI() {
        return this.link;
    }

    public final Element streamToXML(Document doc) throws DOMException {
        return this.streamToXML(doc, true);
    }

    public final Element streamToXML(Document doc, boolean includeTime) throws DOMException {
        Element root = null;
        root = doc.createElementNS(NS_URI, E_META);
        root.setAttribute("xmlns", NS_URI);
        Element systemElement = null;
        systemElement = doc.createElementNS(NS_URI, E_SYSTEM);
        systemElement.setAttribute(A_TYPE, MetaData.getTypeString(this.type));
        root.appendChild(systemElement);
        if (includeTime) {
            if (this.created > 0L) {
                String message = "Create time is " + new Date(this.created);
                Comment comment = doc.createComment(message);
                systemElement.appendChild(comment);
            }
            Element timeElement = null;
            timeElement = doc.createElementNS(NS_URI, E_ATTR);
            timeElement.setAttribute(A_NAME, E_CREATED);
            timeElement.setAttribute(A_VALUE, Long.toString(this.created));
            systemElement.appendChild(timeElement);
            if (this.modified > 0L) {
                String message = "Modified time is " + new Date(this.modified);
                Comment comment = doc.createComment(message);
                systemElement.appendChild(comment);
            }
            timeElement = doc.createElementNS(NS_URI, E_ATTR);
            timeElement.setAttribute(A_NAME, E_MODIFIED);
            timeElement.setAttribute(A_VALUE, Long.toString(this.modified));
            systemElement.appendChild(timeElement);
        }
        if (null != this.link) {
            systemElement.setAttribute(A_HREF, this.link);
        }
        if (null != this.attrs && this.attrs.size() > 0) {
            Element attrsElement = null;
            attrsElement = doc.createElementNS(NS_URI, E_ATTRS);
            root.appendChild(attrsElement);
            Enumeration e = this.attrs.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = this.attrs.get(key);
                if (null == key) continue;
                Element attrElement = null;
                attrElement = doc.createElementNS(NS_URI, E_ATTR);
                attrsElement.appendChild(attrElement);
                attrElement.setAttribute(A_NAME, key.toString());
                if (null == value) continue;
                attrElement.setAttribute(A_VALUE, value.toString());
            }
        }
        if (null != this.custom) {
            Element customElement = null;
            customElement = doc.createElementNS(NS_URI, E_CUSTOM);
            root.appendChild(doc.importNode(this.custom.getDocumentElement(), true));
        }
        return root;
    }

    public final void streamFromXML(Element source) throws DOMException {
        this.streamFromXML(source, true);
    }

    public final void streamFromXML(Element source, boolean includeTime) throws DOMException {
        this.link = null;
        this.attrs = null;
        this.custom = null;
        String systemElemName = E_SYSTEM;
        String attrsElemName = E_ATTRS;
        String customElemName = E_CUSTOM;
        String attrElemName = E_ATTR;
        NodeList list = source.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String elementName = element.getNodeName();
                if (systemElemName.equals(elementName)) {
                    String attrStr = element.getAttribute(A_TYPE);
                    if (null != attrStr) {
                        this.type = MetaData.parseTypeString(attrStr);
                    }
                    if (this.type == 3) {
                        this.link = element.getAttribute(A_HREF);
                    }
                    if (includeTime) {
                        NodeList children = element.getChildNodes();
                        int j = 0;
                        while (j < children.getLength()) {
                            Node childNode = children.item(j);
                            if (childNode instanceof Element) {
                                Element child = (Element)childNode;
                                String childName = child.getNodeName();
                                if (attrElemName.equals(childName)) {
                                    String nameStr = child.getAttribute(A_NAME);
                                    String valueStr = child.getAttribute(A_VALUE);
                                    if (null != nameStr && null != valueStr) {
                                        if (E_CREATED.equals(nameStr)) {
                                            this.created = Long.parseLong(valueStr);
                                        } else if (E_MODIFIED.equals(nameStr)) {
                                            this.modified = Long.parseLong(valueStr);
                                        }
                                    }
                                } else if (log.isDebugEnabled()) {
                                    log.debug((Object)("Ignorning unknown child elem " + childName));
                                }
                            }
                            ++j;
                        }
                    }
                } else if (attrsElemName.equals(elementName)) {
                    NodeList attrList = element.getElementsByTagName(attrElemName);
                    int j = 0;
                    while (j < attrList.getLength()) {
                        Element e = (Element)attrList.item(j);
                        String attrName = e.getAttribute(A_NAME);
                        if (null != attrName) {
                            if (null == this.attrs) {
                                this.attrs = new Hashtable();
                            }
                            this.attrs.put(attrName, e.getAttribute(A_VALUE));
                        }
                        ++j;
                    }
                } else if (customElemName.equals(elementName)) {
                    this.custom = new DocumentImpl();
                    Node custdoc = this.custom.importNode(element, true);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Appending custom element " + elementName + "\nwhose complete original content is: \n" + TextWriter.toString(source) + "\nwhose original content is: \n" + TextWriter.toString(element) + "\nwhose imported content is: \n" + TextWriter.toString(custdoc)));
                    }
                    this.custom.appendChild(custdoc);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("ignoring unknown xml element " + elementName));
                }
            }
            ++i;
        }
    }

    public static String getTypeString(short type) {
        switch (type) {
            case 2: {
                return "doc";
            }
            case 1: {
                return "col";
            }
            case 3: {
                return "link";
            }
        }
        return "none";
    }

    public static short parseTypeString(String str) {
        if (str.equalsIgnoreCase("doc")) {
            return 2;
        }
        if (str.equalsIgnoreCase("col")) {
            return 1;
        }
        if (str.equalsIgnoreCase("link")) {
            return 3;
        }
        return 0;
    }

    public boolean hasContext() {
        return this.created > 0L || this.modified > 0L;
    }

    public void setContext(long created, long modified) {
        if (created > 0L) {
            this.created = created;
        }
        if (modified > 0L) {
            this.modified = modified;
        }
    }

    public void setType(short type) {
        if (this.type != type) {
            this.type = type;
            this.dirty = true;
        }
    }

    public void setOwner(String owner) {
        if (owner != this.owner || null == owner || null == this.owner || !owner.equals(this.owner)) {
            this.owner = owner;
            this.dirty = true;
        }
    }

    public void setLinkTargetURI(String link) {
        if (link != this.link || null == link || null == this.link || !link.equals(this.link)) {
            this.link = link;
            this.dirty = true;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("META[");
        buffer.append(MetaData.getTypeString(this.type));
        if (this.owner != null) {
            buffer.append(" owner=").append(this.owner);
        }
        if (this.created > 0L) {
            buffer.append(" created=").append(new Date(this.created));
        }
        if (this.modified > 0L) {
            buffer.append(" modified=").append(new Date(this.modified));
        }
        if (this.link != null) {
            buffer.append(" link=").append(this.link);
        }
        if (this.attrs != null) {
            buffer.append(" attrs=").append(this.attrs);
        }
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

