/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.Database;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.NodeSet;
import org.apache.xindice.core.indexer.IndexMatch;
import org.apache.xindice.core.query.Query;
import org.apache.xindice.core.query.QueryException;
import org.apache.xindice.core.query.QueryResolver;
import org.apache.xindice.core.query.StyleNotFoundException;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.ConfigurationCallback;
import org.apache.xindice.util.SimpleConfigurable;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.NamespaceMap;

public class QueryEngine
extends SimpleConfigurable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$query$QueryEngine == null ? (class$org$apache$xindice$core$query$QueryEngine = QueryEngine.class$("org.apache.xindice.core.query.QueryEngine")) : class$org$apache$xindice$core$query$QueryEngine));
    private static final String[] EmptyStrings = new String[0];
    private static final Key[] EmptyKeys = new Key[0];
    private static final String RESOLVER = "resolver";
    private static final String CLASS = "class";
    private Database db;
    private Map resolvers = new HashMap();
    static /* synthetic */ Class class$org$apache$xindice$core$query$QueryEngine;

    public QueryEngine(Database db) {
        this.db = db;
    }

    public void setConfig(Configuration config) throws XindiceException {
        super.setConfig(config);
        config.processChildren(RESOLVER, new ConfigurationCallback(){

            public void process(Configuration cfg) {
                block2: {
                    String className = cfg.getAttribute(QueryEngine.CLASS);
                    try {
                        QueryResolver res = (QueryResolver)Class.forName(className).newInstance();
                        res.setConfig(cfg);
                        res.setQueryEngine(QueryEngine.this);
                        QueryEngine.this.resolvers.put(res.getQueryStyle(), res);
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block2;
                        log.warn((Object)"ignored exception", (Throwable)e);
                    }
                }
            }
        });
    }

    public Database getDatabase() {
        return this.db;
    }

    public String[] listStyles() {
        return this.resolvers.keySet().toArray(EmptyStrings);
    }

    private QueryResolver getResolver(String style) throws QueryException {
        QueryResolver res = (QueryResolver)this.resolvers.get(style);
        if (res == null) {
            throw new StyleNotFoundException("No Resolver available for '" + style + "' queries");
        }
        return res;
    }

    public NodeSet query(Collection col, String style, String query, NamespaceMap nsMap, Key[] keys) throws DBException, QueryException {
        QueryResolver res = this.getResolver(style);
        return res.query(col, query, nsMap, keys);
    }

    public Query compileQuery(Collection col, String style, String query, NamespaceMap nsMap, Key[] keys) throws DBException, QueryException {
        QueryResolver res = this.getResolver(style);
        return res.compileQuery(col, query, nsMap, keys);
    }

    public static Key[] getUniqueKeys(IndexMatch[] matches) {
        TreeSet<Key> set = new TreeSet<Key>();
        int i = 0;
        while (i < matches.length) {
            set.add(matches[i].getKey());
            ++i;
        }
        return set.toArray(EmptyKeys);
    }

    public static Key[] andKeySets(Key[][] keySets) {
        if (keySets.length == 0) {
            return EmptyKeys;
        }
        if (keySets.length == 1) {
            return keySets[0];
        }
        int[] ptrs = new int[keySets.length];
        int i = 0;
        while (i < keySets.length) {
            if (keySets[i].length == 0) {
                return EmptyKeys;
            }
            ptrs[i] = 0;
            ++i;
        }
        TreeSet<Key> set = new TreeSet<Key>();
        boolean done = false;
        ArrayList<Integer> highs = new ArrayList<Integer>();
        Key highest = null;
        while (!done) {
            boolean eq = true;
            int i2 = 0;
            while (i2 < ptrs.length) {
                Key comp = keySets[i2][ptrs[i2]];
                if (highest == null) {
                    highest = comp;
                    highs.add(new Integer(i2));
                } else {
                    int c = highest.compareTo(comp);
                    if (c != 0) {
                        eq = false;
                    }
                    if (c < 0) {
                        highest = comp;
                        highs.clear();
                        highs.add(new Integer(i2));
                    } else if (c == 0) {
                        highs.add(new Integer(i2));
                    }
                }
                ++i2;
            }
            if (eq) {
                set.add(highest);
                highs.clear();
                highest = null;
            }
            int i3 = 0;
            while (i3 < ptrs.length) {
                if (!highs.contains(new Integer(i3))) {
                    int n = i3;
                    ptrs[n] = ptrs[n] + 1;
                }
                if (ptrs[i3] >= keySets[i3].length) {
                    done = true;
                }
                ++i3;
            }
            if (eq) continue;
            highs.clear();
        }
        return set.toArray(EmptyKeys);
    }

    public static Key[] orKeySets(Key[][] keySets) {
        if (keySets.length == 0) {
            return EmptyKeys;
        }
        if (keySets.length == 1) {
            return keySets[0];
        }
        if (keySets.length == 2) {
            if (keySets[1].length == 0) {
                return keySets[0];
            }
            if (keySets[0].length == 0) {
                return keySets[1];
            }
        }
        TreeSet<Key> set = new TreeSet<Key>();
        int i = 0;
        while (i < keySets.length) {
            int j = 0;
            while (j < keySets[i].length) {
                set.add(keySets[i][j]);
                ++j;
            }
            ++i;
        }
        return set.toArray(EmptyKeys);
    }

    public static String normalizeString(String value) {
        char[] c = value.toCharArray();
        char[] n = new char[c.length];
        boolean white = true;
        int pos = 0;
        int i = 0;
        while (i < c.length) {
            if (" \t\n\r".indexOf(c[i]) != -1) {
                if (!white) {
                    n[pos++] = 32;
                    white = true;
                }
            } else {
                n[pos++] = c[i];
                white = false;
            }
            ++i;
        }
        if (white && pos > 0) {
            --pos;
        }
        return new String(n, 0, pos);
    }

    public static String expandEntities(String value) {
        int idx = value.indexOf(38);
        if (idx == -1) {
            return value;
        }
        StringBuffer sb = new StringBuffer(value.length());
        int pos = 0;
        while (pos < value.length()) {
            if (idx != -1) {
                int end;
                if (idx > pos) {
                    sb.append(value.substring(pos, idx));
                }
                if ((end = value.indexOf(59, idx) + 1) == 0) {
                    return value;
                }
                String token = value.substring(idx + 1, end - 1);
                if (token.equals("apos")) {
                    sb.append("'");
                } else if (token.equals("quot")) {
                    sb.append("\"");
                } else if (token.equals("amp")) {
                    sb.append("&");
                } else if (token.equals("lt")) {
                    sb.append("<");
                } else if (token.equals("gt")) {
                    sb.append(">");
                } else {
                    return value;
                }
                pos = end;
                idx = value.indexOf(38, pos);
                continue;
            }
            sb.append(value.substring(pos));
            break;
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

