/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.NodeSet;
import org.apache.xindice.core.data.RecordSet;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.indexer.IndexManager;
import org.apache.xindice.core.indexer.IndexMatch;
import org.apache.xindice.core.indexer.IndexPattern;
import org.apache.xindice.core.indexer.IndexQuery;
import org.apache.xindice.core.indexer.Indexer;
import org.apache.xindice.core.indexer.helpers.IndexQueryANY;
import org.apache.xindice.core.indexer.helpers.IndexQueryEQ;
import org.apache.xindice.core.indexer.helpers.IndexQueryGEQ;
import org.apache.xindice.core.indexer.helpers.IndexQueryGT;
import org.apache.xindice.core.indexer.helpers.IndexQueryLEQ;
import org.apache.xindice.core.indexer.helpers.IndexQueryLT;
import org.apache.xindice.core.indexer.helpers.IndexQueryNEQ;
import org.apache.xindice.core.indexer.helpers.IndexQuerySW;
import org.apache.xindice.core.query.CompilationException;
import org.apache.xindice.core.query.ProcessingException;
import org.apache.xindice.core.query.Query;
import org.apache.xindice.core.query.QueryEngine;
import org.apache.xindice.core.query.QueryException;
import org.apache.xindice.core.query.QueryResolver;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.SimpleConfigurable;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.util.XindiceRuntimeException;
import org.apache.xindice.xml.NamespaceMap;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.dom.DBDocument;
import org.apache.xindice.xml.dom.DBNode;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.apache.xindice.xml.dom.TextImpl;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.xmldb.api.base.XMLDBException;

public final class XPathQueryResolver
extends SimpleConfigurable
implements QueryResolver {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$query$XPathQueryResolver == null ? (class$org$apache$xindice$core$query$XPathQueryResolver = XPathQueryResolver.class$("org.apache.xindice.core.query.XPathQueryResolver")) : class$org$apache$xindice$core$query$XPathQueryResolver));
    private static final Key[] EMPTY_KEYS = new Key[0];
    private static final Key[][] EMPTY_KEYSET = new Key[0][0];
    private static final String WILDCARD = "*";
    private static final String AUTOINDEX = "autoindex";
    public static final String STYLE_XPATH = "XPath";
    private static final int[] OpMap = new int[]{-1, 1, -2, 3, -3, 2};
    private DefaultErrorHandler errorListener = new DefaultErrorHandler();
    private boolean autoIndex = false;
    private static final NodeIterator EMPTY_NODE_ITERATOR = new EmptyNodeIterator();
    static /* synthetic */ Class class$org$apache$xindice$core$query$XPathQueryResolver;

    public void setConfig(Configuration config) throws XindiceException {
        super.setConfig(config);
        this.autoIndex = config.getBooleanAttribute(AUTOINDEX, this.autoIndex);
    }

    public String getQueryStyle() {
        return STYLE_XPATH;
    }

    public void setQueryEngine(QueryEngine engine) {
    }

    public Query compileQuery(Collection context, String query, NamespaceMap nsMap, Key[] keys) throws QueryException {
        return new XPathQuery(context, query, nsMap, keys);
    }

    public NodeSet query(Collection context, String query, NamespaceMap nsMap, Key[] keys) throws QueryException {
        XPathQuery xq = new XPathQuery(context, query, nsMap, keys);
        return xq.execute();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class EmptyNodeIterator
    implements NodeIterator {
        private EmptyNodeIterator() {
        }

        public int getWhatToShow() {
            throw new UnsupportedOperationException();
        }

        public void detach() {
            throw new UnsupportedOperationException();
        }

        public boolean getExpandEntityReferences() {
            throw new UnsupportedOperationException();
        }

        public Node getRoot() {
            throw new UnsupportedOperationException();
        }

        public Node nextNode() throws DOMException {
            return null;
        }

        public Node previousNode() throws DOMException {
            throw new UnsupportedOperationException();
        }

        public NodeFilter getFilter() {
            throw new UnsupportedOperationException();
        }
    }

    private class ResultSet
    implements NodeSet {
        public Collection context;
        public String query;
        public ErrorListener errors;
        public PrefixResolver pr;
        public XPath xp;
        public Key[] keySet;
        public int keyPos = 0;
        public NodeIterator ni;
        public Object node;

        public ResultSet(Collection context, PrefixResolver pr, Key[] keySet, String query) {
            this.context = context;
            this.pr = pr;
            this.keySet = keySet;
            this.query = query;
            this.errors = new ErrorListener(){

                public void fatalError(TransformerException te) {
                    if (log.isFatalEnabled()) {
                        log.fatal((Object)"No message", (Throwable)te);
                    }
                }

                public void error(TransformerException te) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"No message", (Throwable)te);
                    }
                }

                public void warning(TransformerException te) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"No message", (Throwable)te);
                    }
                }
            };
            try {
                this.prepareNextNode();
            }
            catch (Exception e) {
                throw new XindiceRuntimeException(e.getMessage());
            }
        }

        private void prepareNextNode() throws XMLDBException, TransformerException, DBException {
            this.node = null;
            while (this.keyPos < this.keySet.length) {
                PrefixResolver pfx;
                DBDocument d;
                if ((d = (DBDocument)this.context.getDocument(this.keySet[this.keyPos++])) == null) continue;
                Element n = d.getDocumentElement();
                XPathContext xpc = new XPathContext();
                if (this.pr == null) {
                    pfx = new PrefixResolverDefault((Node)d.getDocumentElement());
                    this.xp = new XPath(this.query, null, pfx, 0, this.errors);
                } else {
                    pfx = this.pr;
                    if (this.xp == null) {
                        this.xp = new XPath(this.query, null, pfx, 0, this.errors);
                    }
                }
                XObject xobject = this.xp.execute(xpc, (Node)n, pfx);
                switch (xobject.getType()) {
                    default: {
                        throw new XMLDBException(2, "Unsupported result type: " + xobject.getTypeString());
                    }
                    case 4: {
                        this.ni = xobject.nodeset();
                        this.node = this.ni.nextNode();
                        break;
                    }
                    case 1: {
                        this.ni = EMPTY_NODE_ITERATOR;
                        this.node = new DocumentImpl().createTextNode(String.valueOf(xobject.bool()));
                        if (!(n instanceof DBNode)) break;
                        ((TextImpl)this.node).setSource(((DBNode)((Object)n)).getSource());
                        break;
                    }
                    case 3: {
                        this.ni = EMPTY_NODE_ITERATOR;
                        this.node = new DocumentImpl().createTextNode(xobject.str());
                        if (!(n instanceof DBNode)) break;
                        ((TextImpl)this.node).setSource(((DBNode)((Object)n)).getSource());
                        break;
                    }
                    case 2: {
                        this.ni = EMPTY_NODE_ITERATOR;
                        this.node = new DocumentImpl().createTextNode(Double.toString(xobject.num()));
                        if (!(n instanceof DBNode)) break;
                        ((TextImpl)this.node).setSource(((DBNode)((Object)n)).getSource());
                    }
                }
                if (this.node != null) break;
            }
        }

        public boolean hasMoreNodes() {
            return this.node != null;
        }

        public Object getNextNode() {
            Object n = this.node;
            this.node = this.ni.nextNode();
            if (this.node == null) {
                try {
                    this.prepareNextNode();
                }
                catch (Exception e) {
                    throw new XindiceRuntimeException(e.getMessage());
                }
            }
            return n;
        }
    }

    private class NamedKeys {
        public boolean attribute = false;
        public String name;
        public Key[] keys;

        public NamedKeys(String name, boolean attribute, Key[] keys) {
            this.name = name;
            this.attribute = attribute;
            this.keys = keys;
        }
    }

    private class XPathQuery
    implements Query {
        public Collection context;
        public IndexManager idxMgr;
        public NamespaceMap nsMap;
        public PrefixResolver pr;
        public SymbolTable symbols;
        public String query;
        public Compiler cmp;
        public XPath xp;
        public Key[] keys;

        public XPathQuery(Collection context, String query, NamespaceMap nsMap, Key[] keys) throws QueryException {
            this.context = context;
            this.query = query;
            this.nsMap = nsMap;
            this.keys = keys;
            Expression ex = null;
            try {
                if (nsMap != null) {
                    Node n = nsMap.getContextNode();
                    this.pr = new PrefixResolverDefault(n);
                }
                XPathParser parser = new XPathParser((ErrorListener)XPathQueryResolver.this.errorListener, null);
                this.cmp = new Compiler((ErrorListener)XPathQueryResolver.this.errorListener, null);
                parser.initXPath(this.cmp, query, this.pr);
                ex = this.cmp.compile(0);
                this.symbols = context.getSymbols();
                this.idxMgr = context.getIndexManager();
            }
            catch (Exception e) {
                throw new CompilationException("Error Compiling XPath Expression: " + e.getMessage(), e);
            }
            if (ex == null) {
                throw new CompilationException("Error Compiling XPath Expression: XPath Compiler.compile returned null");
            }
        }

        public String getQueryStyle() {
            return XPathQueryResolver.STYLE_XPATH;
        }

        public String getQueryString() {
            return this.query;
        }

        public Collection getQueryContext() {
            return this.context;
        }

        public NamespaceMap getNamespaceMap() {
            return this.nsMap;
        }

        public Key[] getKeySet() {
            return this.keys;
        }

        public NodeSet execute() throws QueryException {
            try {
                Key[] keySet;
                block9: {
                    keySet = this.keys;
                    if (this.keys == null && this.idxMgr != null) {
                        try {
                            Object obj = this.evaluate(null, 0);
                            if (obj instanceof NamedKeys) {
                                keySet = ((NamedKeys)obj).keys;
                            }
                        }
                        catch (Exception e) {
                            if (!log.isWarnEnabled()) break block9;
                            log.warn((Object)"ignored exception", (Throwable)e);
                        }
                    }
                }
                if (keySet == null) {
                    TreeSet<Key> set = new TreeSet<Key>();
                    RecordSet rs = this.context.getFiler().getRecordSet();
                    while (rs.hasMoreRecords()) {
                        set.add(rs.getNextKey());
                    }
                    keySet = set.toArray(EMPTY_KEYS);
                }
                return new ResultSet(this.context, this.pr, keySet, this.query);
            }
            catch (Exception e) {
                if (e instanceof QueryException) {
                    throw (QueryException)e.fillInStackTrace();
                }
                throw new ProcessingException("Error executing XPath query: " + e.getMessage(), e);
            }
        }

        private Key[] andKeys(List list) {
            if (!list.isEmpty()) {
                if (list.size() > 1) {
                    Key[][] keys = (Key[][])list.toArray((T[])EMPTY_KEYSET);
                    return QueryEngine.andKeySets(keys);
                }
                return (Key[])list.get(0);
            }
            return null;
        }

        private Object evaluate(String owner, int pos) throws Exception {
            int op = this.cmp.getOp(pos);
            if (op == -1) {
                return null;
            }
            switch (op) {
                case 28: {
                    return this.evalLocationPath(owner, pos);
                }
                case 1: 
                case 26: 
                case 29: {
                    return this.evaluate(owner, org.apache.xpath.compiler.OpMap.getFirstChildPos((int)pos));
                }
                case 2: 
                case 3: {
                    return this.evalSetComparison(op, owner, pos);
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return this.evalValComparison(op, owner, pos);
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return this.evalMathOperation(op, owner, pos);
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    return this.evalUnaryOperation(op, owner, pos);
                }
                case 20: {
                    return this.evalUnion(owner, pos);
                }
                case 22: {
                    break;
                }
                case 23: {
                    return this.evaluate(owner, org.apache.xpath.compiler.OpMap.getFirstChildPos((int)pos));
                }
                case 24: {
                    break;
                }
                case 25: {
                    return this.evalFunction(owner, pos);
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: {
                    return this.evalAxis(op, owner, pos);
                }
                case 21: 
                case 27: 
                case 34: {
                    return this.evalLiteral(owner, pos);
                }
                case 1031: 
                case 1033: {
                    return owner;
                }
                case -3: 
                case 36: {
                    return XPathQueryResolver.WILDCARD;
                }
                case 35: 
                case 1030: 
                case 1032: 
                case 1034: {
                    break;
                }
                default: {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)("Unknown: " + op));
                }
            }
            return null;
        }

        private Object evalLocationPath(String owner, int pos) throws Exception {
            int lp = org.apache.xpath.compiler.OpMap.getFirstChildPos((int)pos);
            ArrayList<Key[]> ks = new ArrayList<Key[]>();
            String name = null;
            boolean attr = false;
            while (this.cmp.getOp(lp) != -1) {
                Object obj = this.evaluate(owner, lp);
                if (obj instanceof NamedKeys) {
                    NamedKeys nk = (NamedKeys)obj;
                    if (nk.name != null) {
                        attr = nk.attribute;
                        if (attr) {
                            if (name == null) {
                                name = owner;
                            }
                            if (name != null) {
                                StringBuffer sb = new StringBuffer(32);
                                sb.append(name);
                                sb.append('@');
                                sb.append(nk.name);
                                name = sb.toString();
                            }
                        } else {
                            name = nk.name;
                        }
                    }
                    if (nk.keys != null) {
                        ks.add(nk.keys);
                    } else if (name != null) {
                        if (!attr && XPathQueryResolver.WILDCARD.equals(name)) {
                            TreeSet<Key> set = new TreeSet<Key>();
                            RecordSet rs = this.context.getFiler().getRecordSet();
                            while (rs.hasMoreRecords()) {
                                set.add(rs.getNextKey());
                            }
                            ks.add(set.toArray(EMPTY_KEYS));
                        } else {
                            IndexPattern pattern = new IndexPattern(this.symbols, name, this.nsMap);
                            Indexer idx = this.context.getIndexManager().getBestIndexer("Node:Name", pattern);
                            if (idx != null) {
                                IndexMatch[] matches = idx.queryMatches(new IndexQueryANY(pattern));
                                Key[] keys = QueryEngine.getUniqueKeys(matches);
                                ks.add(keys);
                            }
                        }
                    }
                }
                lp = this.cmp.getNextOpPos(lp);
            }
            return new NamedKeys(name, attr, this.andKeys(ks));
        }

        private Object evalUnion(String owner, int pos) throws Exception {
            Object right;
            int l = org.apache.xpath.compiler.OpMap.getFirstChildPos((int)pos);
            int r = this.cmp.getNextOpPos(l);
            Object left = this.evaluate(owner, l);
            if (left instanceof NamedKeys && ((NamedKeys)left).keys != null && (right = this.evaluate(owner, r)) instanceof NamedKeys && ((NamedKeys)right).keys != null) {
                Key[][] keys = new Key[][]{((NamedKeys)left).keys, ((NamedKeys)right).keys};
                return new NamedKeys(null, false, QueryEngine.orKeySets(keys));
            }
            return null;
        }

        private Object evalSetComparison(int op, String owner, int pos) throws Exception {
            int l = org.apache.xpath.compiler.OpMap.getFirstChildPos((int)pos);
            int r = this.cmp.getNextOpPos(l);
            Object left = this.evaluate(owner, l);
            if (left instanceof NamedKeys && ((NamedKeys)left).keys != null) {
                if (((NamedKeys)left).keys.length == 0 && op == 3) {
                    return new NamedKeys(null, false, ((NamedKeys)left).keys);
                }
                Object right = this.evaluate(owner, r);
                if (right instanceof NamedKeys && ((NamedKeys)right).keys != null) {
                    if (op == 3) {
                        if (((NamedKeys)right).keys.length == 0) {
                            return new NamedKeys(null, false, ((NamedKeys)right).keys);
                        }
                        Key[][] keys = new Key[][]{((NamedKeys)left).keys, ((NamedKeys)right).keys};
                        return new NamedKeys(null, false, QueryEngine.andKeySets(keys));
                    }
                    if (((NamedKeys)left).keys.length == 0) {
                        return new NamedKeys(null, false, ((NamedKeys)right).keys);
                    }
                    if (((NamedKeys)right).keys.length == 0) {
                        return new NamedKeys(null, false, ((NamedKeys)left).keys);
                    }
                    Key[][] keys = new Key[][]{((NamedKeys)left).keys, ((NamedKeys)right).keys};
                    return new NamedKeys(null, false, QueryEngine.orKeySets(keys));
                }
                if (op == 3) {
                    return new NamedKeys(null, false, ((NamedKeys)left).keys);
                }
            } else {
                Object right = this.evaluate(owner, r);
                if (right instanceof NamedKeys && ((NamedKeys)right).keys != null && op == 3) {
                    return new NamedKeys(null, false, ((NamedKeys)right).keys);
                }
            }
            return null;
        }

        private Object evalValComparison(int op, String owner, int pos) throws Exception {
            int l = org.apache.xpath.compiler.OpMap.getFirstChildPos((int)pos);
            int r = this.cmp.getNextOpPos(l);
            Object left = this.evaluate(owner, l);
            if (!(left instanceof XObject) && !(left instanceof NamedKeys)) {
                return null;
            }
            Object right = this.evaluate(owner, r);
            if (left instanceof NamedKeys && right instanceof XObject || left instanceof XObject && right instanceof NamedKeys) {
                return this.queryComparison(op, owner, left, right);
            }
            if (left instanceof XObject && right instanceof XObject) {
                switch (op) {
                    case 4: {
                        return new XBoolean(((XObject)left).notEquals((XObject)right));
                    }
                    case 5: {
                        return new XBoolean(((XObject)left).equals((XObject)right));
                    }
                    case 6: {
                        return new XBoolean(((XObject)left).lessThanOrEqual((XObject)right));
                    }
                    case 7: {
                        return new XBoolean(((XObject)left).lessThan((XObject)right));
                    }
                    case 8: {
                        return new XBoolean(((XObject)left).greaterThanOrEqual((XObject)right));
                    }
                    case 9: {
                        return new XBoolean(((XObject)left).greaterThan((XObject)right));
                    }
                }
                return null;
            }
            return null;
        }

        private strictfp Object evalMathOperation(int op, String owner, int pos) throws Exception {
            Object right;
            int lc = org.apache.xpath.compiler.OpMap.getFirstChildPos((int)pos);
            int rc = this.cmp.getNextOpPos(lc);
            Object left = this.evaluate(owner, lc);
            if (left instanceof XObject && (right = this.evaluate(owner, rc)) instanceof XObject) {
                switch (op) {
                    case 10: {
                        return new XNumber(((XObject)left).num() + ((XObject)right).num());
                    }
                    case 11: {
                        return new XNumber(((XObject)left).num() - ((XObject)right).num());
                    }
                    case 12: {
                        return new XNumber(((XObject)left).num() * ((XObject)right).num());
                    }
                    case 13: {
                        return new XNumber(((XObject)left).num() / ((XObject)right).num());
                    }
                    case 14: {
                        return new XNumber(((XObject)left).num() % ((XObject)right).num());
                    }
                    case 15: {
                        return new XNumber(((XObject)left).num() / ((XObject)right).num());
                    }
                }
                return null;
            }
            return null;
        }

        private Object evalUnaryOperation(int op, String owner, int pos) throws Exception {
            Object val = this.evaluate(owner, org.apache.xpath.compiler.OpMap.getFirstChildPos((int)pos));
            if (val instanceof XObject) {
                switch (op) {
                    case 16: {
                        return new XNumber(-((XObject)val).num());
                    }
                    case 17: {
                        return new XString(((XObject)val).str());
                    }
                    case 18: {
                        return new XBoolean(((XObject)val).bool());
                    }
                    case 19: {
                        return new XNumber(((XObject)val).num());
                    }
                }
                return null;
            }
            if (val instanceof NamedKeys) {
                NamedKeys nk = (NamedKeys)val;
                if (nk.keys != null && op == 18) {
                    return nk.keys.length == 0 ? XBoolean.S_FALSE : XBoolean.S_TRUE;
                }
            }
            return null;
        }

        private Object evalFunction(String owner, int pos) throws Exception {
            int idx = org.apache.xpath.compiler.OpMap.getFirstChildPos((int)pos);
            int id = this.cmp.getOp(idx);
            int endFunc = pos + this.cmp.getOp(pos + 1) - 1;
            ArrayList<Object> args = new ArrayList<Object>();
            int lp = idx + 1;
            while (lp < endFunc) {
                args.add(this.evaluate(owner, lp));
                lp = this.cmp.getNextOpPos(lp);
            }
            switch (id) {
                case 14: {
                    return this.funcBoolean(args);
                }
                case 17: {
                    return this.funcCeiling(args);
                }
                case 27: {
                    return this.funcConcat(args);
                }
                case 22: {
                    return this.funcContains(args);
                }
                case 13: {
                    return XBoolean.S_FALSE;
                }
                case 16: {
                    return this.funcFloor(args);
                }
                case 25: {
                    return this.funcNormalizeSpace(args);
                }
                case 11: {
                    return this.funcNot(args);
                }
                case 15: {
                    return this.funcNumber(args);
                }
                case 18: {
                    return this.funcRound(args);
                }
                case 21: {
                    return this.funcStartsWith(owner, args);
                }
                case 20: {
                    return this.funcString(args);
                }
                case 30: {
                    return this.funcStringLength(args);
                }
                case 29: {
                    return this.funcSubstring(args);
                }
                case 24: {
                    return this.funcSubstringAfter(args);
                }
                case 23: {
                    return this.funcSubstringBefore(args);
                }
                case 26: {
                    return this.funcTranslate(args);
                }
                case 12: {
                    return XBoolean.S_TRUE;
                }
            }
            return null;
        }

        private Object evalAxis(int op, String owner, int pos) throws Exception {
            String nsURI = this.cmp.getStepNS(pos);
            owner = (String)this.evaluate(owner, org.apache.xpath.compiler.OpMap.getFirstChildPosOfStep((int)pos));
            if (nsURI != null && this.nsMap != null) {
                String pfx = null;
                Iterator i = this.nsMap.keySet().iterator();
                while (i.hasNext()) {
                    String p = (String)i.next();
                    if (!this.nsMap.getNamespaceURI(p).equals(nsURI)) continue;
                    pfx = p;
                    break;
                }
                if (pfx != null) {
                    StringBuffer sb = new StringBuffer(32);
                    sb.append(pfx);
                    sb.append(':');
                    sb.append(owner);
                    owner = sb.toString();
                }
            }
            int rp = this.cmp.getFirstPredicateOpPos(pos);
            ArrayList<Key[]> ks = new ArrayList<Key[]>();
            while (rp < pos + this.cmp.getOp(pos + 1)) {
                Object obj = this.evaluate(owner, rp);
                if (obj instanceof NamedKeys) {
                    NamedKeys nk = (NamedKeys)obj;
                    if (nk.keys != null) {
                        ks.add(nk.keys);
                    }
                }
                rp = this.cmp.getNextOpPos(rp);
            }
            return new NamedKeys(owner, op == 39, this.andKeys(ks));
        }

        private Object evalLiteral(String owner, int pos) {
            int idx = this.cmp.getOp(org.apache.xpath.compiler.OpMap.getFirstChildPos((int)pos));
            switch (idx) {
                case -2: {
                    return owner;
                }
                case -3: {
                    return XPathQueryResolver.WILDCARD;
                }
            }
            return this.cmp.getToken(idx);
        }

        private Object funcBoolean(List args) throws Exception {
            if (args.size() == 1) {
                Object o = args.get(0);
                if (o instanceof XObject) {
                    if (((XObject)o).bool()) {
                        return XBoolean.S_TRUE;
                    }
                    return XBoolean.S_FALSE;
                }
                if (o instanceof NamedKeys) {
                    NamedKeys nk = (NamedKeys)o;
                    if (nk.keys == null) {
                        return null;
                    }
                    if (nk.keys.length == 0) {
                        return XBoolean.S_FALSE;
                    }
                    return XBoolean.S_TRUE;
                }
            }
            return null;
        }

        private Object funcCeiling(List args) throws Exception {
            Object o;
            if (args.size() == 1 && (o = args.get(0)) instanceof XObject) {
                return new XNumber(Math.ceil(((XObject)o).num()));
            }
            return null;
        }

        private Object funcConcat(List args) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < args.size()) {
                Object o = args.get(i);
                if (!(o instanceof XObject)) {
                    return null;
                }
                sb.append(((XObject)o).str());
                ++i;
            }
            return new XString(sb.toString());
        }

        private Object funcContains(List args) {
            if (args.size() == 2) {
                Object o = args.get(0);
                Object s = args.get(1);
                if (o instanceof XObject && s instanceof XObject) {
                    if (((XObject)o).str().indexOf(((XObject)s).str()) != -1) {
                        return XBoolean.S_TRUE;
                    }
                    return XBoolean.S_FALSE;
                }
            }
            return null;
        }

        private Object funcFloor(List args) throws Exception {
            Object o;
            if (args.size() == 1 && (o = args.get(0)) instanceof XObject) {
                return new XNumber(Math.floor(((XObject)o).num()));
            }
            return null;
        }

        private Object funcNormalizeSpace(List args) {
            Object o;
            if (args.size() == 1 && (o = args.get(0)) instanceof XObject) {
                return new XString(QueryEngine.normalizeString(((XObject)o).str()));
            }
            return null;
        }

        private Object funcNot(List args) throws Exception {
            if (args.size() == 1) {
                Object o = args.get(0);
                if (o instanceof XObject) {
                    if (((XObject)o).bool()) {
                        return XBoolean.S_FALSE;
                    }
                    return XBoolean.S_TRUE;
                }
                if (o instanceof NamedKeys) {
                    NamedKeys nk = (NamedKeys)o;
                    if (nk.keys == null) {
                        return null;
                    }
                    if (nk.keys.length == 0) {
                        return XBoolean.S_TRUE;
                    }
                    return XBoolean.S_FALSE;
                }
                return null;
            }
            return null;
        }

        private Object funcNumber(List args) throws Exception {
            Object o;
            if (args.size() == 1 && (o = args.get(0)) instanceof XObject) {
                return new XNumber(((XObject)o).num());
            }
            return null;
        }

        private Object funcRound(List args) throws Exception {
            Object o;
            if (args.size() == 1 && (o = args.get(0)) instanceof XObject) {
                return new XNumber((double)Math.round(((XObject)o).num()));
            }
            return null;
        }

        private Object funcStartsWith(String owner, List args) {
            if (args.size() == 2) {
                Object o = args.get(0);
                Object s = args.get(1);
                if (o instanceof XObject && s instanceof XObject) {
                    if (((XObject)o).str().startsWith(((XObject)s).str())) {
                        return XBoolean.S_TRUE;
                    }
                    return XBoolean.S_FALSE;
                }
                if (o instanceof NamedKeys && s instanceof XObject) {
                    NamedKeys nk = (NamedKeys)o;
                    String ps = nk.attribute && nk.name.indexOf(64) == -1 ? owner + "@" + nk.name : nk.name;
                    IndexPattern pattern = new IndexPattern(this.symbols, ps, this.nsMap);
                    XObject obj = (XObject)s;
                    Value val1 = new Value(obj.str());
                    IndexQuerySW iq = new IndexQuerySW(pattern, val1);
                    return this.queryIndexes(nk, iq, ps, obj.getType());
                }
            }
            return null;
        }

        private Object funcString(List args) {
            Object o;
            if (args.size() == 1 && (o = args.get(0)) instanceof XObject) {
                return new XString(((XObject)o).str());
            }
            return null;
        }

        private Object funcStringLength(List args) {
            Object o;
            if (args.size() == 1 && (o = args.get(0)) instanceof XObject) {
                return new XNumber((double)((XObject)o).str().length());
            }
            return null;
        }

        private Object funcSubstring(List args) throws Exception {
            if (args.size() == 2 || args.size() == 3) {
                Object len;
                Object o = args.get(0);
                Object pos = args.get(1);
                Object v0 = len = args.size() == 3 ? args.get(2) : null;
                if (o instanceof XObject && pos instanceof XObject && (len == null || len instanceof XObject)) {
                    int ipos = (int)((XObject)pos).num() - 1;
                    if (len != null) {
                        int ilen = (int)((XObject)len).num();
                        return new XString(((XObject)o).str().substring(ipos, ipos + ilen));
                    }
                    return new XString(((XObject)o).str().substring(ipos));
                }
            }
            return null;
        }

        private Object funcSubstringAfter(List args) {
            if (args.size() == 2) {
                Object o = args.get(0);
                Object s = args.get(1);
                if (o instanceof XObject && s instanceof XObject) {
                    String sub;
                    String val = ((XObject)o).str();
                    int i = val.indexOf(sub = ((XObject)s).str());
                    if (i == -1) {
                        return new XString("");
                    }
                    return new XString(val.substring(i + sub.length()));
                }
            }
            return null;
        }

        private Object funcSubstringBefore(List args) {
            if (args.size() == 2) {
                Object o = args.get(0);
                Object s = args.get(1);
                if (o instanceof XObject && s instanceof XObject) {
                    String sub;
                    String val = ((XObject)o).str();
                    int i = val.indexOf(sub = ((XObject)s).str());
                    if (i == -1) {
                        return new XString("");
                    }
                    return new XString(val.substring(0, i));
                }
            }
            return null;
        }

        private Object funcTranslate(List args) {
            if (args.size() == 3) {
                Object o = args.get(0);
                Object c1 = args.get(1);
                Object c2 = args.get(2);
                if (o instanceof XObject && c1 instanceof XObject && c2 instanceof XObject) {
                    char ch1 = ((XObject)c1).str().charAt(0);
                    char ch2 = ((XObject)c2).str().charAt(0);
                    return new XString(((XObject)o).str().replace(ch1, ch2));
                }
            }
            return null;
        }

        private Object queryIndexes(NamedKeys nk, IndexQuery iq, String ps, int objType) {
            block11: {
                try {
                    IndexPattern pattern = iq.getPattern();
                    Indexer idx = this.context.getIndexManager().getBestIndexer("Node:Value", pattern);
                    if (idx != null) {
                        return new NamedKeys(nk.name, nk.attribute, QueryEngine.getUniqueKeys(idx.queryMatches(iq)));
                    }
                    if (XPathQueryResolver.this.autoIndex) {
                        Element e = new DocumentImpl().createElement("index");
                        e.setAttribute("class", "org.apache.xindice.core.indexer.ValueIndexer");
                        e.setAttribute("name", "xp_" + ps);
                        e.setAttribute("pattern", ps);
                        String type = null;
                        switch (objType) {
                            case 1: {
                                type = "boolean";
                                break;
                            }
                            case 2: {
                                type = "double";
                                break;
                            }
                            case 3: {
                                if (ps.indexOf(64) != -1) {
                                    type = "string";
                                    break;
                                }
                                type = "trimmed";
                                break;
                            }
                            default: {
                                if (!log.isWarnEnabled()) break;
                                log.warn((Object)("invalid object type : " + objType));
                            }
                        }
                        if (type != null) {
                            e.setAttribute("type", type);
                        }
                        this.idxMgr.create(new Configuration(e));
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block11;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
            return null;
        }

        private Object queryComparison(int op, String owner, Object left, Object right) {
            IndexQuery iq;
            op = OpMap[op - 4];
            if (left instanceof XObject) {
                if (op == 2 || op == 3 || op == -3 || op == -2) {
                    op = -op;
                }
                Object tmp = left;
                left = right;
                right = tmp;
            }
            if (!(left instanceof NamedKeys) || !(right instanceof XObject)) {
                return null;
            }
            NamedKeys nk = (NamedKeys)left;
            XObject obj = (XObject)right;
            String ps = nk.attribute && nk.name.indexOf(64) == -1 ? owner + "@" + nk.name : nk.name;
            IndexPattern pattern = new IndexPattern(this.symbols, ps, this.nsMap);
            String value = obj.str();
            switch (op) {
                case -1: {
                    iq = new IndexQueryNEQ(pattern, value);
                    break;
                }
                case 1: {
                    iq = new IndexQueryEQ(pattern, value);
                    break;
                }
                case -2: {
                    iq = new IndexQueryLEQ(pattern, value);
                    break;
                }
                case 3: {
                    iq = new IndexQueryLT(pattern, value);
                    break;
                }
                case -3: {
                    iq = new IndexQueryGEQ(pattern, value);
                    break;
                }
                case 2: {
                    iq = new IndexQueryGT(pattern, value);
                    break;
                }
                default: {
                    iq = null;
                }
            }
            return this.queryIndexes(nk, iq, ps, obj.getType());
        }
    }
}

