/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.apache.xindice.client.xmldb.DatabaseImpl;
import org.apache.xindice.tools.ArgTokenizer;
import org.apache.xindice.tools.command.Command;
import org.apache.xindice.tools.command.Shutdown;
import org.apache.xindice.util.StringUtilities;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.dom.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class XMLTools {
    public static final String COLLECTION = "collection";
    public static final String EXTENSION = "extension";
    public static final String FILE_PATH = "filePath";
    public static final String ACTION = "action";
    public static final String NAME_OF = "nameOf";
    public static final String PATTERN = "pattern";
    public static final String QUERY = "query";
    public static final String URI = "uri";
    public static final String VERBOSE = "verbose";
    public static final String TYPE = "type";
    public static final String PAGE_SIZE = "pagesize";
    public static final String MAX_KEY_SIZE = "maxkeysize";
    public static final String DB_SERVER = "dbServ";
    public static final String PORT = "port";
    public static final String HOST = "host";
    public static final String USER = "user";
    public static final String LOCAL = "local";
    public static final String DB_CONFIG = "dbconfig";
    public static final String PASSWORD = "password";
    public static final String AUTO_KEY = "autoKey";
    public static final String NAMESPACES = "namespaces";
    public static final String IMPL_CLASS = "implClass";
    private Hashtable table = new Hashtable();
    protected String location = null;
    private boolean initialized = false;
    private static boolean verbose = false;
    private Document commandsDocument = null;
    protected NodeList commandsList = null;

    public static void main(String[] args) {
        block2: {
            try {
                new XMLTools().process(args);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                if (!verbose) break block2;
                e.printStackTrace(System.err);
            }
        }
    }

    public XMLTools() {
        this.table.put(FILE_PATH, "");
        this.table.put(EXTENSION, "");
        this.table.put(QUERY, "");
        this.table.put(AUTO_KEY, "");
        this.table.put(VERBOSE, "false");
    }

    protected void initCommandsList() {
        NodeList list = this.getCommandsDocument().getElementsByTagName(USER);
        if (list.getLength() > 0) {
            Element node = (Element)list.item(0);
            list = node.getElementsByTagName("command");
        }
        this.commandsList = list;
    }

    public boolean isAdmin() {
        return false;
    }

    public void init() throws XindiceException, FileNotFoundException {
        if (!this.initialized) {
            this.initCommandsDocument();
            this.initCommandsList();
            this.initialized = true;
        }
    }

    protected void initCommandsDocument() throws XindiceException, FileNotFoundException {
        File xindiceHome = new File(System.getProperty("xindice.home", "."));
        File commandsFile = new File(xindiceHome, "config/commands.xml");
        this.commandsDocument = DOMParser.toDocument(new FileInputStream(commandsFile));
    }

    protected Document getCommandsDocument() {
        return this.commandsDocument;
    }

    protected NodeList getCommands() {
        return this.commandsList;
    }

    public void process(String[] args) throws XindiceException, Exception {
        try {
            this.init();
            this.parseArguments(args);
            if (!this.execute()) {
                this.printHelp();
            }
        }
        catch (IllegalArgumentException e) {
            this.printHelp();
            throw new XindiceException("ERROR : " + e.getMessage(), e);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("ERROR : " + e + " Switch found. Parameter missing.");
        }
        catch (NullPointerException e) {
            e.printStackTrace(System.err);
            throw new NullPointerException("ERROR : " + e);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new XindiceException("ERROR : " + e.getMessage(), e);
        }
    }

    protected void parseArguments(String[] args) throws IllegalArgumentException {
        ArgTokenizer at = new ArgTokenizer(args);
        if (!at.hasMoreTokens()) {
            throw new IllegalArgumentException("No argument found");
        }
        this.table.put(ACTION, at.nextToken());
        while (at.hasMoreTokens()) {
            String token = at.nextToken();
            if (token.equalsIgnoreCase("-c") || token.equalsIgnoreCase("--collection")) {
                String colname = at.nextSwitchToken();
                if (!colname.startsWith("/") && !colname.startsWith("xmldb:xindice")) {
                    throw new IllegalArgumentException("The name of a collection must start with '/'");
                }
                this.table.put(COLLECTION, colname);
                continue;
            }
            if (token.equalsIgnoreCase("-e") || token.equalsIgnoreCase("--extension")) {
                this.table.put(EXTENSION, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-f") || token.equalsIgnoreCase("--filepath")) {
                this.table.put(FILE_PATH, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-h") || token.equalsIgnoreCase("--help")) {
                this.table.put(ACTION, "help");
                continue;
            }
            if (token.equalsIgnoreCase("-n") || token.equalsIgnoreCase("--nameOf")) {
                this.table.put(NAME_OF, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-p") || token.equalsIgnoreCase("--pattern")) {
                this.table.put(PATTERN, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-q") || token.equalsIgnoreCase("--query")) {
                this.table.put(QUERY, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-u") || token.equalsIgnoreCase("--uri")) {
                this.table.put(URI, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-v") || token.equalsIgnoreCase("--verbose")) {
                this.table.put(VERBOSE, "true");
                continue;
            }
            if (token.equalsIgnoreCase("-l") || token.equalsIgnoreCase("--localdb")) {
                this.table.put(LOCAL, "true");
                continue;
            }
            if (token.equalsIgnoreCase("-d") || token.equalsIgnoreCase("--dbconfig")) {
                String configFile = at.nextSwitchToken();
                if (!new File(configFile).isAbsolute()) {
                    configFile = new File(System.getProperty("user.dir"), configFile).getAbsolutePath();
                }
                System.setProperty("xindice.configuration", configFile);
                this.table.put(DB_CONFIG, configFile);
                continue;
            }
            if (token.equalsIgnoreCase("-s") || token.equalsIgnoreCase("--namespaces")) {
                this.table.put(NAMESPACES, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("-t") || token.equalsIgnoreCase("--type")) {
                this.table.put(TYPE, at.nextSwitchToken());
                continue;
            }
            if (token.equalsIgnoreCase("+trim")) {
                if (this.table.containsKey(TYPE)) continue;
                this.table.put(TYPE, "trimmed");
                continue;
            }
            if (token.equalsIgnoreCase("-trim")) {
                if (this.table.containsKey(TYPE)) continue;
                this.table.put(TYPE, "string");
                continue;
            }
            if (token.equalsIgnoreCase("--pagesize")) {
                this.table.put(PAGE_SIZE, at.nextSwitchToken());
                continue;
            }
            if (!token.equalsIgnoreCase("--maxkeysize")) continue;
            this.table.put(MAX_KEY_SIZE, at.nextSwitchToken());
        }
    }

    public boolean execute() throws Exception {
        this.init();
        String action = (String)this.table.get(ACTION);
        String commandClass = null;
        if (action != null) {
            NodeList commands = this.getCommands();
            int i = 0;
            while (i < commands.getLength()) {
                Element e = (Element)commands.item(i);
                if (action.equals(e.getAttribute("switch")) || action.equals(e.getAttribute("name"))) {
                    commandClass = e.getAttribute("class");
                }
                ++i;
            }
        }
        if (commandClass != null) {
            try {
                DatabaseImpl db = new DatabaseImpl();
                DatabaseManager.registerDatabase((Database)db);
                Command command = (Command)Class.forName(commandClass).newInstance();
                command.execute(this.table);
                if ("true".equals(this.table.get(LOCAL))) {
                    command = new Shutdown();
                    command.execute(this.table);
                }
                return true;
            }
            catch (XMLDBException e) {
                System.err.println("XMLDB Exception " + e.errorCode + ": " + e.getMessage());
                if (this.table.get(VERBOSE).equals("true")) {
                    e.printStackTrace(System.err);
                }
                return false;
            }
            catch (Exception e) {
                System.err.println("ERROR : " + e.getMessage());
                if (this.table.get(VERBOSE).equals("true")) {
                    e.printStackTrace(System.err);
                }
                return false;
            }
        }
        return false;
    }

    public boolean handleOption(String option, ArgTokenizer at) {
        return false;
    }

    public void setAction(String actionType) {
        this.table.put(ACTION, actionType);
    }

    public String getAction() {
        return (String)this.table.get(ACTION);
    }

    public void setCollectionName(String collectionName) {
        this.table.put(COLLECTION, collectionName);
    }

    public String getCollectionName() {
        return (String)this.table.get(COLLECTION);
    }

    public void setDocumentName(String documentName) {
        this.table.put(NAME_OF, documentName);
    }

    public String getDocumentName() {
        return (String)this.table.get(NAME_OF);
    }

    public void setQuery(String query) {
        this.table.put(QUERY, query);
    }

    public String getQuery() {
        return (String)this.table.get(QUERY);
    }

    public void setName(String name) {
        this.table.put(NAME_OF, name);
    }

    public String getName() {
        return (String)this.table.get(NAME_OF);
    }

    public void setDatabaseServer(String appName) {
        this.table.put(DB_SERVER, appName);
    }

    public String getDatabaseServer() {
        return (String)this.table.get(DB_SERVER);
    }

    public void setPort(String portName) {
        this.table.put(PORT, portName);
    }

    public String getPort() {
        return (String)this.table.get(PORT);
    }

    public void setHost(String hostName) {
        this.table.put(HOST, hostName);
    }

    public String getHost() {
        return (String)this.table.get(HOST);
    }

    public void setFilePath(String fPath) {
        this.table.put(FILE_PATH, fPath);
    }

    public String getFilePath() {
        return (String)this.table.get(FILE_PATH);
    }

    public void setURI(String URI2) {
        this.table.put(URI, URI2);
    }

    public String getURI() {
        return (String)this.table.get(URI);
    }

    public void setImplementClass(String imClassName) {
        this.table.put(IMPL_CLASS, imClassName);
    }

    public String getImplementClass() {
        return (String)this.table.get(IMPL_CLASS);
    }

    public void setUser(String userName) {
        this.table.put(USER, userName);
    }

    public String getUser() {
        return (String)this.table.get(USER);
    }

    public void setPassword(String pswd) {
        this.table.put(PASSWORD, pswd);
    }

    public String getPassword() {
        return (String)this.table.get(PASSWORD);
    }

    public void printHelp() {
        String cmdswitch;
        String desc;
        String helpClass;
        NodeList list = this.getCommands();
        System.out.println();
        System.out.println("Xindice Command Tools v1.1b4");
        System.out.println();
        System.out.println("Format: xindice action [switch] [parameter]");
        System.out.println();
        System.out.println("Switches:");
        System.out.println("    -c           Collection context (must always be specified),");
        System.out.println("                 can be either canonical name of the collection");
        System.out.println("                 or complete xmldb URL");
        System.out.println("    -e           File extension for multiple documents");
        System.out.println("    -f           File path for document retrieval and storage");
        System.out.println("    -n           Name");
        System.out.println("    -p           Index pattern");
        System.out.println("    -q           Query string");
        System.out.println("    -s           Semi-colon delimited list of namespaces for query in ");
        System.out.println("                 the form prefix=namespace-uri");
        System.out.println("    -l           Use a local database rather then going over the network.");
        System.out.println("                 Should be combined with -d to specify the configuration to use.");
        System.out.println("    -d           Path to the database configuration to use for the local ");
        System.out.println("                 database. Only applies if -l is specified.");
        System.out.println("    -t           Specify the data type in collection index");
        System.out.println("    -v           Verbose");
        System.out.println("    --pagesize   Page size for file pages (default: 4096)");
        System.out.println("    --maxkeysize The maximum size for file keys (default: 0=none)");
        System.out.println();
        System.out.println("Actions:");
        int i = 0;
        while (i < list.getLength()) {
            helpClass = ((Element)list.item(i)).getAttribute("helpclass");
            if (helpClass.equals("document")) {
                desc = ((Element)list.item(i)).getAttribute("description");
                cmdswitch = ((Element)list.item(i)).getAttribute("switch");
                System.out.println("    " + StringUtilities.leftJustify(cmdswitch, 13) + desc);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < list.getLength()) {
            helpClass = ((Element)list.item(i2)).getAttribute("helpclass");
            if (helpClass.equals("security")) {
                desc = ((Element)list.item(i2)).getAttribute("description");
                cmdswitch = ((Element)list.item(i2)).getAttribute("switch");
                System.out.println("    " + StringUtilities.leftJustify(cmdswitch, 13) + desc);
            }
            ++i2;
        }
        System.out.println();
        System.out.println("Examples:");
        System.out.println("    xindice ad -c /db/test -f /tmp/xmldocument -n myxmldocument");
        System.out.println("    xindice dd -c /db/test -n myxmldocument");
        System.out.println("    xindice rd -c /db/test/ocs -f a:\\file.xml -n file.xml");
        System.out.println("    xindice xpath -c /db/test/ocs -q test");
        System.out.println("    xindice xpath -c /db/test -s a=http://somedomain.com/schema.xsd -q /a:foo");
        System.out.println("    xindice xupdate -c /db/test -f /path/to/xupdate.xml");
        System.out.println("    xindice xupdate -c /db/test -n document-to-update.xml -f /path/to/xupdate.xml");
        System.out.println();
        System.out.println("For more information, please read the Xindice - Tools Reference Guide");
        System.out.println();
    }
}

