/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.tools.command;

import java.io.File;
import java.io.FileFilter;
import java.util.Hashtable;
import org.apache.xindice.tools.command.Command;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;

public class ImportTree
extends Command {
    Command addDocument = null;
    Command addCollection = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(Hashtable table) throws Exception {
        Collection col;
        block8: {
            boolean bl;
            block7: {
                boolean bl2;
                block6: {
                    boolean bl3;
                    block5: {
                        col = null;
                        try {
                            this.addDocument = (Command)Class.forName("org.apache.xindice.tools.command.AddDocument").newInstance();
                            this.addCollection = (Command)Class.forName("org.apache.xindice.tools.command.AddCollection").newInstance();
                            String startcollection = null;
                            if (table.get("filePath") == null) {
                                System.out.println("ERROR : Directory name and switch required");
                                bl3 = false;
                                Object var7_7 = null;
                                if (col == null) return bl3;
                                break block5;
                            }
                            if (table.get("collection") == null) {
                                System.out.println("ERROR : Collection name and switch required");
                                bl2 = false;
                                break block6;
                            }
                            startcollection = (String)table.get("collection");
                            String colstring = this.normalizeCollectionURI(startcollection, (String)table.get("local"));
                            col = DatabaseManager.getCollection((String)colstring);
                            if (col == null) {
                                System.out.println("ERROR : Collection not found!");
                                bl = false;
                                break block7;
                            }
                            File startdir = new File((String)table.get("filePath"));
                            this.process(startdir, colstring, table);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var7_11 = null;
                            if (col == null) throw throwable;
                            col.close();
                            throw throwable;
                        }
                    }
                    col.close();
                    return bl3;
                }
                Object var7_8 = null;
                if (col == null) return bl2;
                col.close();
                return bl2;
            }
            Object var7_9 = null;
            if (col == null) return bl;
            col.close();
            return bl;
        }
        Object var7_10 = null;
        if (col == null) return true;
        col.close();
        return true;
    }

    void process(File directory, String baseCollection, Hashtable table) {
        try {
            String ext = (String)table.get("extension");
            if (!directory.isDirectory()) {
                System.out.println("ERROR: The specified import path is not a directory " + directory.getPath());
                return;
            }
            baseCollection = this.createCollection(baseCollection, directory.getName());
            File[] subdirs = directory.listFiles(new ExtensionFileFilter(ext));
            int i = 0;
            while (i < subdirs.length) {
                if (subdirs[i].isDirectory()) {
                    this.process(subdirs[i], baseCollection, table);
                } else {
                    this.importFile(baseCollection, subdirs[i].getAbsolutePath(), subdirs[i].getName());
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR : " + e.getMessage());
            if (table.get("verbose").equals("true")) {
                e.printStackTrace(System.err);
            }
            return;
        }
    }

    protected void importFile(String baseCollection, String path, String name) throws Exception {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("collection", baseCollection);
        table.put("filePath", path);
        table.put("nameOf", name);
        this.addDocument.execute(table);
    }

    protected String createCollection(String baseCollection, String newCollection) throws Exception {
        if (!newCollection.equals(".")) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("collection", baseCollection);
            table.put("nameOf", newCollection);
            this.addCollection.execute(table);
        } else {
            newCollection = "";
        }
        return baseCollection + "/" + newCollection;
    }

    private static class ExtensionFileFilter
    implements FileFilter {
        private String extension = "";

        public ExtensionFileFilter(String extension) {
            this.extension = extension;
        }

        public boolean accept(File pathname) {
            if (this.extension != "") {
                return pathname.getName().endsWith("." + this.extension) || pathname.isDirectory();
            }
            return true;
        }
    }
}

