/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.util;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.SymbolTableSymbols;
import org.apache.xindice.xml.dom.CompressedDocument;
import org.apache.xindice.xml.dom.DOMCompressor;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SymbolSerializer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$util$SymbolSerializer == null ? (class$org$apache$xindice$util$SymbolSerializer = SymbolSerializer.class$("org.apache.xindice.util.SymbolSerializer")) : class$org$apache$xindice$util$SymbolSerializer));
    private static final SymbolTableSymbols hcSyms = SymbolTableSymbols.getInstance();
    private static final DocumentImpl elemFactory = new DocumentImpl();
    private SymbolTable syms = null;
    private long lastMod = 0L;
    private byte[] symBytes = null;
    static /* synthetic */ Class class$org$apache$xindice$util$SymbolSerializer;

    public SymbolSerializer(SymbolTable syms) {
        this.syms = syms;
        elemFactory.setSymbols(syms);
    }

    public Hashtable getSymBuffer() {
        long lm = this.syms.getLastModified();
        if (lm > this.lastMod) {
            SymbolTable symbolTable = this.syms;
            synchronized (symbolTable) {
                block6: {
                    Element elem = this.syms.streamToXML(elemFactory);
                    try {
                        this.symBytes = DOMCompressor.Compress(elem, hcSyms);
                        this.lastMod = lm;
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block6;
                        log.error((Object)"Problem compressing Symbol Table!  Very Bad!", (Throwable)e);
                    }
                }
            }
        }
        Hashtable<String, byte[]> result = new Hashtable<String, byte[]>();
        result.put("symbols", this.symBytes);
        result.put("document", new byte[0]);
        return result;
    }

    public Hashtable convertFromDocument(Document doc, long stamp) {
        Hashtable result = this.getSymBuffer();
        byte[] docBytes = ((CompressedDocument)doc).getDataBytes();
        result.put("document", docBytes);
        return result;
    }

    public SymbolTable getSymbols() {
        return this.syms;
    }

    public long getLastModified() {
        return this.lastMod;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

