/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.XMLCompressedOutput;
import org.apache.xindice.xml.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMCompressor
extends XMLCompressedOutput {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$xml$dom$DOMCompressor == null ? (class$org$apache$xindice$xml$dom$DOMCompressor = DOMCompressor.class$("org.apache.xindice.xml.dom.DOMCompressor")) : class$org$apache$xindice$xml$dom$DOMCompressor));
    static /* synthetic */ Class class$org$apache$xindice$xml$dom$DOMCompressor;

    public DOMCompressor(OutputStream os, SymbolTable st) {
        super(os, st);
    }

    public void writeNode(Node node) throws IOException {
        if (node instanceof NodeImpl) {
            NodeImpl impl = (NodeImpl)node;
            if (!impl.dirty && impl.data != null) {
                this.write(impl.data, impl.pos, impl.len);
                this.flush();
                return;
            }
        }
        switch (node.getNodeType()) {
            case 1: {
                String nsURI = node.getNamespaceURI();
                short symbolID = nsURI != null ? this.st.getSymbol(node.getNodeName(), nsURI, true) : this.st.getSymbol(node.getNodeName(), true);
                int signature = 64;
                int attrLen = node.getAttributes().getLength();
                byte attrSize = this.getSizeType(attrLen);
                if (attrLen > 0) {
                    signature = (byte)(signature | 0x20);
                }
                if (node.hasChildNodes()) {
                    signature = (byte)(signature | 0x10);
                }
                signature = (byte)(signature | (byte)attrSize);
                byte[] children = this.buildChildren(node);
                int valLen = children.length;
                byte sizeType = this.getSizeType(valLen + 11);
                signature = (byte)(signature | (byte)(sizeType << 2));
                this.writeByte(signature);
                this.writeSize(sizeType, valLen += this.getSizeSize(sizeType) + 3);
                this.writeShort(symbolID);
                this.write(children);
                break;
            }
            case 2: {
                Attr attr = (Attr)node;
                String nsURI = attr.getNamespaceURI();
                short symbolID = nsURI != null ? this.st.getSymbol(attr.getName(), nsURI, true) : this.st.getSymbol(attr.getName(), true);
                this.writeShort(symbolID);
                byte[] b = attr.getValue().getBytes("UTF-8");
                this.writeShort((short)b.length);
                this.write(b);
                break;
            }
            case 3: {
                byte[] b = node.getNodeValue().getBytes("UTF-8");
                int valLen = b.length;
                byte sizeType = this.getSizeType(valLen + 5);
                byte signature = 0;
                signature = (byte)(signature | (byte)(sizeType << 2));
                this.writeByte(signature);
                this.writeSize(sizeType, valLen += this.getSizeSize(sizeType) + 1);
                this.write(b);
                break;
            }
            case 4: {
                byte[] b = node.getNodeValue().getBytes("UTF-8");
                int valLen = b.length;
                int signature = -64;
                signature = (byte)(signature | 0x10);
                this.writeByte(signature);
                this.writeInt(valLen += 5);
                this.write(b);
                break;
            }
            case 5: {
                String value = node.getNodeName();
                int signature = 0;
                signature = (byte)(signature | 0x10);
                int symbol = 0;
                int encoding = 0;
                if (value.equals("&amp;")) {
                    signature = (byte)(signature | 2);
                } else if (value.equals("&lt;")) {
                    signature = (byte)(signature | 3);
                } else if (value.equals("&gt;")) {
                    signature = (byte)(signature | 4);
                } else if (value.equals("&quot;")) {
                    signature = (byte)(signature | 5);
                } else if (value.equals("&apos;")) {
                    signature = (byte)(signature | 6);
                } else if (value.startsWith("&#x")) {
                    encoding = 1;
                    signature = (byte)(signature | 0x1F);
                } else {
                    encoding = 2;
                    symbol = this.st.getSymbol(value, true);
                    signature = (byte)(signature | 1);
                }
                this.writeByte(signature);
                if (encoding <= 0) break;
                this.writeShort(symbol);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                String value = node.getNodeName() + " " + node.getNodeValue();
                byte[] b = value.getBytes("UTF-8");
                int valLen = b.length;
                int signature = -128;
                this.writeByte(signature);
                this.writeInt(valLen += 5);
                this.write(b);
                break;
            }
            case 8: {
                byte[] b = node.getNodeValue().getBytes("UTF-8");
                int valLen = b.length;
                int signature = -64;
                signature = (byte)(signature | 0x20);
                this.writeByte(signature);
                this.writeInt(valLen += 5);
                this.write(b);
                break;
            }
            case 9: {
                byte[] children = this.buildChildren(node);
                this.writeInt(children.length);
                this.write(children);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                byte[] children = this.buildChildren(node);
                this.writeInt(children.length);
                this.write(children);
                break;
            }
            case 12: {
                break;
            }
            default: {
                if (!log.isWarnEnabled()) break;
                log.warn((Object)("invalid node type : " + node.getNodeType()));
            }
        }
        this.flush();
    }

    private byte[] buildChildren(Node node) throws IOException {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedOutputStream buf = new BufferedOutputStream(bos, 4096);
        DOMCompressor out = new DOMCompressor(buf, this.st);
        if (node.getNodeType() == 1) {
            NamedNodeMap attrs = node.getAttributes();
            len = attrs.getLength();
            byte sizeType = this.getSizeType(len);
            out.writeSize(sizeType, len);
            int i = 0;
            while (i < len) {
                out.writeNode(attrs.item(i));
                ++i;
            }
        }
        NodeList children = node.getChildNodes();
        len = children.getLength();
        int i = 0;
        while (i < len) {
            out.writeNode(children.item(i));
            ++i;
        }
        out.flush();
        return bos.toByteArray();
    }

    public static byte[] Compress(Node node, SymbolTable symbols) throws XindiceException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedOutputStream buf = new BufferedOutputStream(bos, 4096);
            DOMCompressor xco = new DOMCompressor(buf, symbols);
            node.normalize();
            xco.writeNode(node);
            xco.flush();
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new XindiceException("XML Compression Error", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

