/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom;

import org.apache.xindice.xml.dom.DocumentImpl;
import org.apache.xindice.xml.dom.DocumentTypeImpl;
import org.apache.xindice.xml.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public final class DOMImplementationImpl
implements DOMImplementation {
    private static final String[][] FEATURES = new String[][]{{"XML", "1.0"}, {"XML", "2.0"}, {"Traversal", "2.0"}, {"Xindice-DB", "1.0"}, {"Xindice-Comp", "1.0"}};
    private static final DOMImplementation domImpl = new DOMImplementationImpl();

    private DOMImplementationImpl() {
    }

    public static DOMImplementation getInstance() {
        return domImpl;
    }

    public static boolean HasFeature(String feature, String version) {
        int i = 0;
        while (i < FEATURES.length) {
            if (FEATURES[i][0].equals(feature) && FEATURES[i][1].equals(version)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasFeature(String feature, String version) {
        return DOMImplementationImpl.HasFeature(feature, version);
    }

    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
        return new DocumentTypeImpl();
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        DocumentImpl doc = new DocumentImpl();
        Element elem = doc.createElement(qualifiedName);
        doc.appendChild(elem);
        if (namespaceURI != null) {
            if (qualifiedName.indexOf(":") != -1) {
                elem.setAttribute("xmlns:" + qualifiedName.substring(0, qualifiedName.indexOf(":")), namespaceURI);
            } else {
                elem.setAttribute("xmlns", namespaceURI);
            }
        }
        if (doctype != null) {
            if (doctype.getOwnerDocument() != null || !(doctype instanceof DocumentTypeImpl)) {
                throw NodeImpl.EX_WRONG_DOCUMENT;
            }
            doc.setDoctype(doctype);
        }
        return doc;
    }
}

