/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private ClassLoader m_classLoader;

    public ClassLoaderObjectInputStream(ClassLoader classLoader, byte[] byteArray) throws IOException, StreamCorruptedException {
        super(new ByteArrayInputStream(byteArray));
        this.m_classLoader = classLoader;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.m_classLoader.loadClass(objectStreamClass.getName());
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (null != clazz) {
            return clazz;
        }
        return super.resolveClass(objectStreamClass);
    }
}

