/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting.modular;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.AbstractComplementaryConfigurableAction;
import org.apache.cocoon.components.modules.database.AutoIncrementModule;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.modules.output.OutputModule;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.HashMap;
import org.apache.cocoon.util.JDBCTypeConversions;
import org.apache.commons.lang.BooleanUtils;

public abstract class DatabaseAction
extends AbstractComplementaryConfigurableAction
implements Configurable,
Disposable,
ThreadSafe {
    static final Integer MODE_AUTOINCR = new Integer(0);
    static final Integer MODE_OTHERS = new Integer(1);
    static final Integer MODE_OUTPUT = new Integer(2);
    static final String ATTRIBUTE_KEY = "org.apache.cocoon.action.modular.DatabaseAction.outputModeName";
    static final String inputHint = "request-param";
    static final String outputHint = "request-attr";
    static final String databaseHint = "manual";
    static final String INPUT_MODULE_SELECTOR = InputModule.ROLE + "Selector";
    static final String OUTPUT_MODULE_SELECTOR = OutputModule.ROLE + "Selector";
    static final String DATABASE_MODULE_SELECTOR = AutoIncrementModule.ROLE + "Selector";
    protected ServiceSelector dbselector;
    protected Map defaultModeNames = new HashMap(3);
    protected final HashMap cachedQueryData = new HashMap();
    protected String pathSeparator = ".";
    protected int firstRow = 0;
    protected boolean failOnEmpty = true;

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        if (this.settings != null) {
            String tmp;
            block4: {
                this.defaultModeNames.put(MODE_OTHERS, this.settings.get((Object)"input", (Object)inputHint));
                this.defaultModeNames.put(MODE_OUTPUT, this.settings.get((Object)"output", (Object)outputHint));
                this.defaultModeNames.put(MODE_AUTOINCR, this.settings.get((Object)"autoincrement", (Object)databaseHint));
                this.pathSeparator = (String)this.settings.get((Object)"path-separator", (Object)this.pathSeparator);
                tmp = (String)this.settings.get((Object)"first-row", null);
                if (tmp != null) {
                    try {
                        this.firstRow = Integer.parseInt(tmp);
                    }
                    catch (NumberFormatException nfe) {
                        if (!this.getLogger().isWarnEnabled()) break block4;
                        this.getLogger().warn("problem parsing first row option " + tmp + " using default instead.");
                    }
                }
            }
            tmp = (String)this.settings.get((Object)"fail-on-empty", (Object)String.valueOf(this.failOnEmpty));
            this.failOnEmpty = BooleanUtils.toBoolean((String)tmp);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.dbselector = (ServiceSelector)manager.lookup(DataSourceComponent.ROLE + "Selector");
    }

    public void dispose() {
        this.manager.release((Object)this.dbselector);
    }

    protected DataSourceComponent getDataSource(Configuration conf, Parameters parameters) throws ServiceException {
        String sourceName = parameters.getParameter("connection", (String)this.settings.get((Object)"connection"));
        if (sourceName == null) {
            Configuration dsn = conf.getChild("connection");
            return (DataSourceComponent)this.dbselector.select((Object)dsn.getValue(""));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Using datasource: " + sourceName);
        }
        return (DataSourceComponent)this.dbselector.select((Object)sourceName);
    }

    protected final boolean isLargeObject(String type) {
        if ("ascii".equals(type)) {
            return true;
        }
        if ("binary".equals(type)) {
            return true;
        }
        return "image".equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setOutputAttribute(Map objectModel, String outputMode, String key, Object value) {
        ServiceSelector outputSelector;
        block12: {
            outputSelector = null;
            OutputModule output = null;
            try {
                block11: {
                    try {
                        outputSelector = (ServiceSelector)this.manager.lookup(OUTPUT_MODULE_SELECTOR);
                        if (outputMode != null && outputSelector != null && outputSelector.isSelectable((Object)outputMode)) {
                            output = (OutputModule)outputSelector.select((Object)outputMode);
                        }
                        if (output != null) {
                            output.setAttribute(null, objectModel, key, value);
                            break block11;
                        }
                        if (this.getLogger().isWarnEnabled()) {
                            this.getLogger().warn("Could not select output mode " + outputMode);
                        }
                    }
                    catch (Exception e) {
                        if (this.getLogger().isWarnEnabled()) {
                            this.getLogger().warn("Could not select output mode " + outputMode + ":" + e.getMessage());
                        }
                        Object var9_8 = null;
                        if (outputSelector == null) return;
                        if (output != null) {
                            outputSelector.release(output);
                        }
                        this.manager.release((Object)outputSelector);
                        return;
                    }
                }
                Object var9_7 = null;
                if (outputSelector == null) return;
                if (output == null) break block12;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (outputSelector == null) throw throwable;
                if (output != null) {
                    outputSelector.release(output);
                }
                this.manager.release((Object)outputSelector);
                throw throwable;
            }
            outputSelector.release((Object)output);
        }
        this.manager.release((Object)outputSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int processTable(Configuration table, Connection conn, Map objectModel, Map results, Map modeTypes) throws SQLException, ConfigurationException, Exception {
        Statement statement = null;
        int rows = 0;
        try {
            LookUpKey luk = new LookUpKey(table, modeTypes);
            CacheHelper queryData = null;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("modeTypes : " + modeTypes);
            }
            HashMap hashMap = this.cachedQueryData;
            synchronized (hashMap) {
                queryData = (CacheHelper)this.cachedQueryData.get((Object)luk, null);
                if (queryData == null) {
                    queryData = this.getQuery(table, modeTypes, this.defaultModeNames);
                    this.cachedQueryData.put((Object)luk, (Object)queryData);
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("query: " + queryData.queryString);
            }
            statement = conn.prepareStatement(queryData.queryString);
            Object[][] columnValues = this.getColumnValues(table, queryData, objectModel);
            int setLength = 1;
            if (queryData.isSet) {
                setLength = columnValues[queryData.setMaster] != null ? columnValues[queryData.setMaster].length : 0;
            }
            for (int rowIndex = 0; rowIndex < setLength; ++rowIndex) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("====> row no. " + rowIndex);
                }
                rows += this.processRow(objectModel, conn, (PreparedStatement)statement, (String)modeTypes.get(MODE_OUTPUT), table, queryData, columnValues, rowIndex, results);
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {}
        return rows;
    }

    protected Configuration getMode(Configuration conf, String type) throws ConfigurationException {
        String modeAll = "all";
        Configuration[] modes = conf.getChildren("mode");
        Configuration modeConfig = null;
        for (int i = 0; i < modes.length; ++i) {
            String modeType = modes[i].getAttribute("type", "others");
            if (!modeType.equals(type) && !modeType.equals(modeAll)) continue;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("requested mode was \"" + type + "\" returning \"" + modeType + "\"");
            }
            modeConfig = modes[i];
            break;
        }
        return modeConfig;
    }

    protected String getOutputName(Configuration tableConf, Configuration columnConf) {
        return this.getOutputName(tableConf, columnConf, -1);
    }

    protected String getOutputName(Configuration tableConf, Configuration columnConf, int rowIndex) {
        rowIndex = rowIndex != -1 && this.settings.containsKey((Object)"append-row") && (this.settings.get((Object)"append-row").toString().equalsIgnoreCase("false") || this.settings.get((Object)"append-row").toString().equalsIgnoreCase("0")) ? -1 : (rowIndex += this.firstRow);
        if (this.settings.containsKey((Object)"append-table-name") && (this.settings.get((Object)"append-table-name").toString().equalsIgnoreCase("false") || this.settings.get((Object)"append-table-name").toString().equalsIgnoreCase("0"))) {
            return columnConf.getAttribute("name", null) + (rowIndex == -1 ? "" : "[" + rowIndex + "]");
        }
        return tableConf.getAttribute("alias", tableConf.getAttribute("name", null)) + this.pathSeparator + columnConf.getAttribute("name", null) + (rowIndex == -1 ? "" : "[" + rowIndex + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getColumnValue(Configuration tableConf, Column column, Map objectModel) throws ConfigurationException, ServiceException {
        Object[] values;
        block12: {
            ServiceSelector inputSelector;
            block13: {
                if (column.isAutoIncrement) {
                    return new Object[1];
                }
                String cname = this.getOutputName(tableConf, column.columnConf);
                inputSelector = null;
                InputModule input = null;
                try {
                    inputSelector = (ServiceSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    if (column.mode != null && inputSelector != null && inputSelector.isSelectable((Object)column.mode)) {
                        input = (InputModule)inputSelector.select((Object)column.mode);
                    }
                    if (column.isSet) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Trying to set column " + cname + " from " + column.mode + " using getAttributeValues method");
                        }
                        values = input.getAttributeValues(cname, column.modeConf, objectModel);
                    } else {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Trying to set column " + cname + " from " + column.mode + " using getAttribute method");
                        }
                        values = new Object[]{input.getAttribute(cname, column.modeConf, objectModel)};
                    }
                    if (values != null) {
                        for (int i = 0; i < values.length; ++i) {
                            if (!this.getLogger().isDebugEnabled()) continue;
                            this.getLogger().debug("Setting column " + cname + " [" + i + "] " + values[i]);
                        }
                    }
                    Object var10_9 = null;
                    if (inputSelector == null) break block12;
                    if (input == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (inputSelector != null) {
                        if (input != null) {
                            inputSelector.release(input);
                        }
                        this.manager.release((Object)inputSelector);
                    }
                    throw throwable;
                }
                inputSelector.release((Object)input);
            }
            this.manager.release((Object)inputSelector);
            {
            }
        }
        return values;
    }

    protected void fillModes(Configuration[] conf, boolean isKey, Map defaultModeNames, Map modeTypes, CacheHelper set) throws ConfigurationException {
        int offset;
        String setMode = null;
        for (int i = offset = isKey ? 0 : set.noOfKeys; i < conf.length + offset; ++i) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("i=" + i);
            }
            set.columns[i].columnConf = conf[i - offset];
            set.columns[i].isSet = false;
            set.columns[i].isKey = isKey;
            set.columns[i].isAutoIncrement = false;
            if (isKey & this.honourAutoIncrement()) {
                set.columns[i].isAutoIncrement = set.columns[i].columnConf.getAttributeAsBoolean("autoincrement", false);
            }
            set.columns[i].modeConf = this.getMode(set.columns[i].columnConf, this.selectMode(set.columns[i].isAutoIncrement, modeTypes));
            set.columns[i].mode = set.columns[i].modeConf != null ? set.columns[i].modeConf.getAttribute("name", this.selectMode(isKey, defaultModeNames)) : this.selectMode(isKey, defaultModeNames);
            setMode = set.columns[i].columnConf.getAttribute("set", null);
            if (setMode == null && set.columns[i].modeConf != null) {
                setMode = set.columns[i].modeConf.getAttribute("set", null);
            }
            if (setMode == null) continue;
            set.columns[i].isSet = true;
            set.isSet = true;
            if (!setMode.equals("master")) continue;
            set.setMaster = i;
        }
    }

    protected void setOutput(Map objectModel, String outputMode, Map results, Configuration table, Configuration column, int rowIndex, Object value) {
        String param = this.getOutputName(table, column, rowIndex);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting column " + param + " to " + value);
        }
        this.setOutputAttribute(objectModel, outputMode, param, value);
        if (results != null) {
            results.put(param, String.valueOf(value));
        }
    }

    protected void setColumn(PreparedStatement statement, int position, Configuration entry, Object value) throws Exception {
        JDBCTypeConversions.setColumn(statement, position, value, (Integer)JDBCTypeConversions.typeConstants.get(entry.getAttribute("type")));
    }

    protected void setColumn(Map objectModel, String outputMode, Map results, Configuration table, Configuration column, int rowIndex, Object value, PreparedStatement statement, int position) throws Exception {
        if (results != null) {
            this.setOutput(objectModel, outputMode, results, table, column, rowIndex, value);
        }
        this.setColumn(statement, position, column, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters param) throws Exception {
        boolean failed;
        int rows;
        HashMap results;
        block68: {
            String outputMode;
            Connection conn;
            DataSourceComponent datasource;
            block63: {
                block61: {
                    OutputModule output;
                    ServiceSelector outputSelector;
                    block62: {
                        Configuration conf;
                        block59: {
                            datasource = null;
                            conn = null;
                            results = new HashMap();
                            rows = 0;
                            failed = false;
                            boolean reloadable = true;
                            outputMode = param.getParameter("output", (String)this.defaultModeNames.get(MODE_OUTPUT));
                            if (this.settings.containsKey((Object)"reloadable")) {
                                reloadable = Boolean.valueOf((String)this.settings.get((Object)"reloadable"));
                            }
                            conf = this.getConfiguration(param.getParameter("descriptor", (String)this.settings.get((Object)"descriptor")), resolver, param.getParameterAsBoolean("reloadable", reloadable));
                            datasource = this.getDataSource(conf, param);
                            conn = datasource.getConnection();
                            if (conn.getAutoCommit()) {
                                try {
                                    conn.setAutoCommit(false);
                                }
                                catch (Exception ex) {
                                    String tmp = param.getParameter("use-transactions", (String)this.settings.get((Object)"use-transactions", null));
                                    if (tmp == null || !tmp.equalsIgnoreCase("no") && !tmp.equalsIgnoreCase("false") && !tmp.equalsIgnoreCase("0")) break block59;
                                    if (this.getLogger().isErrorEnabled()) {
                                        this.getLogger().error("This DB connection does not support transactions. If you want to risk your data's integrity by continuing nonetheless set parameter \"use-transactions\" to \"no\".");
                                    }
                                    throw ex;
                                }
                            }
                        }
                        Configuration[] tables = conf.getChildren("table");
                        String tablesetname = param.getParameter("table-set", (String)this.settings.get((Object)"table-set"));
                        HashMap modeTypes = null;
                        if (tablesetname == null) {
                            modeTypes = new HashMap(6);
                            modeTypes.put(MODE_AUTOINCR, "autoincr");
                            modeTypes.put(MODE_OTHERS, "others");
                            modeTypes.put(MODE_OUTPUT, outputMode);
                            for (int i = 0; i < tables.length; ++i) {
                                rows += this.processTable(tables[i], conn, objectModel, (Map)results, (Map)modeTypes);
                            }
                        } else {
                            HashMap tableIndex = new HashMap(2 * tables.length);
                            String tableName = null;
                            Integer result = null;
                            for (int i = 0; i < tables.length; ++i) {
                                tableName = tables[i].getAttribute("alias", tables[i].getAttribute("name", ""));
                                result = tableIndex.put(tableName, new Integer(i));
                                if (result == null) continue;
                                throw new IOException("Duplicate table entry for " + tableName + " at positions " + result + " and " + i);
                            }
                            Configuration[] tablesets = conf.getChildren("table-set");
                            String setname = null;
                            boolean found = false;
                            int j = 0;
                            for (j = 0; j < tablesets.length; ++j) {
                                setname = tablesets[j].getAttribute("name", "");
                                if (!tablesetname.trim().equals(setname.trim())) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                throw new IOException(" given set " + tablesetname + " does not exists in a description file.");
                            }
                            Configuration[] set = tablesets[j].getChildren("table");
                            for (int i = 0; i < set.length; ++i) {
                                modeTypes = new HashMap(6);
                                modeTypes.put(MODE_AUTOINCR, set[i].getAttribute("autoincr-mode", "autoincr"));
                                modeTypes.put(MODE_OTHERS, set[i].getAttribute("others-mode", "others"));
                                modeTypes.put(MODE_OUTPUT, outputMode);
                                tableName = set[i].getAttribute("name", "");
                                if (tableIndex.containsKey(tableName)) {
                                    j = (Integer)tableIndex.get(tableName);
                                    rows += this.processTable(tables[j], conn, objectModel, (Map)results, (Map)modeTypes);
                                    continue;
                                }
                                throw new IOException(" given table " + tableName + " does not exists in a description file.");
                            }
                        }
                        if (!conn.getAutoCommit()) {
                            conn.commit();
                        }
                        outputSelector = null;
                        output = null;
                        try {
                            block60: {
                                outputSelector = (ServiceSelector)this.manager.lookup(OUTPUT_MODULE_SELECTOR);
                                if (outputMode != null && outputSelector != null && outputSelector.isSelectable((Object)outputMode)) {
                                    output = (OutputModule)outputSelector.select((Object)outputMode);
                                }
                                if (output != null) {
                                    output.commit(null, objectModel);
                                    break block60;
                                }
                                if (!this.getLogger().isWarnEnabled()) break block60;
                                this.getLogger().warn("Could not select output mode " + outputMode);
                            }
                            Object var27_36 = null;
                            if (outputSelector == null) break block61;
                            if (output == null) break block62;
                        }
                        catch (Throwable throwable) {
                            Object var27_38 = null;
                            if (outputSelector != null) {
                                if (output != null) {
                                    outputSelector.release(output);
                                }
                                this.manager.release((Object)outputSelector);
                            }
                            throw throwable;
                        }
                        outputSelector.release((Object)output);
                    }
                    this.manager.release((Object)outputSelector);
                    {
                        break block61;
                        catch (ServiceException e) {
                            if (this.getLogger().isWarnEnabled()) {
                                this.getLogger().warn("Could not select output mode " + outputMode + ":" + e.getMessage());
                            }
                            Object var27_37 = null;
                            if (outputSelector != null) {
                                if (output != null) {
                                    outputSelector.release(output);
                                }
                                this.manager.release((Object)outputSelector);
                            }
                        }
                    }
                }
                Object var31_40 = null;
                if (conn == null) break block63;
                try {
                    conn.close();
                }
                catch (SQLException sqe) {
                    this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                }
            }
            if (datasource != null) {
                this.dbselector.release((Object)datasource);
            }
            break block68;
            {
                catch (Exception e) {
                    String throwException;
                    block65: {
                        failed = true;
                        if (conn != null) {
                            try {
                                OutputModule output;
                                ServiceSelector outputSelector;
                                block66: {
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug("Rolling back transaction. Caused by " + e.getMessage());
                                        e.printStackTrace();
                                    }
                                    conn.rollback();
                                    results = null;
                                    outputSelector = null;
                                    output = null;
                                    try {
                                        block64: {
                                            outputSelector = (ServiceSelector)this.manager.lookup(OUTPUT_MODULE_SELECTOR);
                                            if (outputMode != null && outputSelector != null && outputSelector.isSelectable((Object)outputMode)) {
                                                output = (OutputModule)outputSelector.select((Object)outputMode);
                                            }
                                            if (output != null) {
                                                output.rollback(null, objectModel, e);
                                                break block64;
                                            }
                                            if (!this.getLogger().isWarnEnabled()) break block64;
                                            this.getLogger().warn("Could not select output mode " + outputMode);
                                        }
                                        Object var29_46 = null;
                                        if (outputSelector == null) break block65;
                                        if (output == null) break block66;
                                    }
                                    catch (Throwable throwable) {
                                        Object var29_48 = null;
                                        if (outputSelector != null) {
                                            if (output != null) {
                                                outputSelector.release(output);
                                            }
                                            this.manager.release((Object)outputSelector);
                                        }
                                        throw throwable;
                                    }
                                    outputSelector.release((Object)output);
                                }
                                this.manager.release((Object)outputSelector);
                                {
                                    break block65;
                                    catch (ServiceException e2) {
                                        if (this.getLogger().isWarnEnabled()) {
                                            this.getLogger().warn("Could not select output mode " + outputMode + ":" + e2.getMessage());
                                        }
                                        Object var29_47 = null;
                                        if (outputSelector != null) {
                                            if (output != null) {
                                                outputSelector.release(output);
                                            }
                                            this.manager.release((Object)outputSelector);
                                        }
                                    }
                                }
                            }
                            catch (SQLException se) {
                                if (!this.getLogger().isDebugEnabled()) break block65;
                                this.getLogger().debug("There was an error rolling back the transaction", (Throwable)se);
                            }
                        }
                    }
                    if ((throwException = (String)this.settings.get((Object)"throw-exception", (Object)param.getParameter("throw-exception", null))) != null && BooleanUtils.toBoolean((String)throwException)) {
                        throw new ProcessingException("Cannot process the requested SQL statement ", (Throwable)e);
                    }
                    Object var31_41 = null;
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sqe) {
                            this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                        }
                    }
                    if (datasource != null) {
                        this.dbselector.release((Object)datasource);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var31_42 = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sqe) {
                        this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                    }
                }
                if (datasource != null) {
                    this.dbselector.release(datasource);
                }
                throw throwable;
            }
        }
        if (results != null) {
            if (rows > 0 || !failed && !this.failOnEmpty) {
                results.put("row-count", new Integer(rows));
            } else {
                results = null;
            }
        } else if (rows > 0) {
            results = new HashMap(1);
            results.put("row-count", new Integer(rows));
        }
        return results;
    }

    protected abstract int processRow(Map var1, Connection var2, PreparedStatement var3, String var4, Configuration var5, CacheHelper var6, Object[][] var7, int var8, Map var9) throws SQLException, ConfigurationException, Exception;

    protected abstract String selectMode(boolean var1, Map var2);

    protected abstract boolean honourAutoIncrement();

    abstract Object[][] getColumnValues(Configuration var1, CacheHelper var2, Map var3) throws ConfigurationException, ServiceException;

    protected abstract CacheHelper getQuery(Configuration var1, Map var2, Map var3) throws ConfigurationException, ServiceException;

    protected static class LookUpKey {
        public Configuration tableConf = null;
        public Map modeTypes = null;

        public LookUpKey(Configuration tableConf, Map modeTypes) {
            this.tableConf = tableConf;
            this.modeTypes = modeTypes;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj != null && obj instanceof LookUpKey) {
                LookUpKey luk = (LookUpKey)obj;
                result = true;
                boolean bl = result && (luk.tableConf == null ? this.tableConf == null : luk.tableConf.equals(this.tableConf)) ? true : (result = false);
                result = result && (luk.modeTypes == null ? this.modeTypes == null : ((Object)luk.modeTypes).equals(this.modeTypes));
            }
            return result;
        }

        public int hashCode() {
            return this.tableConf != null ? this.tableConf.hashCode() : (this.modeTypes != null ? ((Object)this.modeTypes).hashCode() : super.hashCode());
        }
    }

    protected static class CacheHelper {
        public String queryString = null;
        public int setMaster = -1;
        public boolean isSet = false;
        public int noOfKeys = 0;
        public Column[] columns = null;

        public CacheHelper(int cols) {
            this(0, cols);
        }

        public CacheHelper(int keys, int cols) {
            this.noOfKeys = keys;
            this.columns = new Column[cols];
            for (int i = 0; i < cols; ++i) {
                this.columns[i] = new Column();
            }
        }
    }

    protected static class Column {
        boolean isKey = false;
        boolean isSet = false;
        boolean isAutoIncrement = false;
        String mode = null;
        Configuration modeConf = null;
        Configuration columnConf = null;

        protected Column() {
        }
    }
}

