/*
 * Copyright 1999-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.util.DomHelper;
import org.w3c.dom.Element;

/**
 * Builds {@link MultiValueFieldDefinition}s.
 * 
 * @version $Id: MultiValueFieldDefinitionBuilder.java 155210 2005-02-24 17:02:09Z sylvain $
 */
public class MultiValueFieldDefinitionBuilder extends AbstractDatatypeWidgetDefinitionBuilder {

    public WidgetDefinition buildWidgetDefinition(Element widgetElement) throws Exception {
        MultiValueFieldDefinition definition = new MultiValueFieldDefinition();
        setupDefinition(widgetElement, definition);
        if (definition.getSelectionList() == null)
            throw new Exception("Error: multivaluefield always require a selectionlist at " +
                    DomHelper.getLocation(widgetElement));
        definition.makeImmutable();
        return definition;
    }
}
