/*
 * Copyright 1999-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cocoon.forms.formmodel;

/**
 * Definition for a {@link Submit}.
 * 
 * @see SubmitDefinitionBuilder
 * @author <a href="http://www.apache.org/~sylvain/">Sylvain Wallez</a>
 * @version $Id: SubmitDefinition.java 155210 2005-02-24 17:02:09Z sylvain $
 */
public class SubmitDefinition extends ActionDefinition {
    
    private boolean validateForm;
    
    public void setValidateForm(boolean validateForm) {
        checkMutable();
        this.validateForm = validateForm;
    }
    
    public Widget createInstance() {
        return new Submit(this, validateForm);
    }
}
