/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.flow.ContinuationsDisposer;
import org.apache.cocoon.components.flow.ContinuationsManager;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.thread.RunnableManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.excalibur.instrument.CounterInstrument;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.Instrumentable;
import org.apache.excalibur.instrument.ValueInstrument;

public class ContinuationsManagerImpl
extends AbstractLogEnabled
implements ContinuationsManager,
Component,
Configurable,
ThreadSafe,
Instrumentable,
Serviceable,
Contextualizable {
    static final int CONTINUATION_ID_LENGTH = 20;
    static final String EXPIRE_CONTINUATIONS = "expire-continuations";
    protected SecureRandom random;
    protected byte[] bytes;
    protected int defaultTimeToLive;
    protected Set forest = Collections.synchronizedSet(new HashSet());
    protected WebContinuationsHolder continuationsHolder;
    protected SortedSet expirations = Collections.synchronizedSortedSet(new TreeSet());
    private String instrumentableName;
    private ValueInstrument continuationsCount;
    private int continuationsCounter;
    private ValueInstrument forestSize;
    private ValueInstrument expirationsSize;
    private CounterInstrument continuationsCreated;
    private CounterInstrument continuationsInvalidated;
    private boolean isContinuationSharingBugCompatible;
    private boolean bindContinuationsToSession;
    private ServiceManager serviceManager;
    private Context context;

    public ContinuationsManagerImpl() throws Exception {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException nsae) {
            this.random = SecureRandom.getInstance("IBMSecureRandom");
        }
        this.random.setSeed(System.currentTimeMillis());
        this.bytes = new byte[20];
        this.continuationsCount = new ValueInstrument("count");
        this.continuationsCounter = 0;
        this.forestSize = new ValueInstrument("forest-size");
        this.expirationsSize = new ValueInstrument("expirations-size");
        this.continuationsCreated = new CounterInstrument("creates");
        this.continuationsInvalidated = new CounterInstrument("invalidates");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.serviceManager = manager;
    }

    public void configure(Configuration config) {
        this.defaultTimeToLive = config.getAttributeAsInteger("time-to-live", 3600000);
        this.isContinuationSharingBugCompatible = config.getAttributeAsBoolean("continuation-sharing-bug-compatible", false);
        this.bindContinuationsToSession = config.getAttributeAsBoolean("session-bound-continuations", false);
        if (!this.bindContinuationsToSession) {
            this.continuationsHolder = new WebContinuationsHolder();
        }
        Configuration expireConf = config.getChild("expirations-check");
        long initialDelay = expireConf.getChild("offset", true).getValueAsLong(180000L);
        long interval = expireConf.getChild("period", true).getValueAsLong(180000L);
        try {
            RunnableManager runnableManager = (RunnableManager)this.serviceManager.lookup(RunnableManager.ROLE);
            runnableManager.execute(new Runnable(){

                public void run() {
                    ContinuationsManagerImpl.this.expireContinuations();
                }
            }, initialDelay, interval);
            this.serviceManager.release((Object)runnableManager);
        }
        catch (Exception e) {
            this.getLogger().warn("Could not enqueue continuations expiration task. Continuations will not automatically expire.", (Throwable)e);
        }
    }

    public void setInstrumentableName(String instrumentableName) {
        this.instrumentableName = instrumentableName;
    }

    public String getInstrumentableName() {
        return this.instrumentableName;
    }

    public Instrument[] getInstruments() {
        return new Instrument[]{this.continuationsCount, this.continuationsCreated, this.continuationsInvalidated, this.forestSize};
    }

    public Instrumentable[] getChildInstrumentables() {
        return Instrumentable.EMPTY_INSTRUMENTABLE_ARRAY;
    }

    public WebContinuation createWebContinuation(Object kont, WebContinuation parent, int timeToLive, String interpreterId, ContinuationsDisposer disposer) {
        int ttl = timeToLive == 0 ? this.defaultTimeToLive : timeToLive;
        WebContinuation wk = this.generateContinuation(kont, parent, ttl, interpreterId, disposer);
        wk.enableLogging(this.getLogger());
        if (parent == null) {
            this.forest.add(wk);
            this.forestSize.setValue(this.forest.size());
        } else if (parent.getChildren().size() < 2) {
            this.expirations.remove(parent);
        }
        this.expirations.add(wk);
        this.expirationsSize.setValue(this.expirations.size());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("WK: Created continuation " + wk.getId());
        }
        return wk;
    }

    public WebContinuation lookupWebContinuation(String id, String interpreterId) {
        WebContinuationsHolder continuationsHolder = this.lookupWebContinuationsHolder(false);
        if (continuationsHolder == null) {
            return null;
        }
        WebContinuation kont = continuationsHolder.get(id);
        if (kont != null) {
            boolean interpreterMatches = kont.interpreterMatches(interpreterId);
            if (!interpreterMatches && this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("WK: Continuation (" + kont.getId() + ") lookup for wrong interpreter. Bound to: " + kont.getInterpreterId() + ", looked up for: " + interpreterId);
            }
            return interpreterMatches || this.isContinuationSharingBugCompatible ? kont : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebContinuation generateContinuation(Object kont, WebContinuation parent, int ttl, String interpreterId, ContinuationsDisposer disposer) {
        char[] result = new char[this.bytes.length * 2];
        WebContinuation wk = null;
        WebContinuationsHolder continuationsHolder = this.lookupWebContinuationsHolder(true);
        while (true) {
            this.random.nextBytes(this.bytes);
            for (int i = 0; i < 20; ++i) {
                byte ch = this.bytes[i];
                result[2 * i] = Character.forDigit(Math.abs(ch >> 4), 16);
                result[2 * i + 1] = Character.forDigit(Math.abs(ch & 0xF), 16);
            }
            String id = new String(result);
            WebContinuationsHolder webContinuationsHolder = continuationsHolder;
            synchronized (webContinuationsHolder) {
                if (!continuationsHolder.contains(id)) {
                    wk = this.bindContinuationsToSession ? new HolderAwareWebContinuation(id, kont, parent, ttl, interpreterId, disposer, continuationsHolder) : new WebContinuation(id, kont, parent, ttl, interpreterId, disposer);
                    continuationsHolder.addContinuation(wk);
                    ValueInstrument valueInstrument = this.continuationsCount;
                    synchronized (valueInstrument) {
                        ++this.continuationsCounter;
                        this.continuationsCount.setValue(this.continuationsCounter);
                    }
                }
            }
        }
        this.continuationsCreated.increment();
        return wk;
    }

    public void invalidateWebContinuation(WebContinuation wk) {
        WebContinuationsHolder continuationsHolder = this.lookupWebContinuationsHolder(false);
        if (!continuationsHolder.contains(wk)) {
            return;
        }
        this._detach(wk);
        this._invalidate(continuationsHolder, wk);
    }

    private void _invalidate(WebContinuationsHolder continuationsHolder, WebContinuation wk) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("WK: Manual expire of continuation " + wk.getId());
        }
        this.disposeContinuation(continuationsHolder, wk);
        this.expirations.remove(wk);
        this.expirationsSize.setValue(this.expirations.size());
        List children = wk.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            this._invalidate(continuationsHolder, (WebContinuation)children.get(i));
        }
    }

    private void _detach(WebContinuation wk) {
        WebContinuation parent = wk.getParentContinuation();
        if (parent == null) {
            this.forest.remove(wk);
            this.forestSize.setValue(this.forest.size());
        } else {
            wk.detachFromParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeContinuation(WebContinuationsHolder continuationsHolder, WebContinuation wk) {
        continuationsHolder.removeContinuation(wk);
        ValueInstrument valueInstrument = this.continuationsCount;
        synchronized (valueInstrument) {
            --this.continuationsCounter;
            this.continuationsCount.setValue(this.continuationsCounter);
        }
        wk.dispose();
        this.continuationsInvalidated.increment();
    }

    private void removeContinuation(WebContinuationsHolder continuationsHolder, WebContinuation wk) {
        WebContinuation parent;
        if (wk.getChildren().size() != 0) {
            return;
        }
        this.disposeContinuation(continuationsHolder, wk);
        this._detach(wk);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("WK: Deleted continuation: " + wk.getId());
        }
        if (null != (parent = wk.getParentContinuation()) && parent.hasExpired()) {
            this.removeContinuation(continuationsHolder, parent);
        }
    }

    private void displayExpireSet() {
        StringBuffer wkSet = new StringBuffer("\nWK; Expire set size: " + this.expirations.size());
        Iterator i = this.expirations.iterator();
        while (i.hasNext()) {
            WebContinuation wk = (WebContinuation)i.next();
            long lat = wk.getLastAccessTime() + wk.getTimeToLive();
            wkSet.append("\nWK: ").append(wk.getId()).append(" ExpireTime [");
            if (lat < System.currentTimeMillis()) {
                wkSet.append("Expired");
            } else {
                wkSet.append(lat);
            }
            wkSet.append("]");
        }
        this.getLogger().debug(wkSet.toString());
    }

    public void displayAllContinuations() {
        Iterator i = this.forest.iterator();
        while (i.hasNext()) {
            ((WebContinuation)i.next()).display();
        }
    }

    protected void expireContinuations() {
        WebContinuation wk;
        long now = 0L;
        if (this.getLogger().isDebugEnabled()) {
            now = System.currentTimeMillis();
        }
        int count = 0;
        Iterator i = this.expirations.iterator();
        while (i.hasNext() && (wk = (WebContinuation)i.next()).hasExpired()) {
            i.remove();
            WebContinuationsHolder continuationsHolder = null;
            continuationsHolder = wk instanceof HolderAwareWebContinuation ? ((HolderAwareWebContinuation)wk).getContinuationsHolder() : this.continuationsHolder;
            this.removeContinuation(continuationsHolder, wk);
            ++count;
        }
        this.expirationsSize.setValue(this.expirations.size());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("WK Cleaned up " + count + " continuations in " + (System.currentTimeMillis() - now));
        }
    }

    private void invalidateContinuations(WebContinuationsHolder continuationsHolder) {
        Set continuationIds = continuationsHolder.getContinuationIds();
        Iterator idsIter = continuationIds.iterator();
        while (idsIter.hasNext()) {
            WebContinuation wk = continuationsHolder.get(idsIter.next());
            if (wk == null) continue;
            this._detach(wk);
            this._invalidate(continuationsHolder, wk);
        }
    }

    public WebContinuationsHolder lookupWebContinuationsHolder(boolean createNew) {
        if (!this.bindContinuationsToSession) {
            return this.continuationsHolder;
        }
        Map objectModel = ContextHelper.getObjectModel(this.context);
        Request request = ObjectModelHelper.getRequest(objectModel);
        if (!createNew && request.getSession(false) == null) {
            return null;
        }
        Session session = request.getSession(true);
        WebContinuationsHolder holder = (WebContinuationsHolder)session.getAttribute("o.a.c.c.f.SCMI.WebContinuationsHolder");
        if (!createNew) {
            return holder;
        }
        if (holder != null) {
            return holder;
        }
        holder = new WebContinuationsHolder();
        session.setAttribute("o.a.c.c.f.SCMI.WebContinuationsHolder", holder);
        return holder;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    private static class HolderAwareWebContinuation
    extends WebContinuation {
        private WebContinuationsHolder continuationsHolder;

        public HolderAwareWebContinuation(String id, Object continuation, WebContinuation parentContinuation, int timeToLive, String interpreterId, ContinuationsDisposer disposer, WebContinuationsHolder continuationsHolder) {
            super(id, continuation, parentContinuation, timeToLive, interpreterId, disposer);
            this.continuationsHolder = continuationsHolder;
        }

        public WebContinuationsHolder getContinuationsHolder() {
            return this.continuationsHolder;
        }

        public int compareTo(Object other) {
            return super.compareTo(other);
        }
    }

    private class WebContinuationsHolder
    implements HttpSessionBindingListener {
        private static final String CONTINUATIONS_HOLDER = "o.a.c.c.f.SCMI.WebContinuationsHolder";
        private Map holder = Collections.synchronizedMap(new HashMap());

        private WebContinuationsHolder() {
        }

        public WebContinuation get(Object id) {
            return (WebContinuation)this.holder.get(id);
        }

        public void addContinuation(WebContinuation wk) {
            this.holder.put(wk.getId(), wk);
        }

        public void removeContinuation(WebContinuation wk) {
            this.holder.remove(wk.getId());
        }

        public Set getContinuationIds() {
            return this.holder.keySet();
        }

        public boolean contains(String continuationId) {
            return this.holder.containsKey(continuationId);
        }

        public boolean contains(WebContinuation wk) {
            return this.contains(wk.getId());
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            ContinuationsManagerImpl.this.invalidateContinuations(this);
        }
    }
}

