/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript.fom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.tempuri.javac.JavaClassReader;
import org.tempuri.javac.JavaClassReaderFactory;
import org.tempuri.javac.JavaClassWriter;
import org.tempuri.javac.JavaClassWriterFactory;
import org.tempuri.javac.JavaCompiler;
import org.tempuri.javac.JavaCompilerErrorHandler;
import org.tempuri.javac.JavaSourceReader;
import org.tempuri.javac.JavaSourceReaderFactory;
import org.tempuri.javacImpl.eclipse.JavaCompilerImpl;

public class CompilingClassLoader
extends ClassLoader {
    SourceResolver sourceResolver;
    JavaCompiler compiler;
    List sourcePath = new LinkedList();
    HashSet sourceListeners = new HashSet();
    ClassRepository classRepository;

    protected Class findClass(String className) throws ClassNotFoundException {
        byte[] bytes = this.compile(className);
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    public CompilingClassLoader(ClassLoader parent, SourceResolver sourceResolver, ClassRepository classRepository) {
        super(parent);
        this.sourceResolver = sourceResolver;
        this.classRepository = classRepository;
        this.compiler = new JavaCompilerImpl();
        this.sourcePath.add("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceListener(SourceListener listener) {
        HashSet hashSet = this.sourceListeners;
        synchronized (hashSet) {
            this.sourceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSourceListener(SourceListener listener) {
        HashSet hashSet = this.sourceListeners;
        synchronized (hashSet) {
            this.sourceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Source src, String err) {
        SourceListener[] arr;
        HashSet hashSet = this.sourceListeners;
        synchronized (hashSet) {
            arr = new SourceListener[this.sourceListeners.size()];
            this.sourceListeners.toArray(arr);
        }
        if (err != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i].sourceCompilationError(src, err);
            }
        } else {
            for (int i = 0; i < arr.length; ++i) {
                arr[i].sourceCompiled(src);
            }
        }
    }

    public void setClassRepository(ClassRepository rep) {
        this.classRepository = rep;
    }

    public ClassRepository getClassRepository() {
        return this.classRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourcePath(String[] path) {
        List list = this.sourcePath;
        synchronized (list) {
            this.sourcePath.clear();
            for (int i = 0; i < path.length; ++i) {
                this.sourcePath.add(path[i]);
            }
            this.sourcePath.add("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Source getSource(String className) {
        int dollar = className.indexOf(36);
        if (dollar > 0) {
            className = className.substring(0, dollar);
        }
        List list = this.sourcePath;
        synchronized (list) {
            Iterator i = this.sourcePath.iterator();
            while (i.hasNext()) {
                Source src;
                String prefix = (String)i.next();
                if (prefix.length() > 0 && !prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                String uri = prefix + className.replace('.', '/') + ".java";
                try {
                    src = this.sourceResolver.resolveURI(uri);
                }
                catch (MalformedURLException ignored) {
                    continue;
                }
                catch (IOException ignored) {
                    continue;
                }
                if (src.exists()) {
                    return src;
                }
                this.releaseSource(src);
            }
        }
        return null;
    }

    private void releaseSource(Source src) {
        this.sourceResolver.release(src);
    }

    private String makeFileName(String className) {
        Source src = this.getSource(className);
        if (src != null) {
            String result = src.getURI();
            this.releaseSource(src);
            return result;
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compile(String className) throws ClassNotFoundException {
        byte[] result = this.classRepository.getCompiledClass(className);
        if (result != null) {
            return result;
        }
        Source src = this.getSource(className);
        if (src == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            ErrorHandler errorHandler = new ErrorHandler();
            this.compiler.compile(new String[]{className}, (JavaSourceReaderFactory)new SourceReaderFactory(), (JavaClassReaderFactory)new ClassReaderFactory(), (JavaClassWriterFactory)new ClassWriterFactory(), (JavaCompilerErrorHandler)errorHandler);
            List errorList = errorHandler.getErrorList();
            if (errorList.size() > 0) {
                StringBuffer msg = new StringBuffer("Failed to compile Java class ");
                msg.append(className);
                msg.append(": ");
                Iterator iter = errorList.iterator();
                while (iter.hasNext()) {
                    msg.append("\n");
                    msg.append((String)iter.next());
                }
                this.notifyListeners(src, msg.toString());
                throw new ClassCompilationException(msg.toString());
            }
            byte[] byArray = this.classRepository.getCompiledClass(className);
            return byArray;
        }
        finally {
            this.releaseSource(src);
        }
    }

    static /* synthetic */ void access$300(CompilingClassLoader x0, Source x1, String x2) {
        x0.notifyListeners(x1, x2);
    }

    class ErrorHandler
    implements JavaCompilerErrorHandler {
        List errList = new LinkedList();

        ErrorHandler() {
        }

        public void handleError(String className, int line, int column, Object errorMessage) {
            String msg = className;
            try {
                msg = CompilingClassLoader.this.makeFileName(className);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (line > 0) {
                msg = msg + ": Line " + line;
            }
            if (column >= 0) {
                msg = msg + "." + column;
            }
            msg = msg + ": ";
            msg = msg + errorMessage;
            this.errList.add(msg);
        }

        public List getErrorList() {
            return this.errList;
        }
    }

    class ClassWriterFactory
    implements JavaClassWriterFactory {
        ClassWriterFactory() {
        }

        public JavaClassWriter getClassWriter(String className) {
            return new JavaClassWriter(this, className){
                private final /* synthetic */ String val$className;
                private final /* synthetic */ ClassWriterFactory this$1;
                {
                    this.this$1 = this$1;
                    this.val$className = val$className;
                }

                public String getClassName() {
                    return this.val$className;
                }

                public void writeClass(InputStream contents) throws IOException {
                    int count;
                    byte[] buf = new byte[2048];
                    ByteArrayOutputStream s = new ByteArrayOutputStream();
                    while ((count = contents.read(buf, 0, buf.length)) > 0) {
                        s.write(buf, 0, count);
                    }
                    s.flush();
                    System.out.println("Compiled: " + this.val$className);
                    Source src = CompilingClassLoader.access$000(ClassWriterFactory.access$200(this.this$1), this.val$className);
                    ClassWriterFactory.access$200((ClassWriterFactory)this.this$1).classRepository.addCompiledClass(this.val$className, src, s.toByteArray());
                    CompilingClassLoader.access$300(ClassWriterFactory.access$200(this.this$1), src, null);
                    CompilingClassLoader.access$100(ClassWriterFactory.access$200(this.this$1), src);
                }
            };
        }

        static /* synthetic */ CompilingClassLoader access$200(ClassWriterFactory x0) {
            return x0.CompilingClassLoader.this;
        }
    }

    class ClassReaderFactory
    implements JavaClassReaderFactory {
        ClassReaderFactory() {
        }

        public JavaClassReader getClassReader(String className) throws IOException {
            byte[] bytes = CompilingClassLoader.this.classRepository.getCompiledClass(className);
            if (bytes != null) {
                return new JavaClassReader(this, className, bytes){
                    private final /* synthetic */ String val$className;
                    private final /* synthetic */ byte[] val$bytes;
                    private final /* synthetic */ ClassReaderFactory this$1;
                    {
                        this.this$1 = this$1;
                        this.val$className = val$className;
                        this.val$bytes = val$bytes;
                    }

                    public String getClassName() {
                        return this.val$className;
                    }

                    public InputStream getInputStream() {
                        return new ByteArrayInputStream(this.val$bytes);
                    }
                };
            }
            String classFile = className.replace('.', '/') + ".class";
            InputStream is = CompilingClassLoader.this.getResourceAsStream(classFile);
            if (is != null) {
                return new JavaClassReader(this, className, is){
                    private final /* synthetic */ String val$className;
                    private final /* synthetic */ InputStream val$is;
                    private final /* synthetic */ ClassReaderFactory this$1;
                    {
                        this.this$1 = this$1;
                        this.val$className = val$className;
                        this.val$is = val$is;
                    }

                    public String getClassName() {
                        return this.val$className;
                    }

                    public InputStream getInputStream() {
                        return this.val$is;
                    }
                };
            }
            return null;
        }
    }

    class SourceReaderFactory
    implements JavaSourceReaderFactory {
        SourceReaderFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JavaSourceReader getSourceReader(String className) throws IOException {
            Source src = CompilingClassLoader.this.getSource(className);
            if (src == null) {
                return null;
            }
            try {
                int count;
                InputStream is = src.getInputStream();
                if (is == null) {
                    JavaSourceReader javaSourceReader = null;
                    return javaSourceReader;
                }
                byte[] buf = new byte[8192];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    baos.write(buf, 0, count);
                }
                baos.flush();
                InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
                JavaSourceReader javaSourceReader = new JavaSourceReader(this, reader, className){
                    private final /* synthetic */ Reader val$reader;
                    private final /* synthetic */ String val$className;
                    private final /* synthetic */ SourceReaderFactory this$1;
                    {
                        this.this$1 = this$1;
                        this.val$reader = val$reader;
                        this.val$className = val$className;
                    }

                    public Reader getReader() {
                        return this.val$reader;
                    }

                    public String getClassName() {
                        return this.val$className;
                    }
                };
                return javaSourceReader;
            }
            finally {
                CompilingClassLoader.this.releaseSource(src);
            }
        }
    }

    static class ClassCompilationException
    extends ClassNotFoundException {
        public ClassCompilationException(String msg) {
            super(msg);
        }
    }

    public static interface ClassRepository {
        public byte[] getCompiledClass(String var1);

        public void addCompiledClass(String var1, Source var2, byte[] var3);
    }

    public static interface SourceListener {
        public void sourceCompiled(Source var1);

        public void sourceCompilationError(Source var1, String var2);
    }
}

