/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ChainedConfiguration;
import org.apache.cocoon.components.SitemapConfigurable;
import org.apache.cocoon.components.SitemapConfigurationHolder;

public final class SitemapVariableHolder
extends AbstractLogEnabled
implements Component,
Configurable,
SitemapConfigurable,
ThreadSafe {
    public static final String ROLE = SitemapVariableHolder.class.getName();
    private Map globalValues;
    private SitemapConfigurationHolder holder;

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration[] parameters = conf.getChildren();
        this.globalValues = new HashMap(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            String key = parameters[i].getName();
            String value = parameters[i].getValue();
            this.globalValues.put(key, value);
        }
    }

    public void configure(SitemapConfigurationHolder holder) {
        this.holder = holder;
    }

    public Object get(String key) {
        return this.getValues().get(key);
    }

    public Iterator getKeys() {
        return this.getValues().keySet().iterator();
    }

    protected Map getValues() {
        HashMap values = (HashMap)this.holder.getPreparedConfiguration();
        if (null == values) {
            values = new HashMap(this.globalValues);
            ChainedConfiguration conf = this.holder.getConfiguration();
            if (conf != null) {
                this.prepare(conf, values);
                this.holder.setPreparedConfiguration(conf, values);
            }
        }
        return values;
    }

    protected void prepare(ChainedConfiguration conf, Map values) {
        ChainedConfiguration parent = conf.getParent();
        if (null != parent) {
            this.prepare(parent, values);
        }
        Configuration[] parameters = conf.getChildren();
        int len = parameters.length;
        for (int i = 0; i < len; ++i) {
            String key = parameters[i].getName();
            String value = parameters[i].getValue("");
            if (key == null || value == null) continue;
            values.put(key, value);
        }
    }
}

