/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.source.URLRewriter;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.util.NetUtils;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.excalibur.xmlizer.XMLizer;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SourceUtil {
    private static REProgram uripattern = null;

    protected SourceUtil() {
    }

    public static void toSAX(Source source, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        SourceUtil.toSAX(CocoonComponentManager.getSitemapComponentManager(), source, null, handler);
    }

    public static void toSAX(Source source, String mimeTypeHint, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        SourceUtil.toSAX(CocoonComponentManager.getSitemapComponentManager(), source, mimeTypeHint, handler);
    }

    public static void toSAX(ComponentManager manager, Source source, String mimeTypeHint, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        if (source instanceof XMLizable) {
            try {
                ((XMLizable)source).toSAX(handler);
            }
            catch (SAXException e) {
                Exception cause = e.getException();
                if (cause != null) {
                    if (cause instanceof ProcessingException) {
                        throw (ProcessingException)((Object)cause);
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    if (cause instanceof SAXException) {
                        throw (SAXException)cause;
                    }
                }
                throw e;
            }
        }
        String mimeType = source.getMimeType();
        if (null == mimeType) {
            mimeType = mimeTypeHint;
        }
        XMLizer xmlizer = null;
        try {
            xmlizer = (XMLizer)manager.lookup(XMLizer.ROLE);
            xmlizer.toSAX(source.getInputStream(), mimeType, source.getURI(), handler);
        }
        catch (SourceException e) {
            throw SourceUtil.handle(e);
        }
        catch (ComponentException e) {
            throw new ProcessingException("Exception during streaming source.", e);
        }
        finally {
            manager.release((Component)xmlizer);
        }
    }

    public static void toSAX(ServiceManager manager, Source source, String mimeTypeHint, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        if (source instanceof XMLizable) {
            ((XMLizable)source).toSAX(handler);
        } else {
            String mimeType = source.getMimeType();
            if (null == mimeType) {
                mimeType = mimeTypeHint;
            }
            XMLizer xmlizer = null;
            try {
                xmlizer = (XMLizer)manager.lookup(XMLizer.ROLE);
                xmlizer.toSAX(source.getInputStream(), mimeType, source.getURI(), handler);
            }
            catch (SourceException e) {
                throw SourceUtil.handle(e);
            }
            catch (ServiceException e) {
                throw new ProcessingException("Exception during streaming source.", e);
            }
            finally {
                manager.release((Object)xmlizer);
            }
        }
    }

    public static void parse(ComponentManager manager, Source source, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        if (source instanceof XMLizable) {
            ((XMLizable)source).toSAX(handler);
        } else {
            SAXParser parser = null;
            try {
                parser = (SAXParser)manager.lookup(SAXParser.ROLE);
                parser.parse(SourceUtil.getInputSource(source), handler);
            }
            catch (SourceException e) {
                throw SourceUtil.handle(e);
            }
            catch (ComponentException e) {
                throw new ProcessingException("Exception during parsing source.", e);
            }
            finally {
                manager.release((Component)parser);
            }
        }
    }

    public static void parse(ServiceManager manager, Source source, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        if (source instanceof XMLizable) {
            ((XMLizable)source).toSAX(handler);
        } else {
            SAXParser parser = null;
            try {
                parser = (SAXParser)manager.lookup(SAXParser.ROLE);
                parser.parse(SourceUtil.getInputSource(source), handler);
            }
            catch (SourceException e) {
                throw SourceUtil.handle(e);
            }
            catch (ServiceException e) {
                throw new ProcessingException("Exception during parsing source.", e);
            }
            finally {
                manager.release((Object)parser);
            }
        }
    }

    public static void toSAX(Source source, ContentHandler handler, Parameters typeParameters, boolean filterDocumentEvent) throws SAXException, IOException, ProcessingException {
        if (typeParameters != null && typeParameters.getParameter("rewriteURLMode", null) != null) {
            handler = new URLRewriter(typeParameters, (ContentHandler)handler);
        }
        String mimeTypeHint = null;
        if (typeParameters != null) {
            mimeTypeHint = typeParameters.getParameter("mime-type", mimeTypeHint);
        }
        if (filterDocumentEvent) {
            IncludeXMLConsumer filter = new IncludeXMLConsumer((ContentHandler)handler);
            SourceUtil.toSAX(source, mimeTypeHint, (ContentHandler)((Object)filter));
        } else {
            SourceUtil.toSAX(source, mimeTypeHint, (ContentHandler)handler);
        }
    }

    public static Document toDOM(Source source) throws SAXException, IOException, ProcessingException {
        DOMBuilder builder = new DOMBuilder();
        SourceUtil.toSAX(source, (ContentHandler)((Object)builder));
        Document document = builder.getDocument();
        if (document == null) {
            throw new ProcessingException("Could not build DOM for '" + source.getURI() + "'");
        }
        return document;
    }

    public static Document toDOM(ServiceManager manager, Source source) throws SAXException, IOException, ProcessingException {
        DOMBuilder builder = new DOMBuilder();
        SourceUtil.toSAX(manager, source, null, (ContentHandler)((Object)builder));
        Document document = builder.getDocument();
        if (document == null) {
            throw new ProcessingException("Could not build DOM for '" + source.getURI() + "'");
        }
        return document;
    }

    public static Document toDOM(ServiceManager manager, String mimeTypeHint, Source source) throws SAXException, IOException, ProcessingException {
        DOMBuilder builder = new DOMBuilder();
        SourceUtil.toSAX(manager, source, mimeTypeHint, (ContentHandler)((Object)builder));
        Document document = builder.getDocument();
        if (document == null) {
            throw new ProcessingException("Could not build DOM for '" + source.getURI() + "'");
        }
        return document;
    }

    public static ProcessingException handle(SourceException se) {
        if (se instanceof SourceNotFoundException) {
            return new ResourceNotFoundException("Resource not found.", se);
        }
        return new ProcessingException("Exception during source resolving.", se);
    }

    public static ProcessingException handle(String message, SourceException se) {
        if (se instanceof SourceNotFoundException) {
            return new ResourceNotFoundException(message, se);
        }
        return new ProcessingException(message, se);
    }

    public static void handleSAXException(String source, SAXException e) throws ProcessingException, IOException, SAXException {
        Exception cause = e.getException();
        if (cause != null) {
            if (cause instanceof ProcessingException) {
                throw (ProcessingException)((Object)cause);
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            throw new ProcessingException("Could not read resource " + source, cause);
        }
        throw e;
    }

    public static InputSource getInputSource(Source source) throws IOException, ProcessingException {
        try {
            InputSource newObject = new InputSource(source.getInputStream());
            newObject.setSystemId(source.getURI());
            return newObject;
        }
        catch (SourceException se) {
            throw SourceUtil.handle(se);
        }
    }

    public static Source getSource(String uri, Parameters typeParameters, SourceParameters resourceParameters, SourceResolver resolver) throws IOException, SAXException, SourceException {
        String encoding;
        String method;
        String queryString;
        SourceParameters queries;
        int queryPos = uri.indexOf(63);
        if (queryPos != -1 && (queries = new SourceParameters(queryString = uri.substring(queryPos + 1))).hasParameters()) {
            StringBuffer buffer = new StringBuffer(uri.substring(0, queryPos));
            int separator = 63;
            Iterator iter = queries.getParameterNames();
            while (iter.hasNext()) {
                String current = (String)iter.next();
                Iterator values = queries.getParameterValues(current);
                while (values.hasNext()) {
                    buffer.append((char)separator).append(current).append('=').append(NetUtils.encode((String)values.next(), "utf-8"));
                    separator = 38;
                }
            }
            uri = buffer.toString();
        }
        String string = method = typeParameters != null ? typeParameters.getParameter("method", "GET") : "GET";
        if (method.equalsIgnoreCase("POST") && (resourceParameters == null || !resourceParameters.hasParameters())) {
            method = "GET";
        }
        if (uri.startsWith("cocoon:") && resourceParameters != null && resourceParameters.hasParameters()) {
            int pos = uri.indexOf(";jsessionid=");
            if (!uri.startsWith("cocoon:")) {
                if (pos != -1) {
                    uri = uri.substring(0, pos);
                }
                uri = org.apache.excalibur.source.SourceUtil.appendParameters((String)uri, (SourceParameters)resourceParameters);
            } else {
                StringBuffer buf = pos == -1 ? new StringBuffer(uri) : new StringBuffer(uri.substring(0, pos));
                buf.append(uri.indexOf(63) == -1 ? (char)'?' : '&');
                buf.append(resourceParameters.getEncodedQueryString());
                uri = buf.toString();
            }
        }
        HashMap<String, String> resolverParameters = new HashMap<String, String>();
        resolverParameters.put(SourceResolver.METHOD, method);
        if (typeParameters != null && (encoding = typeParameters.getParameter("encoding", System.getProperties().getProperty("file.encoding", "ISO-8859-1"))) != null && !"".equals(encoding)) {
            resolverParameters.put(SourceResolver.URI_ENCODING, encoding);
        }
        resolverParameters.put(SourceResolver.URI_PARAMETERS, (String)resourceParameters);
        return resolver.resolveURI(uri, null, resolverParameters);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeDOM(String location, Parameters typeParameters, SourceParameters parameters, DocumentFragment frag, SourceResolver resolver, String serializerName) throws ProcessingException {
        block26: {
            source = null;
            try {
                block32: {
                    block31: {
                        block27: {
                            block29: {
                                block30: {
                                    block24: {
                                        source = SourceUtil.getSource(location, typeParameters, parameters, resolver);
                                        if (!(source instanceof ModifiableSource)) break block29;
                                        ws = (ModifiableSource)source;
                                        frag.normalize();
                                        if (null == serializerName) break block30;
                                        manager = CocoonComponentManager.getSitemapComponentManager();
                                        selector = null;
                                        serializer = null;
                                        oStream = null;
                                        try {
                                            try {
                                                selector = (ComponentSelector)manager.lookup(Serializer.ROLE + "Selector");
                                                serializer = (Serializer)selector.select((Object)serializerName);
                                                oStream = ws.getOutputStream();
                                                serializer.setOutputStream(oStream);
                                                serializer.startDocument();
                                                streamer = new DOMStreamer(serializer);
                                                streamer.stream(frag);
                                                serializer.endDocument();
                                            }
                                            catch (ComponentException e) {
                                                throw new ProcessingException("Unable to lookup serializer.", e);
                                            }
                                            var14_28 = null;
                                            if (oStream == null) break block24;
                                        }
                                        catch (Throwable var13_32) {
                                            var14_29 = null;
                                            if (oStream != null) {
                                                oStream.flush();
                                                try {
                                                    oStream.close();
                                                }
                                                catch (Exception ignore) {
                                                    // empty catch block
                                                }
                                            }
                                            if (selector == null) throw var13_32;
                                            selector.release(serializer);
                                            manager.release((Component)selector);
                                            throw var13_32;
                                        }
                                        oStream.flush();
                                        ** try [egrp 3[TRYBLOCK] [3 : 190->198)] { 
lbl45:
                                        // 1 sources

                                        oStream.close();
                                        break block24;
lbl47:
                                        // 1 sources

                                        catch (Exception ignore) {
                                            // empty catch block
                                        }
                                    }
                                    if (selector != null) {
                                        selector.release((Component)serializer);
                                        manager.release((Component)selector);
                                    }
                                    break block26;
                                }
                                props = XMLUtils.createPropertiesForXML(false);
                                props.put("encoding", "ISO-8859-1");
                                content = XMLUtils.serializeNode(frag, props);
                                oStream = ws.getOutputStream();
                                oStream.write(content.getBytes());
                                oStream.flush();
                                oStream.close();
                                break block26;
                            }
                            if (null == serializerName) break block31;
                            manager = CocoonComponentManager.getSitemapComponentManager();
                            selector = null;
                            serializer = null;
                            oStream = new ByteArrayOutputStream();
                            try {
                                try {
                                    selector = (ComponentSelector)manager.lookup(Serializer.ROLE + "Selector");
                                    serializer = (Serializer)selector.select((Object)serializerName);
                                    serializer.setOutputStream(oStream);
                                    serializer.startDocument();
                                    streamer = new DOMStreamer(serializer);
                                    streamer.stream(frag);
                                    serializer.endDocument();
                                }
                                catch (ComponentException e) {
                                    throw new ProcessingException("Unable to lookup serializer.", e);
                                }
                                var17_33 = null;
                                if (oStream == null) break block27;
                            }
                            catch (Throwable var16_37) {
                                var17_34 = null;
                                if (oStream != null) {
                                    oStream.flush();
                                    try {
                                        oStream.close();
                                    }
                                    catch (Exception ignore) {
                                        // empty catch block
                                    }
                                }
                                if (selector == null) throw var16_37;
                                selector.release(serializer);
                                manager.release((Component)selector);
                                throw var16_37;
                            }
                            oStream.flush();
                            ** try [egrp 6[TRYBLOCK] [7 : 437->445)] { 
lbl102:
                            // 1 sources

                            oStream.close();
                            break block27;
lbl104:
                            // 1 sources

                            catch (Exception ignore) {
                                // empty catch block
                            }
                        }
                        if (selector != null) {
                            selector.release((Component)serializer);
                            manager.release((Component)selector);
                        }
                        content = oStream.toString();
                        break block32;
                    }
                    props = XMLUtils.createPropertiesForXML(false);
                    props.put("encoding", "ISO-8859-1");
                    content = XMLUtils.serializeNode(frag, props);
                }
                parameters = parameters == null ? new SourceParameters() : (SourceParameters)parameters.clone();
                parameters.setSingleParameterValue("content", content);
                source = SourceUtil.getSource(location, typeParameters, parameters, resolver);
                SourceUtil.toSAX(source, new DefaultHandler());
            }
            catch (SourceException e) {
                try {
                    throw SourceUtil.handle(e);
                    catch (IOException e) {
                        throw new ProcessingException(e);
                    }
                    catch (SAXException e) {
                        throw new ProcessingException(e);
                    }
                }
                catch (Throwable var19_38) {
                    resolver.release(source);
                    throw var19_38;
                }
            }
        }
        resolver.release(source);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocumentFragment readDOM(String location, Parameters typeParameters, SourceParameters parameters, SourceResolver resolver) throws ProcessingException {
        DocumentFragment documentFragment;
        Source source = null;
        try {
            source = SourceUtil.getSource(location, typeParameters, parameters, resolver);
            Document doc = SourceUtil.toDOM(source);
            DocumentFragment fragment = doc.createDocumentFragment();
            fragment.appendChild(doc.getDocumentElement());
            documentFragment = fragment;
        }
        catch (SourceException e) {
            try {
                throw SourceUtil.handle(e);
                catch (IOException e2) {
                    throw new ProcessingException(e2);
                }
                catch (SAXException e3) {
                    throw new ProcessingException(e3);
                }
            }
            catch (Throwable throwable) {
                resolver.release(source);
                throw throwable;
            }
        }
        resolver.release(source);
        return documentFragment;
    }

    public static String getScheme(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(2);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    public static String getAuthority(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(4);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    public static String getPath(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(5);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    public static String getPathWithoutAuthority(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(4) + re.getParen(5);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    public static String getQuery(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(7);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    public static String getFragment(String uri) {
        RE re = new RE(uripattern);
        if (re.match(uri)) {
            return re.getParen(9);
        }
        throw new IllegalArgumentException("'" + uri + "' is not a correct URI");
    }

    static {
        try {
            uripattern = new RECompiler().compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$");
        }
        catch (RESyntaxException e) {
            e.printStackTrace();
        }
    }
}

