/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.commons.lang.BooleanUtils;

public class MountNode
extends AbstractProcessingNode
implements Composable,
Disposable {
    protected static final String COCOON_PASS_THROUGH = "COCOON_PASS_THROUGH";
    private final VariableResolver prefix;
    private final VariableResolver source;
    private Map processors = new HashMap();
    private final TreeProcessor parentProcessor;
    private final boolean checkReload;
    private ComponentManager manager;
    private final boolean passThrough;

    public MountNode(VariableResolver prefix, VariableResolver source, TreeProcessor parentProcessor, boolean checkReload, boolean passThrough) {
        this.prefix = prefix;
        this.source = source;
        this.parentProcessor = parentProcessor;
        this.checkReload = checkReload;
        this.passThrough = passThrough;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        Map objectModel = env.getObjectModel();
        String resolvedSource = this.source.resolve(context, objectModel);
        String resolvedPrefix = this.prefix.resolve(context, objectModel);
        if (resolvedSource.length() == 0) {
            throw new ProcessingException("Source of mount statement is empty");
        }
        TreeProcessor processor = this.getProcessor(resolvedSource);
        String oldPrefix = env.getURIPrefix();
        String oldURI = env.getURI();
        String oldContext = env.getContext();
        Object oldPassThrough = env.getAttribute(COCOON_PASS_THROUGH);
        env.setAttribute(COCOON_PASS_THROUGH, BooleanUtils.toBooleanObject((boolean)this.passThrough));
        boolean pipelineWasBuilt = false;
        try {
            env.changeContext(resolvedPrefix, resolvedSource);
            if (context.isBuildingPipelineOnly()) {
                ProcessingPipeline pp = processor.buildPipeline(env);
                if (pp != null) {
                    context.setProcessingPipeline(pp);
                    pipelineWasBuilt = true;
                }
            } else {
                pipelineWasBuilt = processor.process(env);
            }
            Object var14_13 = null;
            if (!pipelineWasBuilt) {
                env.setContext(oldPrefix, oldURI, oldContext);
            }
            if (oldPassThrough != null) {
                env.setAttribute(COCOON_PASS_THROUGH, oldPassThrough);
            } else {
                env.removeAttribute(COCOON_PASS_THROUGH);
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (!pipelineWasBuilt) {
                env.setContext(oldPrefix, oldURI, oldContext);
            }
            if (oldPassThrough != null) {
                env.setAttribute(COCOON_PASS_THROUGH, oldPassThrough);
            } else {
                env.removeAttribute(COCOON_PASS_THROUGH);
            }
            throw throwable;
        }
        return pipelineWasBuilt;
    }

    private synchronized TreeProcessor getProcessor(String source) throws Exception {
        TreeProcessor processor = (TreeProcessor)this.processors.get(source);
        if (processor == null) {
            String actualSource = source.charAt(source.length() - 1) == '/' ? source + "sitemap.xmap" : source;
            processor = this.parentProcessor.createChildProcessor(this.manager, actualSource, this.checkReload);
            this.processors.put(source, processor);
        }
        return processor;
    }

    public void dispose() {
        Iterator iter = this.processors.values().iterator();
        while (iter.hasNext()) {
            ((TreeProcessor)iter.next()).dispose();
        }
    }
}

