/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.util.BrokerHelper;

public class Identity
implements Serializable {
    static final long serialVersionUID = 3182285550574178710L;
    private Class m_objectsTopLevelClass;
    private Class m_objectsRealClass = null;
    private Object[] m_pkValues;
    private transient String m_stringRepresentation = null;
    private transient Integer m_hashCode;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$ValueContainer;

    public Identity(Class clazz, Class clazz2, Object[] objectArray) {
        this.m_objectsTopLevelClass = clazz2;
        this.m_objectsRealClass = clazz;
        this.m_pkValues = objectArray;
        this.checkForPrimaryKeys();
    }

    public Identity(Object object, PersistenceBroker persistenceBroker) {
        this.init(object, persistenceBroker, null);
    }

    public Identity(Object object, PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor) {
        this.init(object, persistenceBroker, classDescriptor);
    }

    private void init(Object object, PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor) {
        if (object == null) {
            throw new OJBRuntimeException("Can't create Identity for 'null'-object");
        }
        try {
            IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(object);
            if (indirectionHandler != null) {
                Identity identity = indirectionHandler.getIdentity();
                this.m_objectsTopLevelClass = identity.m_objectsTopLevelClass;
                this.m_objectsRealClass = identity.m_objectsRealClass;
                this.m_pkValues = identity.m_pkValues;
            } else {
                if (classDescriptor == null) {
                    classDescriptor = persistenceBroker.getClassDescriptor(object.getClass());
                }
                this.m_objectsTopLevelClass = persistenceBroker.getTopLevelClass(object.getClass());
                this.m_objectsRealClass = object.getClass();
                BrokerHelper brokerHelper = persistenceBroker.serviceBrokerHelper();
                this.m_pkValues = brokerHelper.extractValueArray(brokerHelper.getKeyValues(classDescriptor, object, false));
            }
            this.checkForPrimaryKeys();
        }
        catch (Exception exception) {
            throw new ClassNotPersistenceCapableException("Can not init Identity for given object " + object, exception);
        }
    }

    public static Identity fromByteArray(byte[] byArray) throws PersistenceBrokerException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            Identity identity = (Identity)objectInputStream.readObject();
            objectInputStream.close();
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return identity;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
    }

    public Class getObjectsTopLevelClass() {
        return this.m_objectsTopLevelClass;
    }

    public Class getObjectsRealClass() {
        return this.m_objectsRealClass;
    }

    public void setObjectsRealClass(Class clazz) {
        this.m_objectsRealClass = clazz;
    }

    public byte[] serialize() throws PersistenceBrokerException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
    }

    public String toString() {
        if (this.m_stringRepresentation == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_objectsTopLevelClass.getName());
            for (int i = 0; i < this.m_pkValues.length; ++i) {
                stringBuffer.append(i == 0 ? "{" : ",");
                stringBuffer.append(this.m_pkValues[i]);
            }
            stringBuffer.append("}");
            this.m_stringRepresentation = stringBuffer.toString();
        }
        return this.m_stringRepresentation;
    }

    protected void checkForPrimaryKeys() throws ClassNotPersistenceCapableException {
        if (this.m_pkValues.length == 0) {
            throw new ClassNotPersistenceCapableException("OJB needs at least one primary key attribute for class  objectsRealClass=" + this.m_objectsRealClass + ", objectTopLevelClass=" + this.m_objectsTopLevelClass);
        }
        if (this.m_pkValues[0] instanceof ValueContainer) {
            throw new RuntimeException("Can't handle pk values of type " + (class$org$apache$ojb$broker$core$ValueContainer == null ? (class$org$apache$ojb$broker$core$ValueContainer = Identity.class$("org.apache.ojb.broker.core.ValueContainer")) : class$org$apache$ojb$broker$core$ValueContainer).getName());
        }
    }

    public Object[] getPrimaryKeyValues() {
        return this.m_pkValues;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object instanceof Identity) {
            Identity identity = (Identity)object;
            Object[] objectArray = identity.getPrimaryKeyValues();
            bl = this.getObjectsTopLevelClass().equals(identity.getObjectsTopLevelClass()) && this.m_pkValues.length == objectArray.length;
            for (int i = 0; bl && i < this.m_pkValues.length; ++i) {
                boolean bl2 = this.m_pkValues[i] == null ? objectArray[i] == null : (bl = this.m_pkValues[i].equals(objectArray[i]));
                if (bl || !(this.m_pkValues[i] instanceof byte[]) || !(objectArray[i] instanceof byte[])) continue;
                bl = Arrays.equals((byte[])this.m_pkValues[i], (byte[])objectArray[i]);
            }
        }
        return bl;
    }

    public int hashCode() {
        if (this.m_hashCode == null) {
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
            hashCodeBuilder.append(this.getObjectsTopLevelClass().hashCode());
            for (int i = 0; i < this.m_pkValues.length; ++i) {
                hashCodeBuilder.append(this.m_pkValues[i]);
            }
            this.m_hashCode = new Integer(hashCodeBuilder.toHashCode());
        }
        return this.m_hashCode;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

