/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.accesslayer.CollectionPrefetcher;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByMtoNCriteria;
import org.apache.ojb.broker.query.ReportQueryByMtoNCriteria;
import org.apache.ojb.broker.util.BrokerHelper;

public class MtoNCollectionPrefetcher
extends CollectionPrefetcher {
    public MtoNCollectionPrefetcher(PersistenceBrokerImpl persistenceBrokerImpl, ObjectReferenceDescriptor objectReferenceDescriptor) {
        super(persistenceBrokerImpl, objectReferenceDescriptor);
    }

    public void prefetchRelationship(Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        Query[] queryArray = this.buildPrefetchQueries(collection, arrayList);
        Query[] queryArray2 = this.buildMtoNImplementorQueries(collection, arrayList);
        for (int i = 0; i < queryArray.length; ++i) {
            Object object;
            Iterator iterator = this.getBroker().getIteratorByQuery(queryArray[i]);
            while (iterator.hasNext()) {
                object = iterator.next();
                if (arrayList.contains(object)) continue;
                arrayList.add(object);
            }
            object = this.getBroker().getReportQueryIteratorByQuery(queryArray2[i]);
            while (object.hasNext()) {
                arrayList2.add(object.next());
            }
        }
        this.associateBatched(collection, arrayList, arrayList2);
    }

    protected Query buildPrefetchQuery(Collection collection) {
        CollectionDescriptor collectionDescriptor = this.getCollectionDescriptor();
        String[] stringArray = this.getFksToThisClass();
        String[] stringArray2 = this.getFksToItemClass();
        FieldDescriptor[] fieldDescriptorArray = this.getItemClassDescriptor().getPkFields();
        Criteria criteria = this.buildPrefetchCriteria(collection, stringArray, stringArray2, fieldDescriptorArray);
        return new QueryByMtoNCriteria(collectionDescriptor.getItemClass(), collectionDescriptor.getIndirectionTable(), criteria, false);
    }

    protected Query buildMtoNImplementorQuery(Collection collection) {
        int n;
        String[] stringArray = this.getFksToThisClass();
        String[] stringArray2 = this.getFksToItemClass();
        FieldDescriptor[] fieldDescriptorArray = this.getOwnerClassDescriptor().getPkFields();
        FieldDescriptor[] fieldDescriptorArray2 = this.getItemClassDescriptor().getPkFields();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int[] nArray = new int[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        Criteria criteria = this.buildPrefetchCriteria(collection, stringArray, stringArray2, fieldDescriptorArray2);
        for (n = 0; n < fieldDescriptorArray.length; ++n) {
            nArray[n] = fieldDescriptorArray[n].getJdbcType().getType();
        }
        for (n = 0; n < fieldDescriptorArray2.length; ++n) {
            nArray[fieldDescriptorArray.length + n] = fieldDescriptorArray2[n].getJdbcType().getType();
        }
        ReportQueryByMtoNCriteria reportQueryByMtoNCriteria = new ReportQueryByMtoNCriteria(this.getItemClassDescriptor().getClassOfObject(), stringArray3, criteria, false);
        reportQueryByMtoNCriteria.setIndirectionTable(this.getCollectionDescriptor().getIndirectionTable());
        reportQueryByMtoNCriteria.setJdbcTypes(nArray);
        return reportQueryByMtoNCriteria;
    }

    private String[] getFksToThisClass() {
        String string = this.getCollectionDescriptor().getIndirectionTable();
        String[] stringArray = this.getCollectionDescriptor().getFksToThisClass();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = string + "." + stringArray[i];
        }
        return stringArray2;
    }

    private String[] getFksToItemClass() {
        String string = this.getCollectionDescriptor().getIndirectionTable();
        String[] stringArray = this.getCollectionDescriptor().getFksToItemClass();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = string + "." + stringArray[i];
        }
        return stringArray2;
    }

    protected Query[] buildMtoNImplementorQueries(Collection collection, Collection collection2) {
        ClassDescriptor classDescriptor = this.getOwnerClassDescriptor();
        Class clazz = this.getBroker().getTopLevelClass(classDescriptor.getClassOfObject());
        BrokerHelper brokerHelper = this.getBroker().serviceBrokerHelper();
        ArrayList<Query> arrayList = new ArrayList<Query>(collection.size());
        HashSet<Identity> hashSet = new HashSet<Identity>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object[] objectArray = brokerHelper.extractValueArray(brokerHelper.getKeyValues(classDescriptor, e));
            Identity identity = new Identity(null, clazz, objectArray);
            hashSet.add(identity);
            if (hashSet.size() != this.pkLimit) continue;
            arrayList.add(this.buildMtoNImplementorQuery(hashSet));
            hashSet.clear();
        }
        if (hashSet.size() > 0) {
            arrayList.add(this.buildMtoNImplementorQuery(hashSet));
        }
        return arrayList.toArray(new Query[arrayList.size()]);
    }

    private Criteria buildPrefetchCriteria(Collection collection, String[] stringArray, String[] stringArray2, FieldDescriptor[] fieldDescriptorArray) {
        if (stringArray.length == 1) {
            return this.buildPrefetchCriteriaSingleKey(collection, stringArray[0], stringArray2[0], fieldDescriptorArray[0]);
        }
        return this.buildPrefetchCriteriaMultipleKeys(collection, stringArray, stringArray2, fieldDescriptorArray);
    }

    private Criteria buildPrefetchCriteriaSingleKey(Collection collection, String string, String string2, FieldDescriptor fieldDescriptor) {
        Criteria criteria = new Criteria();
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            arrayList.add(identity.getPrimaryKeyValues()[0]);
        }
        switch (arrayList.size()) {
            case 0: {
                break;
            }
            case 1: {
                criteria.addColumnEqualTo(string, arrayList.get(0));
                break;
            }
            default: {
                criteria.addColumnIn(string, arrayList);
            }
        }
        criteria.addEqualToColumn(fieldDescriptor.getAttributeName(), string2);
        return criteria;
    }

    private Criteria buildPrefetchCriteriaMultipleKeys(Collection collection, String[] stringArray, String[] stringArray2, FieldDescriptor[] fieldDescriptorArray) {
        Criteria criteria = new Criteria();
        Criteria criteria2 = new Criteria();
        Iterator iterator = collection.iterator();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            criteria.addEqualToColumn(fieldDescriptorArray[i].getAttributeName(), stringArray2[i]);
        }
        while (iterator.hasNext()) {
            Criteria criteria3 = new Criteria();
            Identity identity = (Identity)iterator.next();
            Object[] objectArray = identity.getPrimaryKeyValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    criteria3.addColumnIsNull(stringArray[i]);
                    continue;
                }
                criteria3.addColumnEqualTo(stringArray[i], objectArray[i]);
            }
            criteria2.addOrCriteria(criteria3);
        }
        criteria.addAndCriteria(criteria2);
        return criteria;
    }

    protected void associateBatched(Collection collection, Collection collection2, Collection collection3) {
        Object object;
        Collection<Object> collection4;
        Identity identity;
        Object object2;
        Object object3;
        Object e;
        CollectionDescriptor collectionDescriptor = this.getCollectionDescriptor();
        PersistentField persistentField = collectionDescriptor.getPersistentField();
        PersistenceBrokerImpl persistenceBrokerImpl = this.getBroker();
        Class clazz = persistenceBrokerImpl.getTopLevelClass(this.getOwnerClassDescriptor().getClassOfObject());
        Class clazz2 = persistenceBrokerImpl.getTopLevelClass(this.getItemClassDescriptor().getClassOfObject());
        Class clazz3 = collectionDescriptor.getCollectionClass();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            hashMap2.put(new Identity(e, persistenceBrokerImpl), new ArrayList());
        }
        iterator = collection2.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            hashMap.put(new Identity(e, persistenceBrokerImpl), e);
        }
        int n = this.getOwnerClassDescriptor().getPkFields().length;
        int n2 = this.getItemClassDescriptor().getPkFields().length;
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n2];
        Iterator iterator2 = collection3.iterator();
        while (iterator2.hasNext()) {
            object3 = (Object[])iterator2.next();
            System.arraycopy(object3, 0, objectArray, 0, n);
            System.arraycopy(object3, n, objectArray2, 0, n2);
            object2 = new Identity(null, clazz, objectArray);
            identity = new Identity(null, clazz2, objectArray2);
            collection4 = (Collection)hashMap2.get(object2);
            object = hashMap.get(identity);
            collection4.add(object);
        }
        iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Object object4;
            object2 = iterator2.next();
            identity = new Identity(object2, persistenceBrokerImpl);
            collection4 = (List)hashMap2.get(identity);
            if (clazz3 == null && persistentField.getType().isArray()) {
                int n3 = collection4.size();
                object4 = persistentField.getType().getComponentType();
                object3 = Array.newInstance(object4, n3);
                for (int i = 0; i < n3; ++i) {
                    Array.set(object3, i, collection4.get(i));
                }
            } else {
                object = this.createCollection(clazz3);
                object4 = collection4.iterator();
                while (object4.hasNext()) {
                    object.ojbAdd(object4.next());
                }
                object3 = object;
            }
            if ((object = persistentField.get(object2)) instanceof CollectionProxyDefaultImpl && object3 instanceof Collection) {
                ((CollectionProxyDefaultImpl)object).setData((Collection)object3);
                continue;
            }
            persistentField.set(object2, object3);
        }
    }
}

