/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.CollectionPrefetcher;
import org.apache.ojb.broker.accesslayer.MtoNCollectionPrefetcher;
import org.apache.ojb.broker.accesslayer.ReferencePrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;

public class RelationshipPrefetcherFactory {
    public static RelationshipPrefetcher createRelationshipPrefetcher(PersistenceBrokerImpl persistenceBrokerImpl, ObjectReferenceDescriptor objectReferenceDescriptor) {
        if (objectReferenceDescriptor instanceof CollectionDescriptor) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)objectReferenceDescriptor;
            if (collectionDescriptor.isMtoNRelation()) {
                return new MtoNCollectionPrefetcher(persistenceBrokerImpl, collectionDescriptor);
            }
            return new CollectionPrefetcher(persistenceBrokerImpl, collectionDescriptor);
        }
        return new ReferencePrefetcher(persistenceBrokerImpl, objectReferenceDescriptor);
    }

    public static RelationshipPrefetcher createRelationshipPrefetcher(PersistenceBrokerImpl persistenceBrokerImpl, ClassDescriptor classDescriptor, String string) {
        ObjectReferenceDescriptor objectReferenceDescriptor = classDescriptor.getCollectionDescriptorByName(string);
        if (objectReferenceDescriptor == null && (objectReferenceDescriptor = classDescriptor.getObjectReferenceDescriptorByName(string)) == null) {
            throw new PersistenceBrokerException("Relationship not found: " + string);
        }
        return RelationshipPrefetcherFactory.createRelationshipPrefetcher(persistenceBrokerImpl, objectReferenceDescriptor);
    }
}

