/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.AbstractMetaCache;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheFactory;
import org.apache.ojb.broker.metadata.ObjectCacheDescriptor;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class CacheDistributor
extends AbstractMetaCache {
    private static Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$cache$CacheDistributor == null ? (class$org$apache$ojb$broker$cache$CacheDistributor = CacheDistributor.class$("org.apache.ojb.broker.cache.CacheDistributor")) : class$org$apache$ojb$broker$cache$CacheDistributor);
    private static final String DESCRIPTOR_BASED_CACHES = "descriptorBasedCaches";
    private Map caches = new HashMap();
    private ObjectCache defaultCache;
    private PersistenceBroker broker;
    private boolean descriptorBasedCaches;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$CacheDistributor;

    public CacheDistributor(PersistenceBroker persistenceBroker, ObjectCache objectCache) {
        this.broker = persistenceBroker;
        this.defaultCache = objectCache;
        this.descriptorBasedCaches = OjbConfigurator.getInstance().getConfigurationFor(null).getBoolean(DESCRIPTOR_BASED_CACHES, false);
        logger.info("Use property 'descriptorBasedCaches' is set '" + this.descriptorBasedCaches + "'");
    }

    private ObjectCache prepareAndAddCache(PersistenceBroker persistenceBroker, ObjectCacheDescriptor objectCacheDescriptor, Object object) {
        ObjectCache objectCache;
        if (this.caches.containsKey(object)) {
            logger.info("Contains key '" + object + "', do not create new ObjectCache implementation");
            objectCache = (ObjectCache)this.caches.get(object);
        } else {
            logger.info("Create new ObjectCacheImplementation for '" + object + "'");
            objectCache = this.createObjectCache(persistenceBroker, objectCacheDescriptor);
            this.caches.put(object, objectCache);
        }
        return objectCache;
    }

    private ObjectCache createObjectCache(PersistenceBroker persistenceBroker, ObjectCacheDescriptor objectCacheDescriptor) {
        ObjectCache objectCache = null;
        try {
            objectCache = ObjectCacheFactory.getInstance().createNewCacheInstance(objectCacheDescriptor.getObjectCache(), persistenceBroker, objectCacheDescriptor.getConfigurationProperties());
        }
        catch (Exception exception) {
            logger.error("Can not create ObjectCache instance using " + objectCacheDescriptor.getObjectCache() + ", use default cache instead", exception);
        }
        return objectCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.defaultCache.clear();
        Map map = this.caches;
        synchronized (map) {
            Iterator iterator = this.caches.values().iterator();
            ObjectCache objectCache = null;
            while (iterator.hasNext()) {
                objectCache = (ObjectCache)iterator.next();
                objectCache.clear();
            }
            this.caches.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectCache getCache(Identity identity, Object object, int n) {
        boolean bl = false;
        ObjectCache objectCache = null;
        ObjectCacheDescriptor objectCacheDescriptor = this.searchInClassDescriptor(identity);
        if (objectCacheDescriptor == null) {
            objectCacheDescriptor = this.searchInJdbcConnectionDescriptor();
            bl = true;
        }
        if (objectCacheDescriptor == null) {
            objectCache = this.defaultCache;
        } else if (!bl) {
            if (!this.descriptorBasedCaches) {
                Map map = this.caches;
                synchronized (map) {
                    objectCache = this.lookupCache(identity.getObjectsRealClass());
                    if (objectCache == null && identity.getObjectsRealClass() != null && n == 1) {
                        objectCache = this.prepareAndAddCache(this.broker, objectCacheDescriptor, identity.getObjectsRealClass());
                    }
                }
            } else {
                Map map = this.caches;
                synchronized (map) {
                    objectCache = this.lookupCache(objectCacheDescriptor);
                    if (objectCache == null && n == 1) {
                        objectCache = this.prepareAndAddCache(this.broker, objectCacheDescriptor, objectCacheDescriptor);
                    }
                }
            }
        } else {
            String string = this.broker.serviceConnectionManager().getConnectionDescriptor().getJcdAlias();
            Map map = this.caches;
            synchronized (map) {
                objectCache = this.lookupCache(string);
                if (objectCache == null && n == 1) {
                    objectCache = this.prepareAndAddCache(this.broker, objectCacheDescriptor, string);
                }
            }
        }
        return objectCache;
    }

    private ObjectCache lookupCache(Object object) {
        return (ObjectCache)this.caches.get(object);
    }

    protected ObjectCacheDescriptor searchInClassDescriptor(Identity identity) {
        return identity.getObjectsRealClass() != null ? this.broker.getClassDescriptor(identity.getObjectsRealClass()).getObjectCacheDescriptor() : null;
    }

    protected ObjectCacheDescriptor searchInJdbcConnectionDescriptor() {
        return this.broker.serviceConnectionManager().getConnectionDescriptor().getObjectCacheDescriptor();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        return toStringBuilder.append("Associated PB", (Object)this.broker).append("Used default cache", (Object)this.defaultCache).append("Mapped caches", (Object)this.caches).toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

