/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.collections.LRUMap;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;

public class ObjectCacheSoftImpl
implements ObjectCache,
Configurable {
    private static SoftHashMap cache = null;
    private static int size = 10000;

    public ObjectCacheSoftImpl(PersistenceBroker persistenceBroker, Properties properties) {
        if (cache == null) {
            OjbConfigurator.getInstance().configure(this);
            cache = new SoftHashMap(size);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        size = configuration.getInteger("ObjectCacheSoftImpl", size);
    }

    public void cache(Identity identity, Object object) {
        cache.put(identity, object);
    }

    public Object lookup(Identity identity) {
        return cache.get(identity);
    }

    public void remove(Identity identity) {
        cache.remove(identity);
    }

    public void clear() {
        cache.clear();
    }

    public static final class SoftHashMap {
        private HashMap hash = new HashMap();
        private LRUMap hardCacheMap;
        private ReferenceQueue queue;

        public SoftHashMap(int n) {
            this.hardCacheMap = new LRUMap(n);
            this.queue = new ReferenceQueue();
        }

        public Object put(Object object, Object object2) {
            if (object == null || object2 == null) {
                return null;
            }
            this.processQueue();
            this.hardCacheMap.put(object, object2);
            return this.hash.put(object, new SoftValue(object2, object, this.queue));
        }

        public Object get(Object object) {
            if (object == null) {
                return null;
            }
            Object var2_2 = null;
            SoftReference softReference = (SoftReference)this.hash.get(object);
            if (softReference != null) {
                var2_2 = softReference.get();
                if (var2_2 == null) {
                    this.hash.remove(object);
                } else if (!this.hardCacheMap.containsKey(object)) {
                    this.hardCacheMap.put(object, var2_2);
                } else {
                    this.hardCacheMap.get(object);
                }
            }
            return var2_2;
        }

        public Object remove(Object object) {
            this.processQueue();
            Object var2_2 = null;
            Object v = this.hash.remove(object);
            if (v != null && v instanceof SoftValue) {
                var2_2 = ((SoftValue)v).get();
            }
            return var2_2;
        }

        public void clear() {
            this.processQueue();
            this.hash.clear();
            this.hardCacheMap.clear();
        }

        private void processQueue() {
            SoftValue softValue;
            while ((softValue = (SoftValue)this.queue.poll()) != null) {
                this.hash.remove(softValue.key);
            }
        }

        private class SoftValue
        extends SoftReference {
            private final Object key;

            private SoftValue(Object object, Object object2, ReferenceQueue referenceQueue) {
                super(object, referenceQueue);
                this.key = object2;
            }
        }
    }
}

