/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryIF;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.interceptor.InterceptorFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistenceBrokerFactoryBaseImpl
implements PersistenceBrokerFactoryIF {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl = PersistenceBrokerFactoryBaseImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactoryBaseImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl);
    private Class implementationClass;
    private long instanceCount;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$PBKey;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF;

    public PersistenceBrokerFactoryBaseImpl() {
        this.configure(OjbConfigurator.getInstance().getConfigurationFor(null));
    }

    public void setDefaultKey(PBKey pBKey) {
        try {
            MetadataManager.getInstance().setDefaultPBKey(pBKey);
        }
        catch (Exception exception) {
            throw new PBFactoryException(exception);
        }
    }

    public PBKey getDefaultKey() {
        return MetadataManager.getInstance().getDefaultPBKey();
    }

    protected PersistenceBroker createNewBrokerInstance(PBKey pBKey) throws PBFactoryException {
        if (pBKey == null) {
            throw new PBFactoryException("Could not create new broker with PBkey argument 'null'");
        }
        if (MetadataManager.getInstance().connectionRepository().getDescriptor(pBKey) == null) {
            throw new PBFactoryException("Given PBKey " + pBKey + " does not match in metadata configuration");
        }
        if (log.isEnabledFor(2)) {
            log.info("Create new PB instance for PBKey " + pBKey + ", already created persistence broker instances: " + this.instanceCount);
            ++this.instanceCount;
        }
        PersistenceBroker persistenceBroker = null;
        Class[] classArray = new Class[]{class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = PersistenceBrokerFactoryBaseImpl.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey, class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF = PersistenceBrokerFactoryBaseImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactoryIF")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF};
        Object[] objectArray = new Object[]{pBKey, this};
        try {
            persistenceBroker = (PersistenceBroker)ClassHelper.newInstance(this.implementationClass, classArray, objectArray);
            OjbConfigurator.getInstance().configure(persistenceBroker);
            persistenceBroker = (PersistenceBroker)InterceptorFactory.getInstance().createInterceptorFor(persistenceBroker);
        }
        catch (Exception exception) {
            log.error("Creation of a new PB instance failed", exception);
            throw new PBFactoryException("Creation of a new PB instance failed", exception);
        }
        return persistenceBroker;
    }

    public PersistenceBroker createPersistenceBroker(PBKey pBKey) throws PBFactoryException {
        if (log.isDebugEnabled()) {
            log.debug("Obtain broker from pool, used PBKey is " + pBKey);
        }
        pBKey = BrokerHelper.crossCheckPBKey(pBKey);
        try {
            return this.createNewBrokerInstance(pBKey);
        }
        catch (Exception exception) {
            throw new PBFactoryException("Borrow broker from pool failed, using PBKey " + pBKey, exception);
        }
    }

    public PersistenceBroker createPersistenceBroker(String string, String string2, String string3) throws PBFactoryException {
        return this.createPersistenceBroker(new PBKey(string, string2, string3));
    }

    public PersistenceBroker defaultPersistenceBroker() throws PBFactoryException {
        if (this.getDefaultKey() == null) {
            throw new PBFactoryException("There was no default-PBKey specified");
        }
        return this.createPersistenceBroker(this.getDefaultKey());
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.implementationClass = ((PersistenceBrokerConfiguration)((Object)configuration)).getPersistenceBrokerClass();
    }

    public synchronized void releaseAllInstances() {
        this.instanceCount = 0L;
    }

    public int activePersistenceBroker() {
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

