/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PBState;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.core.PBPoolInfo;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryBaseImpl;
import org.apache.ojb.broker.core.PersistenceBrokerHandle;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.PoolablePersistenceBroker;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistenceBrokerFactoryDefaultImpl
extends PersistenceBrokerFactoryBaseImpl {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerFactoryDefaultImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactoryDefaultImpl = PersistenceBrokerFactoryDefaultImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactoryDefaultImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactoryDefaultImpl);
    private GenericKeyedObjectPool brokerPool;
    private PBPoolInfo poolConfig = new PBPoolInfo();
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactoryDefaultImpl;

    public PersistenceBrokerFactoryDefaultImpl() {
        this.brokerPool = this.createPool();
        log.info("Create PersistenceBroker instance pool, pool configuration was " + this.getPoolConfiguration());
    }

    public PersistenceBroker createPersistenceBroker(PBKey pBKey) throws PBFactoryException {
        if (log.isDebugEnabled()) {
            log.debug("Obtain broker from pool, used PBKey is " + pBKey);
        }
        PersistenceBroker persistenceBroker = null;
        pBKey = BrokerHelper.crossCheckPBKey(pBKey);
        try {
            persistenceBroker = (PersistenceBroker)this.brokerPool.borrowObject((Object)pBKey);
            persistenceBroker = this.wrapRequestedBrokerInstance(persistenceBroker);
        }
        catch (Exception exception) {
            try {
                if (persistenceBroker != null) {
                    persistenceBroker.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new PBFactoryException("Borrow broker from pool failed, using PBKey " + pBKey, exception);
        }
        return persistenceBroker;
    }

    protected PersistenceBroker wrapBrokerWithPoolingHandle(PersistenceBroker persistenceBroker, KeyedObjectPool keyedObjectPool) {
        return new PoolablePersistenceBroker(persistenceBroker, keyedObjectPool);
    }

    protected PersistenceBroker wrapRequestedBrokerInstance(PersistenceBroker persistenceBroker) {
        return new PersistenceBrokerHandle(persistenceBroker);
    }

    public synchronized void releaseAllInstances() {
        log.warn("Release all instances referenced by this object");
        super.releaseAllInstances();
        try {
            this.brokerPool.clear();
        }
        catch (Exception exception) {
            log.error("Clearing of broker pool failed", exception);
        }
    }

    public int activePersistenceBroker() {
        return this.brokerPool.getNumActive();
    }

    public Properties getPoolConfiguration() {
        return this.poolConfig;
    }

    public void setPoolConfiguration(Properties properties) {
        this.poolConfig = new PBPoolInfo(properties);
        log.info("Change pooling configuration properties: " + this.poolConfig.getKeyedObjectPoolConfig());
        this.brokerPool.setConfig(this.poolConfig.getKeyedObjectPoolConfig());
    }

    private GenericKeyedObjectPool createPool() {
        GenericKeyedObjectPool.Config config = this.poolConfig.getKeyedObjectPoolConfig();
        if (log.isDebugEnabled()) {
            log.debug("PersistenceBroker pool will be setup with the following configuration " + ToStringBuilder.reflectionToString((Object)config, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
        }
        GenericKeyedObjectPool genericKeyedObjectPool = new GenericKeyedObjectPool(null, config);
        genericKeyedObjectPool.setFactory((KeyedPoolableObjectFactory)new PBKeyedPoolableObjectFactory(this, (KeyedObjectPool)genericKeyedObjectPool));
        return genericKeyedObjectPool;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PBKeyedPoolableObjectFactory
    implements KeyedPoolableObjectFactory {
        private PersistenceBrokerFactoryDefaultImpl pbf;
        private KeyedObjectPool pool;

        public PBKeyedPoolableObjectFactory(PersistenceBrokerFactoryDefaultImpl persistenceBrokerFactoryDefaultImpl2, KeyedObjectPool keyedObjectPool) {
            this.pbf = persistenceBrokerFactoryDefaultImpl2;
            this.pool = keyedObjectPool;
        }

        public Object makeObject(Object object) throws Exception {
            return PersistenceBrokerFactoryDefaultImpl.this.wrapBrokerWithPoolingHandle(this.pbf.createNewBrokerInstance((PBKey)object), this.pool);
        }

        public void destroyObject(Object object, Object object2) throws Exception {
            PoolablePersistenceBroker poolablePersistenceBroker = (PoolablePersistenceBroker)object2;
            PersistenceBroker persistenceBroker = poolablePersistenceBroker.getInnermostDelegate();
            if (persistenceBroker instanceof PersistenceBrokerImpl) {
                log.info("Destroy PersistenceBroker instance " + object2);
                ((PersistenceBrokerImpl)persistenceBroker).destroy();
            }
            poolablePersistenceBroker.destroy();
        }

        public boolean validateObject(Object object, Object object2) {
            if (((PersistenceBroker)object2).isInTransaction()) {
                log.error("Illegal broker state! This broker instance was already in transaction.");
                return false;
            }
            return true;
        }

        public void activateObject(Object object, Object object2) throws Exception {
            ((PBState)object2).setClosed(false);
        }

        public void passivateObject(Object object, Object object2) throws Exception {
            ((PBState)object2).setClosed(true);
        }
    }
}

