/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryDefaultImpl;
import org.apache.ojb.broker.core.PoolablePersistenceBroker;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryException;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryFactory;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistenceBrokerFactorySyncImpl
extends PersistenceBrokerFactoryDefaultImpl {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl = PersistenceBrokerFactorySyncImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactorySyncImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl);
    private TransactionManager txMan;
    private TxRegistry txRegistry;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl;
    static /* synthetic */ Class class$javax$transaction$Status;

    public PersistenceBrokerFactorySyncImpl() {
        try {
            this.txMan = TransactionManagerFactoryFactory.instance().getTransactionManager();
        }
        catch (TransactionManagerFactoryException transactionManagerFactoryException) {
            throw new PBFactoryException("Can't instantiate TransactionManager of managed environment", (Throwable)((Object)transactionManagerFactoryException));
        }
        this.txRegistry = new TxRegistry();
    }

    public PersistenceBroker createPersistenceBroker(PBKey pBKey) throws PBFactoryException {
        PersistenceBroker persistenceBroker = null;
        pBKey = BrokerHelper.crossCheckPBKey(pBKey);
        Transaction transaction = null;
        try {
            transaction = this.searchForValidTx();
        }
        catch (SystemException systemException) {
            throw new PBFactoryException("Can't create PB instance, failure while lookup running JTA transaction", systemException);
        }
        if (transaction != null) {
            persistenceBroker = this.txRegistry.findBroker(transaction, pBKey);
        }
        persistenceBroker = persistenceBroker == null || persistenceBroker.isClosed() ? super.createPersistenceBroker(pBKey) : super.wrapRequestedBrokerInstance(persistenceBroker);
        return persistenceBroker;
    }

    protected PersistenceBroker wrapBrokerWithPoolingHandle(PersistenceBroker persistenceBroker, KeyedObjectPool keyedObjectPool) {
        return new PersistenceBrokerSyncImpl(persistenceBroker, keyedObjectPool);
    }

    protected PersistenceBroker wrapRequestedBrokerInstance(PersistenceBroker persistenceBroker) {
        block7: {
            if (!(persistenceBroker instanceof PersistenceBrokerSyncImpl)) {
                throw new PBFactoryException("Expect instance of " + (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl = PersistenceBrokerFactorySyncImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl) + ", found " + persistenceBroker.getClass());
            }
            PersistenceBrokerSyncImpl persistenceBrokerSyncImpl = (PersistenceBrokerSyncImpl)persistenceBroker;
            try {
                Transaction transaction = this.searchForValidTx();
                if (transaction == null) break block7;
                this.txRegistry.register(transaction, persistenceBrokerSyncImpl);
                try {
                    persistenceBrokerSyncImpl.internBegin();
                }
                catch (Exception exception) {
                    this.log.error("Unexpected exception when start intern pb-tx", exception);
                    try {
                        transaction.setRollbackOnly();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new PBFactoryException("Unexpected exception when start intern pb-tx", exception);
                }
            }
            catch (Exception exception) {
                throw new PBFactoryException("Error while try to participate in JTA transaction", exception);
            }
        }
        return super.wrapRequestedBrokerInstance(persistenceBroker);
    }

    private Transaction searchForValidTx() throws SystemException {
        int n;
        Transaction transaction = this.txMan.getTransaction();
        if (transaction != null && (n = transaction.getStatus()) != 0 && n != 6) {
            throw new PBFactoryException("Transaction synchronization failed - wrong status of external JTA tx. Expected was an 'active' or 'no transaction', found status is '" + PersistenceBrokerFactorySyncImpl.getStatusFlagAsString(n) + "'");
        }
        return transaction;
    }

    private static String getStatusFlagAsString(int n) {
        String string = "no match, unknown status!";
        try {
            Field[] fieldArray = (class$javax$transaction$Status == null ? (class$javax$transaction$Status = PersistenceBrokerFactorySyncImpl.class$("javax.transaction.Status")) : class$javax$transaction$Status).getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (fieldArray[i].getInt(null) != n) continue;
                string = fieldArray[i].getName();
                break;
            }
        }
        catch (Exception exception) {
            string = "no match, unknown status!";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TxRegistry {
        Map txBoxMap = Collections.synchronizedMap(new WeakHashMap());

        void register(Transaction transaction, PersistenceBroker persistenceBroker) throws RollbackException, SystemException {
            TransactionBox transactionBox = (TransactionBox)this.txBoxMap.get(transaction);
            if (transactionBox == null || transactionBox.isClosed) {
                if (transactionBox != null) {
                    this.txBoxMap.remove(transaction);
                }
                transactionBox = new TransactionBox(transaction);
                transaction.registerSynchronization((Synchronization)transactionBox);
                this.txBoxMap.put(transaction, transactionBox);
            }
            transactionBox.add(persistenceBroker);
        }

        PersistenceBroker findBroker(Transaction transaction, PBKey pBKey) {
            PersistenceBroker persistenceBroker = null;
            TransactionBox transactionBox = (TransactionBox)this.txBoxMap.get(transaction);
            if (transactionBox != null) {
                persistenceBroker = transactionBox.find(pBKey);
            }
            return persistenceBroker;
        }

        TransactionBox findTxBox(Transaction transaction) {
            return (TransactionBox)this.txBoxMap.get(transaction);
        }

        void removeTxBox(Transaction transaction) {
            this.txBoxMap.remove(transaction);
        }
    }

    class TransactionBox
    implements Synchronization {
        Transaction jtaTx;
        Map syncMap = new HashMap();
        boolean isLocked = false;
        boolean isClosed = false;

        public TransactionBox(Transaction transaction) {
            this.jtaTx = transaction;
        }

        PersistenceBroker find(PBKey pBKey) {
            return (PersistenceBroker)this.syncMap.get(pBKey);
        }

        void add(PersistenceBroker persistenceBroker) {
            if (this.isLocked) {
                throw new PBFactoryException("Can't associate object with JTA transaction, because tx-completion started");
            }
            this.syncMap.put(persistenceBroker.getPBKey(), (Synchronization)persistenceBroker);
        }

        public void afterCompletion(int n) {
            boolean bl = false;
            Synchronization synchronization = null;
            Iterator iterator = this.syncMap.values().iterator();
            while (iterator.hasNext()) {
                try {
                    synchronization = (Synchronization)iterator.next();
                    synchronization.afterCompletion(n);
                }
                catch (Exception exception) {
                    bl = true;
                    PersistenceBrokerFactorySyncImpl.this.log.error("Unexpected error when perform Synchronization#afterCompletion method call on object " + synchronization, exception);
                }
            }
            this.isClosed = true;
            PersistenceBrokerFactorySyncImpl.this.txRegistry.removeTxBox(this.jtaTx);
            if (bl) {
                throw new PBFactoryException("Unexpected error occured while performing Synchronization#afterCompletion method");
            }
        }

        public void beforeCompletion() {
            boolean bl = false;
            Synchronization synchronization = null;
            Iterator iterator = this.syncMap.values().iterator();
            while (iterator.hasNext()) {
                try {
                    synchronization = (Synchronization)iterator.next();
                    synchronization.beforeCompletion();
                }
                catch (Exception exception) {
                    bl = true;
                    PersistenceBrokerFactorySyncImpl.this.log.error("Unexpected error when perform Synchronization#beforeCompletion method call on object " + synchronization, exception);
                }
            }
            this.isLocked = true;
            if (bl) {
                throw new PBFactoryException("Unexpected error occured while performing Synchronization#beforeCompletion method");
            }
        }
    }

    public static class PersistenceBrokerSyncImpl
    extends PoolablePersistenceBroker
    implements Synchronization {
        private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl = PersistenceBrokerFactorySyncImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactorySyncImpl$PersistenceBrokerSyncImpl);

        public PersistenceBrokerSyncImpl(PersistenceBroker persistenceBroker, KeyedObjectPool keyedObjectPool) {
            super(persistenceBroker, keyedObjectPool);
        }

        public void beforeCompletion() {
            ConnectionManagerIF connectionManagerIF;
            if (this.log.isDebugEnabled()) {
                this.log.debug("beforeCompletion was called, nothing to do");
            }
            if ((connectionManagerIF = this.serviceConnectionManager()).isBatchMode()) {
                connectionManagerIF.executeBatch();
            }
            if (connectionManagerIF.isInLocalTransaction()) {
                this.log.warn("Seems the used PersistenceBroker handle wasn't closed, close the used handle before the transaction completes.");
                connectionManagerIF.localCommit();
            }
            connectionManagerIF.releaseConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int n) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("afterCompletion was called");
            }
            try {
                if (n != 3) {
                    this.log.error("Abort PB-tx, status of JTA tx is " + PersistenceBrokerFactorySyncImpl.getStatusFlagAsString(n));
                    this.internAbort();
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Commit PB-tx");
                    }
                    this.internCommit();
                }
            }
            finally {
                this.doRealClose();
            }
        }

        private void internBegin() {
            super.beginTransaction();
        }

        private void internCommit() {
            super.commitTransaction();
        }

        private void internAbort() {
            super.abortTransaction();
        }

        private void doRealClose() {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Now do real close of PB instance");
            }
            super.close();
        }

        public boolean close() {
            if (!this.isInTransaction()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PB close was called, pass the close call to underlying PB instance");
                }
                super.close();
            } else {
                ConnectionManagerIF connectionManagerIF;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PB close was called, only close the PB handle when in JTA-tx");
                }
                if ((connectionManagerIF = this.serviceConnectionManager()).isInLocalTransaction()) {
                    connectionManagerIF.localCommit();
                }
                connectionManagerIF.releaseConnection();
            }
            return true;
        }

        public void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
            throw new UnsupportedOperationException("In managed environments only JTA transaction demarcation allowed");
        }

        public void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
            throw new UnsupportedOperationException("In managed environments only JTA transaction demarcation allowed");
        }

        public void abortTransaction() throws TransactionNotInProgressException {
            throw new UnsupportedOperationException("In managed environments only JTA transaction demarcation allowed");
        }
    }
}

