/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.QueryCustomizer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;

public class CollectionDescriptor
extends ObjectReferenceDescriptor {
    private static final long serialVersionUID = -8570280662286424937L;
    private Class collectionClass = null;
    private Collection m_orderby = new ArrayList();
    private String indirectionTable = null;
    private Vector fksToItemClass = null;
    private Vector fksToThisClass = null;
    private String[] fksToItemClassAry;
    private String[] fksToThisClassAry;
    private QueryCustomizer m_queryCustomizer;
    private Boolean m_hasProxyItems;

    public CollectionDescriptor(ClassDescriptor classDescriptor) {
        super(classDescriptor);
    }

    public String[] getFksToThisClass() {
        if (this.fksToThisClassAry == null) {
            this.fksToThisClassAry = this.fksToThisClass.toArray(new String[this.fksToThisClass.size()]);
        }
        return this.fksToThisClassAry;
    }

    public void setFksToThisClass(Vector vector) {
        this.fksToThisClass = vector;
        this.fksToThisClassAry = null;
    }

    public void addFkToThisClass(String string) {
        if (this.fksToThisClass == null) {
            this.fksToThisClass = new Vector();
        }
        this.fksToThisClass.add(string);
        this.fksToThisClassAry = null;
    }

    public void addFkToItemClass(String string) {
        if (this.fksToItemClass == null) {
            this.fksToItemClass = new Vector();
        }
        this.fksToItemClass.add(string);
        this.fksToItemClassAry = null;
    }

    public Class getCollectionClass() {
        return this.collectionClass;
    }

    public void setCollectionClass(Class clazz) {
        this.collectionClass = clazz;
    }

    public String getCollectionClassName() {
        return this.collectionClass != null ? this.collectionClass.getName() : null;
    }

    public String getIndirectionTable() {
        return this.indirectionTable;
    }

    public void setIndirectionTable(String string) {
        this.indirectionTable = string;
    }

    public String[] getFksToItemClass() {
        if (this.fksToItemClassAry == null) {
            this.fksToItemClassAry = this.fksToItemClass.toArray(new String[this.fksToItemClass.size()]);
        }
        return this.fksToItemClassAry;
    }

    public void setFksToItemClass(Vector vector) {
        this.fksToItemClass = vector;
        this.fksToItemClassAry = null;
    }

    public boolean isMtoNRelation() {
        return this.indirectionTable != null;
    }

    public void addOrderBy(String string, boolean bl) {
        if (string != null) {
            this.m_orderby.add(new FieldHelper(string, bl));
        }
    }

    public Collection getOrderBy() {
        return this.m_orderby;
    }

    protected int getCascadeDeleteValue(String string) {
        if (string.equalsIgnoreCase("false") && this.isMtoNRelation()) {
            return 19;
        }
        return super.getCascadeDeleteValue(string);
    }

    public String toXML() {
        Object object;
        int n;
        RepositoryTags repositoryTags = RepositoryTags.getInstance();
        String string = SystemUtils.LINE_SEPARATOR;
        String string2 = "      " + repositoryTags.getOpeningTagNonClosingById(27) + string;
        string2 = string2 + "        " + repositoryTags.getAttribute(16, this.getAttributeName()) + string;
        if (this.getCollectionClassName() != null) {
            string2 = string2 + "        " + repositoryTags.getAttribute(37, this.getCollectionClassName()) + string;
        }
        string2 = string2 + "        " + repositoryTags.getAttribute(29, this.getItemClassName()) + string;
        if (this.isMtoNRelation()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(39, this.getIndirectionTable()) + string;
        }
        if (this.isLazy()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(48, "true") + string;
            string2 = string2 + "        " + repositoryTags.getAttribute(114, "" + this.getProxyPrefetchingLimit()) + string;
        }
        if (this.isRefresh()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(47, "true") + string;
        }
        string2 = string2 + "        " + repositoryTags.getAttribute(24, "" + this.getCascadeRetrieve()) + string;
        string2 = string2 + "        " + repositoryTags.getAttribute(25, this.getCascadeAsString(this.getCascadingStore())) + string;
        string2 = string2 + "        " + repositoryTags.getAttribute(26, this.getCascadeAsString(this.getCascadingDelete())) + string;
        if (this.getOtmDependent()) {
            string2 = string2 + "        " + repositoryTags.getAttribute(102, "true") + string;
        }
        string2 = string2 + "      >" + string;
        for (n = 0; n < this.getForeignKeyFields().size(); ++n) {
            String string3;
            object = this.getForeignKeyFields().get(n);
            if (object instanceof Integer) {
                string3 = object.toString();
                string2 = string2 + "        " + repositoryTags.getOpeningTagNonClosingById(38) + " ";
                string2 = string2 + repositoryTags.getAttribute(70, string3) + "/>" + string;
                continue;
            }
            string3 = (String)object;
            string2 = string2 + "        " + repositoryTags.getOpeningTagNonClosingById(38) + " ";
            string2 = string2 + repositoryTags.getAttribute(84, string3) + "/>" + string;
        }
        if (this.isMtoNRelation()) {
            for (n = 0; n < this.getFksToThisClass().length; ++n) {
                object = this.getFksToThisClass()[n];
                string2 = string2 + "        " + repositoryTags.getOpeningTagNonClosingById(41) + " ";
                string2 = string2 + repositoryTags.getAttribute(17, (String)object) + "/>" + string;
            }
            for (n = 0; n < this.getFksToItemClass().length; ++n) {
                object = this.getFksToItemClass()[n];
                string2 = string2 + "        " + repositoryTags.getOpeningTagNonClosingById(40) + " ";
                string2 = string2 + repositoryTags.getAttribute(17, (String)object) + "/>" + string;
            }
        }
        string2 = string2 + "      " + repositoryTags.getClosingTagById(27) + string;
        return string2;
    }

    public QueryCustomizer getQueryCustomizer() {
        return this.m_queryCustomizer;
    }

    public void setQueryCustomizer(QueryCustomizer queryCustomizer) {
        this.m_queryCustomizer = queryCustomizer;
    }

    public boolean hasProxyItems() throws PersistenceBrokerException {
        if (this.m_hasProxyItems == null) {
            DescriptorRepository descriptorRepository = this.getClassDescriptor().getRepository();
            ClassDescriptor classDescriptor = descriptorRepository.getDescriptorFor(this.getItemClass());
            if (classDescriptor.getProxyClass() != null) {
                this.m_hasProxyItems = Boolean.TRUE;
            } else {
                Vector vector = classDescriptor.getExtentClasses();
                this.m_hasProxyItems = Boolean.FALSE;
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    Class clazz = (Class)iterator.next();
                    ClassDescriptor classDescriptor2 = descriptorRepository.getDescriptorFor(clazz);
                    if (classDescriptor2.getProxyClass() == null) continue;
                    this.m_hasProxyItems = Boolean.TRUE;
                    break;
                }
            }
        }
        return this.m_hasProxyItems;
    }
}

