/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.pooling.PoolConfiguration;

public class ConnectionPoolDescriptor
extends PoolConfiguration
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = -3071461685659671879L;
    private Class connectionFactory;

    public ConnectionPoolDescriptor() {
        this.init();
    }

    public void init() {
        this.setTestOnBorrow(true);
        this.setTestOnReturn(false);
        this.setTestWhileIdle(false);
        this.setLogAbandoned(false);
        this.setRemoveAbandoned(false);
    }

    public Class getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(Class clazz) {
        if (clazz == null) {
            throw new MetadataException("Given ConnectionFactory was null");
        }
        this.connectionFactory = clazz;
    }

    public String toXML() {
        RepositoryTags repositoryTags = RepositoryTags.getInstance();
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("      " + repositoryTags.getOpeningTagNonClosingById(65) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(55, "" + this.getMaxActive()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(56, "" + this.getMaxIdle()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(57, "" + this.getMaxWait()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(58, "" + this.getMinEvictableIdleTimeMillis()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(59, "" + this.getNumTestsPerEvictionRun()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(60, "" + this.isTestOnBorrow()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(61, "" + this.isTestOnReturn()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(62, "" + this.isTestWhileIdle()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(63, "" + this.getTimeBetweenEvictionRunsMillis()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(64, "" + this.getWhenExhaustedAction()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(79, "" + this.getValidationQuery()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(87, "" + this.isLogAbandoned()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(85, "" + this.isRemoveAbandoned()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(86, "" + this.getRemoveAbandonedTimeout()) + string);
        stringBuffer.append("      />" + string);
        return stringBuffer.toString();
    }
}

