/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.IsolationLevels;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public final class DescriptorRepository
extends DescriptorBase
implements Serializable,
XmlCapable,
IsolationLevels {
    static final long serialVersionUID = -1556339982311359524L;
    private static final String VERSION = "1.0";
    private int defaultIsolationLevel = 0;
    private HashMap descriptorTable = new HashMap();
    private Map extentTable = new HashMap();
    private transient Map m_multiMappedTableMap;
    private transient Map m_topLevelClassTable;
    private transient Map m_firstConcreteClassMap;
    private transient Map m_allConcreteSubClass;

    public static String getVersion() {
        return VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExtent(String string, ClassDescriptor classDescriptor) {
        Map map = this.extentTable;
        synchronized (map) {
            this.extentTable.put(string, classDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExtent(String string) {
        Map map = this.extentTable;
        synchronized (map) {
            ClassDescriptor classDescriptor = (ClassDescriptor)this.extentTable.remove(string);
            if (classDescriptor != null && this.m_topLevelClassTable != null) {
                Class clazz = null;
                try {
                    clazz = ClassHelper.getClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new MetadataException("Can't instantiate class object for needed extent remove", classNotFoundException);
                }
                classDescriptor.removeExtentClass(string);
                this.m_topLevelClassTable.remove(clazz);
                this.m_firstConcreteClassMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getTopLevelClass(Class clazz) throws ClassNotPersistenceCapableException {
        Class clazz2;
        if (this.m_topLevelClassTable == null) {
            this.m_topLevelClassTable = new HashMap();
        }
        if ((clazz2 = (Class)this.m_topLevelClassTable.get(clazz)) == null) {
            Map map = this.extentTable;
            synchronized (map) {
                ClassDescriptor classDescriptor = (ClassDescriptor)this.extentTable.get(clazz.getName());
                if (classDescriptor != null) {
                    clazz2 = this.getTopLevelClass(classDescriptor.getClassOfObject());
                    if (clazz2 == null) {
                        clazz2 = clazz;
                    }
                } else {
                    this.getDescriptorFor(clazz);
                    clazz2 = clazz;
                }
                this.m_topLevelClassTable.put(clazz, clazz2);
            }
        }
        return clazz2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldDescriptor[] getFieldDescriptorsForMultiMappedTable(ClassDescriptor classDescriptor) {
        FieldDescriptor[] fieldDescriptorArray;
        if (this.m_multiMappedTableMap == null) {
            this.m_multiMappedTableMap = new HashMap();
        }
        if ((fieldDescriptorArray = (FieldDescriptor[])this.m_multiMappedTableMap.get(classDescriptor.getClassNameOfObject())) == null) {
            Map map = this.m_multiMappedTableMap;
            synchronized (map) {
                fieldDescriptorArray = this.getAllMappedColumns(this.getClassesMappedToSameTable(classDescriptor));
                this.m_multiMappedTableMap.put(classDescriptor.getClassNameOfObject(), fieldDescriptorArray);
            }
        }
        return fieldDescriptorArray;
    }

    private FieldDescriptor[] getAllMappedColumns(List list) {
        Iterator iterator = list.iterator();
        HashMap<String, FieldDescriptor> hashMap = new HashMap<String, FieldDescriptor>();
        ClassDescriptor classDescriptor = null;
        while (iterator.hasNext()) {
            classDescriptor = (ClassDescriptor)iterator.next();
            FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptions();
            if (fieldDescriptorArray == null) continue;
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                if (hashMap.containsKey(fieldDescriptorArray[i].getColumnName())) continue;
                hashMap.put(fieldDescriptorArray[i].getColumnName(), fieldDescriptorArray[i]);
            }
        }
        Iterator iterator2 = hashMap.values().iterator();
        FieldDescriptor[] fieldDescriptorArray = new FieldDescriptor[hashMap.size()];
        int n = 0;
        while (iterator2.hasNext()) {
            fieldDescriptorArray[n] = (FieldDescriptor)iterator2.next();
            ++n;
        }
        return fieldDescriptorArray;
    }

    private List getClassesMappedToSameTable(ClassDescriptor classDescriptor) {
        Iterator iterator = ((HashMap)this.descriptorTable.clone()).values().iterator();
        ArrayList<ClassDescriptor> arrayList = new ArrayList<ClassDescriptor>();
        arrayList.add(classDescriptor);
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor2 = (ClassDescriptor)iterator.next();
            if (classDescriptor2.getFullTableName() == null || !classDescriptor2.getFullTableName().equals(classDescriptor.getFullTableName()) || classDescriptor.getClassOfObject().equals(classDescriptor2.getClassOfObject())) continue;
            arrayList.add(classDescriptor2);
        }
        return arrayList;
    }

    public Map getDescriptorTable() {
        return this.descriptorTable;
    }

    public ClassDescriptor findFirstConcreteClass(ClassDescriptor classDescriptor) {
        ClassDescriptor classDescriptor2;
        if (this.m_firstConcreteClassMap == null) {
            this.m_firstConcreteClassMap = new HashMap();
        }
        if ((classDescriptor2 = (ClassDescriptor)this.m_firstConcreteClassMap.get(classDescriptor.getClassNameOfObject())) == null) {
            if (classDescriptor.isInterface() || classDescriptor.isAbstract()) {
                if (classDescriptor.isExtent()) {
                    Class clazz;
                    Vector vector = classDescriptor.getExtentClasses();
                    for (int i = 0; i < vector.size() && (classDescriptor2 = this.findFirstConcreteClass(this.getDescriptorFor(clazz = (Class)vector.get(i)))) == null; ++i) {
                    }
                } else {
                    LoggerFactory.getDefaultLogger().error("[" + this.getClass().getName() + "] Found interface/abstract class" + " in metadata declarations without concrete class: " + classDescriptor.getClassNameOfObject());
                }
                this.m_firstConcreteClassMap.put(classDescriptor.getClassNameOfObject(), classDescriptor2);
            } else {
                classDescriptor2 = classDescriptor;
            }
        }
        return classDescriptor2;
    }

    public Collection getAllConcreteSubclassDescriptors(ClassDescriptor classDescriptor) {
        ArrayList<ClassDescriptor> arrayList;
        if (this.m_allConcreteSubClass == null) {
            this.m_allConcreteSubClass = new HashMap();
        }
        if ((arrayList = (ArrayList<ClassDescriptor>)this.m_allConcreteSubClass.get(classDescriptor.getClassOfObject())) == null) {
            arrayList = new ArrayList<ClassDescriptor>();
            Iterator iterator = classDescriptor.getExtentClasses().iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                ClassDescriptor classDescriptor2 = this.getDescriptorFor(clazz);
                if (classDescriptor.equals(classDescriptor2)) continue;
                if (!(classDescriptor2.isInterface() || classDescriptor2.isAbstract() || arrayList.contains(classDescriptor2))) {
                    arrayList.add(classDescriptor2);
                }
                Iterator iterator2 = this.getAllConcreteSubclassDescriptors(classDescriptor2).iterator();
                while (iterator2.hasNext()) {
                    ClassDescriptor classDescriptor3 = (ClassDescriptor)iterator2.next();
                    if (arrayList.contains(classDescriptor3)) continue;
                    arrayList.add(classDescriptor3);
                }
            }
            this.m_allConcreteSubClass.put(classDescriptor.getClassOfObject(), arrayList);
        }
        return arrayList;
    }

    public boolean hasDescriptorFor(Class clazz) {
        return this.descriptorTable.containsKey(clazz.getName());
    }

    public ClassDescriptor getDescriptorFor(String string) throws ClassNotPersistenceCapableException {
        ClassDescriptor classDescriptor = this.discoverDescriptor(string);
        if (classDescriptor == null) {
            throw new ClassNotPersistenceCapableException(string + " not found in OJB Repository");
        }
        return classDescriptor;
    }

    public ClassDescriptor getDescriptorFor(Class clazz) throws ClassNotPersistenceCapableException {
        return this.getDescriptorFor(clazz.getName());
    }

    public void setClassDescriptor(ClassDescriptor classDescriptor) {
        this.put(classDescriptor.getClassNameOfObject(), classDescriptor);
    }

    public void put(Class clazz, ClassDescriptor classDescriptor) {
        this.put(clazz.getName(), classDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, ClassDescriptor classDescriptor) {
        classDescriptor.setRepository(this);
        HashMap hashMap = this.descriptorTable;
        synchronized (hashMap) {
            this.descriptorTable.put(string, classDescriptor);
            Vector vector = classDescriptor.getExtentClasses();
            for (int i = 0; i < vector.size(); ++i) {
                this.addExtent(((Class)vector.get(i)).getName(), classDescriptor);
            }
            this.changeDescriptorEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        HashMap hashMap = this.descriptorTable;
        synchronized (hashMap) {
            ClassDescriptor classDescriptor = (ClassDescriptor)this.descriptorTable.remove(string);
            if (classDescriptor != null) {
                Iterator iterator = this.descriptorTable.values().iterator();
                while (iterator.hasNext()) {
                    ((ClassDescriptor)iterator.next()).removeExtentClass(string);
                }
                this.removeExtent(string);
                Vector vector = classDescriptor.getExtentClasses();
                for (int i = 0; i < vector.size(); ++i) {
                    this.removeExtent(((Class)vector.get(i)).getName());
                }
                this.changeDescriptorEvent();
            }
        }
    }

    public void remove(Class clazz) {
        this.remove(clazz.getName());
    }

    private void changeDescriptorEvent() {
        this.m_multiMappedTableMap = null;
        this.m_topLevelClassTable = null;
        this.m_firstConcreteClassMap = null;
        this.m_allConcreteSubClass = null;
    }

    public Iterator iterator() {
        return ((HashMap)this.descriptorTable.clone()).values().iterator();
    }

    public int getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    public void setDefaultIsolationLevel(int n) {
        this.defaultIsolationLevel = n;
    }

    public String toString() {
        Map map = (Map)this.descriptorTable.clone();
        Iterator iterator = map.keySet().iterator();
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        String string = "class name: ";
        String string2 = "> table name: ";
        while (iterator.hasNext()) {
            Object k = iterator.next();
            ClassDescriptor classDescriptor = (ClassDescriptor)map.get(k);
            toStringBuilder.append(string + k.toString() + " =", (Object)(string2 + classDescriptor.getFullTableName()));
        }
        return toStringBuilder.toString();
    }

    public String toXML() {
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((XmlCapable)iterator.next()).toXML() + string);
        }
        return stringBuffer.toString();
    }

    protected String getIsolationLevelAsString() {
        if (this.defaultIsolationLevel == 0) {
            return "read-uncommitted";
        }
        if (this.defaultIsolationLevel == 1) {
            return "read-committed";
        }
        if (this.defaultIsolationLevel == 2) {
            return "repeatable-read";
        }
        if (this.defaultIsolationLevel == 3) {
            return "serializable";
        }
        if (this.defaultIsolationLevel == 4) {
            return "optimistic";
        }
        return "read-uncommitted";
    }

    protected ClassDescriptor discoverDescriptor(String string) {
        ClassDescriptor classDescriptor = (ClassDescriptor)this.descriptorTable.get(string);
        if (classDescriptor == null) {
            Class clazz;
            try {
                clazz = ClassHelper.getClass(string, true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new OJBRuntimeException("Class, " + string + ", could not be found.", classNotFoundException);
            }
            classDescriptor = this.discoverDescriptor(clazz);
        }
        return classDescriptor;
    }

    private ClassDescriptor discoverDescriptor(Class clazz) {
        ClassDescriptor classDescriptor = (ClassDescriptor)this.descriptorTable.get(clazz.getName());
        if (classDescriptor == null) {
            Class<?>[] classArray;
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                classDescriptor = this.discoverDescriptor(clazz2);
            }
            if (classDescriptor == null && (classArray = clazz.getInterfaces()) != null && classArray.length > 0) {
                for (int i = 0; i < classArray.length && classDescriptor == null; ++i) {
                    classDescriptor = this.discoverDescriptor(classArray[i]);
                }
            }
            if (classDescriptor != null) {
                this.descriptorTable.put(clazz.getName(), classDescriptor);
            }
        }
        return classDescriptor;
    }

    protected void finalize() throws Throwable {
        LoggerFactory.getDefaultLogger().info("# finalize DescriptorRepository instance #");
    }
}

