/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.lang.reflect.Field;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class AbstractPersistentField
implements PersistentField {
    public static final String PATH_TOKEN = "::";
    public static final Class PERSISTENT_FIELD_IMPL_FOR_NESTED = class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl == null ? (class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl = AbstractPersistentField.class$("org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldDirectAccessImpl")) : class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl;
    private static final int UNKNOWN_FIELD = 0;
    private static final int NORMAL_FIELD = 1;
    private static final int NESTED_FIELD = 2;
    protected transient Field field;
    protected String fieldName;
    protected Class rootObjectType;
    private int isNestedField = 0;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl;
    static /* synthetic */ Class class$java$lang$Object;

    public AbstractPersistentField() {
    }

    public AbstractPersistentField(Class clazz, String string) {
        this.rootObjectType = clazz;
        this.fieldName = string;
    }

    public abstract void doSet(Object var1, Object var2);

    public abstract Object doGet(Object var1);

    public abstract boolean makeAccessible();

    public void set(Object object, Object object2) throws MetadataException {
        if (object == null) {
            return;
        }
        if (this.isNestedField()) {
            if (object2 != null || !this.getField().getType().isPrimitive()) {
                this.setNestedObject(object, this.fieldName, object2);
            }
        } else {
            this.doSet(object, object2);
        }
    }

    public Object get(Object object) throws MetadataException {
        if (object == null) {
            return null;
        }
        if (this.isNestedField()) {
            return this.getNestedObject(object, this.fieldName);
        }
        return this.doGet(object);
    }

    protected Logger getLog() {
        return LoggerFactory.getLogger("PersistentField");
    }

    protected Field getField() {
        if (this.field == null) {
            this.field = AbstractPersistentField.computeField(this.rootObjectType, this.fieldName, this.isNestedField(), this.makeAccessible());
        }
        return this.field;
    }

    protected static Field computeField(Class clazz, String string, boolean bl, boolean bl2) {
        try {
            Field field = bl ? AbstractPersistentField.getNestedRecursiveField(clazz, string) : AbstractPersistentField.getFieldRecursive(clazz, string);
            if (bl2) {
                field.setAccessible(true);
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new MetadataException("Can't find member '" + string + "' in " + clazz.getName(), noSuchFieldException);
        }
    }

    private static Field getFieldRecursive(Class clazz, String string) throws NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredField(string);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = AbstractPersistentField.class$("java.lang.Object")) : class$java$lang$Object) || clazz.getSuperclass() == null || clazz.isInterface()) {
                throw noSuchFieldException;
            }
            return AbstractPersistentField.getFieldRecursive(clazz.getSuperclass(), string);
        }
    }

    private static Field getNestedRecursiveField(Class clazz, String string) throws NoSuchFieldException {
        Field field = null;
        int n = string.indexOf(PATH_TOKEN);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            Field field2 = AbstractPersistentField.getFieldRecursive(clazz, string2);
            field = AbstractPersistentField.getNestedRecursiveField(field2.getType(), string.substring(n + PATH_TOKEN.length()));
        } else {
            field = AbstractPersistentField.getFieldRecursive(clazz, string);
        }
        return field;
    }

    protected boolean isNestedField() {
        if (this.isNestedField == 0) {
            if (this.fieldName == null) {
                throw new MetadataException("Unexpected behaviour: fieldName is null, can not calculate field rootObjectType");
            }
            this.isNestedField = this.fieldName.indexOf(PATH_TOKEN) >= 0 ? 2 : 1;
        }
        return this.isNestedField == 2;
    }

    protected Object getNestedObject(Object object, String string) {
        Object object2 = null;
        int n = string.indexOf(PATH_TOKEN);
        Object object3 = ProxyHelper.getRealObject(object);
        Class clazz = ProxyHelper.getRealClass(object);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            PersistentField persistentField = this.createInternPersistentField(clazz, string2);
            Object object4 = persistentField.get(object3);
            if (object4 != null) {
                String string3 = string.substring(n + PATH_TOKEN.length());
                object2 = this.getNestedObject(object4, string3);
            }
        } else {
            PersistentField persistentField = this.createInternPersistentField(clazz, string);
            object2 = persistentField.get(object3);
        }
        return object2;
    }

    protected void setNestedObject(Object object, String string, Object object2) {
        int n = string.indexOf(PATH_TOKEN);
        Class clazz = ProxyHelper.getRealClass(object);
        Object object3 = ProxyHelper.getRealObject(object);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            PersistentField persistentField = this.createInternPersistentField(clazz, string2);
            Object object4 = persistentField.get(object3);
            if (object4 != null || object2 != null) {
                if (object4 == null) {
                    try {
                        object4 = this.createNestedFieldValue(persistentField);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new MetadataException("Error instantiate field: " + string2 + " in object:" + clazz.getName(), instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new MetadataException("Error getting field:" + string2 + " in object:" + clazz.getName(), illegalAccessException);
                    }
                    if (persistentField instanceof AbstractPersistentField) {
                        ((AbstractPersistentField)persistentField).doSet(object3, object4);
                    } else {
                        persistentField.set(object3, object4);
                    }
                }
                String string3 = string.substring(n + PATH_TOKEN.length());
                this.setNestedObject(object4, string3, object2);
            }
        } else {
            PersistentField persistentField = this.createInternPersistentField(clazz, string);
            persistentField.set(object3, object2);
        }
    }

    protected Object createNestedFieldValue(PersistentField persistentField) throws InstantiationException, IllegalAccessException {
        return persistentField.getType().newInstance();
    }

    private PersistentField createInternPersistentField(Class clazz, String string) {
        try {
            return PersistentFieldFactory.createPersistentField(clazz, string);
        }
        catch (Exception exception) {
            throw new MetadataException("Cannot create PersistentField for field '" + string + "' of class " + clazz.getName(), exception);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("fieldName=");
        stringBuffer.append(this.fieldName);
        stringBuffer.append(", field [");
        stringBuffer.append(this.field);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getName() {
        return this.fieldName;
    }

    public Class getType() {
        return this.getField().getType();
    }

    public Class getDeclaringClass() {
        return this.getField().getDeclaringClass();
    }

    public String buildMessageString(Object object, Object object2, Field field) {
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "[try to set 'object value' in 'target object'").append(string + "target obj class: " + (object != null ? object.getClass().getName() : null)).append(string + "target field name: " + (field != null ? field.getName() : null)).append(string + "target field type: " + (field != null ? field.getType() : null)).append(string + "object value class: " + (object2 != null ? object2.getClass().getName() : null)).append(string + "object value: " + (object2 != null ? object2 : null)).append(string + "]");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

