/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class PersistentFieldBase
implements PersistentField {
    public static final String PATH_TOKEN = "::";
    private String fieldName;
    protected Class rootObjectType;
    static /* synthetic */ Class class$java$lang$Object;

    public PersistentFieldBase() {
    }

    public PersistentFieldBase(Class clazz, String string) {
        this.rootObjectType = clazz;
        this.fieldName = string;
    }

    protected abstract boolean makeAccessible();

    public String getName() {
        return this.fieldName;
    }

    public Class getDeclaringClass() {
        return this.rootObjectType;
    }

    protected List getFieldGraph(boolean bl) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        String[] stringArray = StringUtils.split((String)this.getName(), (String)PATH_TOKEN);
        Field field = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                field = field == null ? this.getFieldRecursive(this.rootObjectType, string) : this.getFieldRecursive(field.getType(), string);
                if (bl) {
                    field.setAccessible(true);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new MetadataException("Can't find member '" + string + "' in class " + (field != null ? field.getDeclaringClass() : this.rootObjectType), noSuchFieldException);
            }
            arrayList.add(field);
        }
        return arrayList;
    }

    private Field getFieldRecursive(Class clazz, String string) throws NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredField(string);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = PersistentFieldBase.class$("java.lang.Object")) : class$java$lang$Object) || clazz.getSuperclass() == null || clazz.isInterface()) {
                throw noSuchFieldException;
            }
            return this.getFieldRecursive(clazz.getSuperclass(), string);
        }
    }

    protected Logger getLog() {
        return LoggerFactory.getLogger("PersistentField");
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("rootType", (Object)this.rootObjectType);
        toStringBuilder.append("fieldName", (Object)this.fieldName);
        return toStringBuilder.toString();
    }

    protected String buildMessageString(Object object, Object object2, Field field) {
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "[try to set 'object value' in 'target object'").append(string + "target obj class: " + (object != null ? object.getClass().getName() : null)).append(string + "target field name: " + (field != null ? field.getName() : null)).append(string + "target field type: " + (field != null ? field.getType() : null)).append(string + "object value class: " + (object2 != null ? object2.getClass().getName() : null)).append(string + "object value: " + (object2 != null ? object2 : null)).append(string + "]");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

