/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.lang.reflect.Field;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.AbstractPersistentField;

public class PersistentFieldDirectAccessImpl
extends AbstractPersistentField {
    private static final long serialVersionUID = -5458024240998909205L;

    public PersistentFieldDirectAccessImpl() {
    }

    public PersistentFieldDirectAccessImpl(Class clazz, String string) {
        super(clazz, string);
    }

    public void doSet(Object object, Object object2) throws MetadataException {
        Field field = this.getField();
        Class<?> clazz = field.getType();
        try {
            if (object2 != null || !clazz.isPrimitive()) {
                field.set(ProxyHelper.getRealObject(object), object2);
            }
        }
        catch (NullPointerException nullPointerException) {
            this.getLog().info("Value for field " + (field != null ? field.getName() : null) + " of type " + clazz.getName() + " is null. Can't write into null.", nullPointerException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.getLog().error("while set field: " + this.buildMessageString(object, object2, field));
            throw new MetadataException("IllegalAccess error setting field:" + (field != null ? field.getName() : null) + " in object:" + object.getClass().getName(), illegalAccessException);
        }
        catch (Exception exception) {
            this.getLog().error("while set field: " + this.buildMessageString(object, object2, field), exception);
            throw new MetadataException("Error setting field:" + (field != null ? field.getName() : null) + " in object:" + object.getClass().getName(), exception);
        }
    }

    public Object doGet(Object object) throws MetadataException {
        if (object == null) {
            return null;
        }
        Field field = this.getField();
        try {
            Object object2 = field.get(ProxyHelper.getRealObject(object));
            return object2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MetadataException("IllegalAccess error getting field:" + (field != null ? field.getName() : null) + " in object:" + object != null ? object.getClass().getName() : null, illegalAccessException);
        }
        catch (Throwable throwable) {
            throw new MetadataException("Error getting field:" + (field != null ? field.getName() : null) + " in object:" + (object != null ? object.getClass().getName() : null), throwable);
        }
    }

    public boolean makeAccessible() {
        return true;
    }

    public boolean usesAccessorsAndMutators() {
        return false;
    }
}

