/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldBase;
import org.apache.ojb.broker.util.ClassHelper;

public class PersistentFieldDirectAccessImplNew
extends PersistentFieldBase {
    private static final long serialVersionUID = -5458024240998909205L;
    private transient boolean isInitialized;
    private transient List fieldsList;
    private transient Field field;
    private transient boolean nonNested;

    public PersistentFieldDirectAccessImplNew() {
    }

    public PersistentFieldDirectAccessImplNew(Class clazz, String string) {
        super(clazz, string);
    }

    public Class getType() {
        return this.getField().getType();
    }

    protected Field getField() {
        if (!this.isInitialized) {
            this.fieldsList = this.getFieldGraph(this.makeAccessible());
            this.field = (Field)this.fieldsList.get(this.fieldsList.size() - 1);
            this.nonNested = this.fieldsList.size() == 1;
            this.isInitialized = true;
        }
        return this.field;
    }

    private List getFieldsList() {
        if (!this.isInitialized) {
            this.getField();
        }
        return this.fieldsList;
    }

    protected boolean isNestedField() {
        return !this.nonNested;
    }

    public void set(Object object, Object object2) throws MetadataException {
        if (object == null) {
            return;
        }
        Object object3 = object;
        if (this.isNestedField()) {
            List list = this.getFieldsList();
            int n = list.size() - 1;
            for (int i = 0; i < n; ++i) {
                Field field = (Field)list.get(i);
                Object object4 = null;
                try {
                    object4 = this.getValueFrom(field, object3);
                }
                catch (Exception exception) {
                    throw new MetadataException("Can't read field '" + field.getName() + "' of type " + field.getType().getName(), exception);
                }
                if (object4 != null || object2 != null) {
                    if (object4 == null) {
                        try {
                            object4 = ClassHelper.newInstance(field.getType());
                        }
                        catch (Exception exception) {
                            throw new MetadataException("Can't create nested object of type '" + field.getType() + "' for field '" + field.getName() + "'", exception);
                        }
                    }
                    try {
                        this.setValueFor(field, object3, object4);
                    }
                    catch (Exception exception) {
                        throw new MetadataException("Can't set nested object of type '" + field.getType() + "' for field '" + field.getName() + "'", exception);
                    }
                }
                return;
                object3 = object4;
            }
        }
        this.setValueFor(this.getField(), object3, object2);
    }

    public Object get(Object object) throws MetadataException {
        Object object2 = object;
        if (this.isNestedField()) {
            List list = this.getFieldsList();
            for (int i = 0; i < list.size() && object2 != null; ++i) {
                object2 = this.getValueFrom((Field)list.get(i), object2);
            }
        } else {
            object2 = object2 != null ? this.getValueFrom(this.getField(), object2) : null;
        }
        return object2;
    }

    protected Object getValueFrom(Field field, Object object) {
        try {
            return field.get(ProxyHelper.getRealObject(object));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MetadataException("IllegalAccess error getting field:" + (field != null ? field.getName() : null) + " in object:" + object != null ? object.getClass().getName() : null, illegalAccessException);
        }
    }

    protected void setValueFor(Field field, Object object, Object object2) {
        try {
            if (object2 != null || !field.getType().isPrimitive()) {
                field.set(ProxyHelper.getRealObject(object), object2);
            }
        }
        catch (NullPointerException nullPointerException) {
            this.getLog().info("Target object '" + (object != null ? object.getClass().getName() : null) + "' for field '" + (field != null ? field.getName() : null) + "' of type '" + (field != null ? field.getType().getName() : null) + "' seems to be null. Can't write into null.", nullPointerException);
        }
        catch (Exception exception) {
            this.getLog().error("while set field: " + this.buildMessageString(object, object2, field));
            throw new MetadataException("IllegalAccess error setting field:" + (field != null ? field.getName() : null) + " in object:" + object.getClass().getName(), exception);
        }
    }

    protected boolean makeAccessible() {
        return true;
    }

    public boolean usesAccessorsAndMutators() {
        return false;
    }
}

