/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import org.apache.commons.beanutils.DynaBean;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldBase;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistentFieldDynaBeanImplNew
extends PersistentFieldBase {
    private static final long serialVersionUID = 4728858060905429509L;

    public PersistentFieldDynaBeanImplNew() {
    }

    public PersistentFieldDynaBeanImplNew(Class clazz, String string) {
        super(clazz, string);
        this.checkNested(string);
    }

    public void set(Object object, Object object2) throws MetadataException {
        if (object == null) {
            return;
        }
        if (object instanceof DynaBean) {
            DynaBean dynaBean = (DynaBean)object;
            try {
                dynaBean.set(this.getName(), object2);
            }
            catch (Throwable throwable) {
                String string = dynaBean.getClass().getName();
                this.logSetProblem(object, object2, string);
                throw new PersistenceBrokerException(throwable);
            }
        } else {
            String string = "the object is not a DynaBean";
            this.logSetProblem(object, object2, string);
            throw new PersistenceBrokerException(string);
        }
    }

    public Object get(Object object) throws MetadataException {
        if (object == null) {
            return null;
        }
        if (object instanceof DynaBean) {
            DynaBean dynaBean = (DynaBean)object;
            try {
                return dynaBean.get(this.getName());
            }
            catch (Throwable throwable) {
                String string = dynaBean.getClass().getName();
                this.logGetProblem(object, string);
                throw new PersistenceBrokerException(throwable);
            }
        }
        String string = "the object is not a DynaBean";
        this.logGetProblem(object, string);
        throw new PersistenceBrokerException(string);
    }

    private void checkNested(String string) {
        if (string.indexOf("::") > -1) {
            throw new MetadataException("This implementation does not support nested fields");
        }
    }

    public Class getType() {
        return this.getDeclaringClass();
    }

    protected boolean makeAccessible() {
        return false;
    }

    public boolean usesAccessorsAndMutators() {
        return false;
    }

    protected void logSetProblem(Object object, Object object2, String string) {
        Logger logger = LoggerFactory.getDefaultLogger();
        logger.error("Error in operation [set] of object [" + this.getClass().getName() + "], " + string);
        logger.error("Property Name [" + this.getName() + "]");
        if (object instanceof DynaBean) {
            DynaBean dynaBean = (DynaBean)object;
            logger.error("anObject was DynaClass [" + dynaBean.getDynaClass().getName() + "]");
        } else if (object != null) {
            logger.error("anObject was class [" + object.getClass().getName() + "]");
        } else {
            logger.error("anObject was null");
        }
        if (object2 != null) {
            logger.error("aValue was class [" + object2.getClass().getName() + "]");
        } else {
            logger.error("aValue was null");
        }
    }

    protected void logGetProblem(Object object, String string) {
        Logger logger = LoggerFactory.getDefaultLogger();
        logger.error("Error in operation [get of object [" + this.getClass().getName() + "], " + string);
        logger.error("Property Name [" + this.getName() + "]");
        if (object instanceof DynaBean) {
            DynaBean dynaBean = (DynaBean)object;
            logger.error("anObject was DynaClass [" + dynaBean.getDynaClass().getName() + "]");
        } else if (object != null) {
            logger.error("anObject was class [" + object.getClass().getName() + "]");
        } else {
            logger.error("anObject was null");
        }
    }
}

