/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.accesslayer.sql.SqlExistStatement;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.AttributeDescriptorBase;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.MtoNQuery;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByMtoNCriteria;
import org.apache.ojb.broker.util.ArrayIterator;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class BrokerHelper {
    public static final String REPOSITORY_NAME_SEPARATOR = "#";
    private PersistenceBrokerImpl m_broker;
    private Map sqlSelectMap = new WeakHashMap();

    public BrokerHelper(PersistenceBrokerImpl persistenceBrokerImpl) {
        this.m_broker = persistenceBrokerImpl;
    }

    public static PBKey extractAllTokens(String string) {
        if (string == null) {
            throw new PersistenceBrokerException("Could not extract PBKey, given argument is 'null'");
        }
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, REPOSITORY_NAME_SEPARATOR);
        String string4 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()) != null && string2.trim().equals("")) {
            string2 = null;
        }
        if (stringTokenizer.hasMoreTokens() && string2 != null) {
            string3 = stringTokenizer.nextToken();
        }
        if (string2 != null && string3 == null) {
            string3 = "";
        }
        PBKey pBKey = new PBKey(string4, string2, string3);
        return pBKey;
    }

    public static PBKey crossCheckPBKey(PBKey pBKey) {
        PBKey pBKey2;
        if (pBKey.getUser() == null && (pBKey2 = MetadataManager.getInstance().connectionRepository().getStandardPBKeyForJcdAlias(pBKey.getAlias())) != null) {
            return pBKey2;
        }
        return pBKey;
    }

    private ClassDescriptor getRealClassDescriptor(ClassDescriptor classDescriptor, Object object) {
        ClassDescriptor classDescriptor2 = classDescriptor.getClassOfObject() == object.getClass() ? classDescriptor : classDescriptor.getRepository().getDescriptorFor(object.getClass());
        return classDescriptor2;
    }

    public ValueContainer[] getKeyValues(ClassDescriptor classDescriptor, Object object, boolean bl) throws PersistenceBrokerException {
        IndirectionHandler indirectionHandler = ProxyHelper.getIndirectionHandler(object);
        if (indirectionHandler != null) {
            return this.getKeyValues(classDescriptor, indirectionHandler.getIdentity(), bl);
        }
        ClassDescriptor classDescriptor2 = this.getRealClassDescriptor(classDescriptor, object);
        return this.getValuesForObject(classDescriptor2.getPkFields(), object, bl);
    }

    public ValueContainer[] getKeyValues(ClassDescriptor classDescriptor, Identity identity) throws PersistenceBrokerException {
        return this.getKeyValues(classDescriptor, identity, true);
    }

    public ValueContainer[] getKeyValues(ClassDescriptor classDescriptor, Identity identity, boolean bl) throws PersistenceBrokerException {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        ValueContainer[] valueContainerArray = new ValueContainer[fieldDescriptorArray.length];
        Object[] objectArray = identity.getPrimaryKeyValues();
        try {
            for (int i = 0; i < valueContainerArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                Object object = objectArray[i];
                if (bl) {
                    object = fieldDescriptor.getFieldConversion().javaToSql(object);
                }
                valueContainerArray[i] = new ValueContainer(object, fieldDescriptor.getJdbcType());
            }
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException("Can't generate primary key values for given Identity " + identity, exception);
        }
        return valueContainerArray;
    }

    public ValueContainer[] getKeyValues(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        return this.getKeyValues(classDescriptor, object, true);
    }

    public boolean representsNull(FieldDescriptor fieldDescriptor, Object object) {
        if (object == null) {
            return true;
        }
        boolean bl = false;
        if (object instanceof Number && ((Number)object).longValue() == 0L) {
            Class clazz = fieldDescriptor.getPersistentField().getType();
            if (clazz != null) {
                bl = clazz.isPrimitive();
            }
        } else if (object instanceof String && ((String)object).length() == 0) {
            bl = fieldDescriptor.isPrimaryKey();
        }
        return bl;
    }

    public boolean hasNullPKField(ClassDescriptor classDescriptor, Object object) {
        FieldDescriptor fieldDescriptor;
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        boolean bl = false;
        for (int i = 0; i < fieldDescriptorArray.length && !(bl = this.representsNull(fieldDescriptor = fieldDescriptorArray[i], fieldDescriptor.getPersistentField().get(object))); ++i) {
        }
        return bl;
    }

    private Object setAutoIncrementValue(FieldDescriptor fieldDescriptor, Object object, Object object2) {
        PersistentField persistentField = fieldDescriptor.getPersistentField();
        try {
            Object object3 = this.m_broker.serviceSequenceManager().getUniqueValue(fieldDescriptor);
            persistentField.set(object, object3);
            return object3;
        }
        catch (MetadataException metadataException) {
            throw new PersistenceBrokerException("Error while trying to autoincrement field " + persistentField.getDeclaringClass() + REPOSITORY_NAME_SEPARATOR + persistentField.getName(), (Throwable)((Object)metadataException));
        }
        catch (SequenceManagerException sequenceManagerException) {
            throw new PersistenceBrokerException("Could not get key value", (Throwable)((Object)sequenceManagerException));
        }
    }

    public ValueContainer[] getValuesForObject(FieldDescriptor[] fieldDescriptorArray, Object object, boolean bl) throws PersistenceBrokerException {
        ValueContainer[] valueContainerArray = new ValueContainer[fieldDescriptorArray.length];
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            Object object2 = fieldDescriptor.getPersistentField().get(object);
            if (fieldDescriptor.isAutoIncrement() && this.representsNull(fieldDescriptor, object2)) {
                object2 = this.setAutoIncrementValue(fieldDescriptor, object, object2);
            }
            if (bl) {
                object2 = fieldDescriptor.getFieldConversion().javaToSql(object2);
            }
            valueContainerArray[i] = new ValueContainer(object2, fieldDescriptor.getJdbcType());
        }
        return valueContainerArray;
    }

    public ValueContainer[] getNonKeyRwValues(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor2 = this.getRealClassDescriptor(classDescriptor, object);
        return this.getValuesForObject(classDescriptor2.getNonPkRwFields(), object, true);
    }

    public ValueContainer[] getAllRwValues(ClassDescriptor classDescriptor, Object object) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor2 = this.getRealClassDescriptor(classDescriptor, object);
        return this.getValuesForObject(classDescriptor2.getAllRwFields(), object, true);
    }

    public Object[] extractValueArray(ValueContainer[] valueContainerArray) {
        Object[] objectArray = new Object[valueContainerArray.length];
        for (int i = 0; i < valueContainerArray.length; ++i) {
            objectArray[i] = valueContainerArray[i].getValue();
        }
        return objectArray;
    }

    public boolean assertValidPkFields(FieldDescriptor[] fieldDescriptorArray, Object[] objectArray) {
        int n = fieldDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            if (fieldDescriptorArray[i].isAutoIncrement() || fieldDescriptorArray[i].isLocking() || this.assertValidPkValue(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean assertValidPkValue(Object object) {
        if (object == null) {
            return false;
        }
        return !(object instanceof String) || object.toString().trim().length() != 0;
    }

    public Query getCountQuery(Query query) {
        if (query instanceof QueryBySQL) {
            return this.getQueryBySqlCount((QueryBySQL)query);
        }
        if (query instanceof ReportQueryByCriteria) {
            return this.getReportQueryByCriteriaCount((ReportQueryByCriteria)query);
        }
        return this.getQueryByCriteriaCount((QueryByCriteria)query);
    }

    private Query getQueryBySqlCount(QueryBySQL queryBySQL) {
        int n;
        String string = queryBySQL.getSql();
        int n2 = string.toUpperCase().indexOf(" FROM ");
        if (n2 >= 0) {
            string = "select count(*)" + string.substring(n2);
        }
        if ((n = string.toUpperCase().indexOf(" ORDER BY ")) >= 0) {
            string = string.substring(0, n);
        }
        return new QueryBySQL(queryBySQL.getSearchClass(), string);
    }

    private Query getQueryByCriteriaCount(QueryByCriteria queryByCriteria) {
        Object object;
        Object object2;
        Object object3;
        Class clazz = queryByCriteria.getSearchClass();
        Criteria criteria = null;
        String[] stringArray = new String[1];
        if (queryByCriteria.getCriteria() != null) {
            criteria = queryByCriteria.getCriteria().copy(false, false, false);
        }
        if (queryByCriteria.isDistinct()) {
            int n;
            object3 = this.m_broker.getClassDescriptor(clazz).getPkFields();
            object2 = new String[((FieldDescriptor[])object3).length];
            if (((FieldDescriptor[])object3).length > 1) {
                for (n = 0; n < ((FieldDescriptor[])object3).length; ++n) {
                    object2[n] = ((FieldDescriptor)object3[n]).getColumnName();
                }
            } else {
                for (n = 0; n < ((FieldDescriptor[])object3).length; ++n) {
                    object2[n] = ((AttributeDescriptorBase)object3[n]).getAttributeName();
                }
            }
            stringArray[0] = "count(distinct " + this.getPlatform().concatenate((String[])object2) + ")";
        } else {
            stringArray[0] = "count(*)";
        }
        if (queryByCriteria instanceof MtoNQuery) {
            object3 = (MtoNQuery)((Object)queryByCriteria);
            object2 = new ReportQueryByMtoNCriteria(clazz, stringArray, criteria);
            ((ReportQueryByMtoNCriteria)object2).setIndirectionTable(object3.getIndirectionTable());
            object = object2;
        } else {
            object = new ReportQueryByCriteria(clazz, stringArray, criteria);
        }
        object3 = queryByCriteria.getOuterJoinPaths().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (!queryByCriteria.isPathOuterJoin((String)object2)) continue;
            ((QueryByCriteria)object).setPathOuterJoin((String)object2);
        }
        object2 = queryByCriteria.getOrderBy();
        if (object2 != null && !object2.isEmpty()) {
            String[] stringArray2 = new String[object2.size()];
            for (int i = 0; i < object2.size(); ++i) {
                stringArray2[i] = ((FieldHelper)object2.get((int)i)).name;
            }
            ((ReportQueryByCriteria)object).setJoinAttributes(stringArray2);
        }
        return object;
    }

    private Query getReportQueryByCriteriaCount(ReportQueryByCriteria reportQueryByCriteria) {
        ReportQueryByCriteria reportQueryByCriteria2 = (ReportQueryByCriteria)this.getQueryByCriteriaCount(reportQueryByCriteria);
        reportQueryByCriteria2.setJoinAttributes(reportQueryByCriteria.getAttributes());
        Iterator iterator = reportQueryByCriteria.getGroupBy().iterator();
        while (iterator.hasNext()) {
            reportQueryByCriteria2.addGroupBy((FieldHelper)iterator.next());
        }
        return reportQueryByCriteria2;
    }

    private Platform getPlatform() {
        return this.m_broker.serviceSqlGenerator().getPlatform();
    }

    public boolean doesExist(ClassDescriptor classDescriptor, Identity identity, Object object) {
        boolean bl = false;
        String string = (String)this.sqlSelectMap.get(classDescriptor);
        if (string == null) {
            string = new SqlExistStatement(classDescriptor, LoggerFactory.getDefaultLogger()).getStatement();
            this.sqlSelectMap.put(classDescriptor, string);
        }
        StatementManagerIF statementManagerIF = this.m_broker.serviceStatementManager();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = statementManagerIF.getPreparedStatement(classDescriptor, string, false);
            statementManagerIF.bindSelect(preparedStatement, identity, classDescriptor);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.next();
            statementManagerIF.closeResources(preparedStatement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceBrokerSQLException("Exist check failed for identity " + identity + ", sql was " + string, sQLException);
            }
            catch (Throwable throwable) {
                statementManagerIF.closeResources(preparedStatement, resultSet);
                throw throwable;
            }
        }
        return bl;
    }

    public void link(Object object, boolean bl) {
        this.linkOrUnlink(true, object, bl);
    }

    public void unlink(Object object) {
        this.linkOrUnlink(false, object, false);
    }

    private void linkOrUnlink(boolean bl, Object object, boolean bl2) {
        ObjectReferenceDescriptor objectReferenceDescriptor;
        ClassDescriptor classDescriptor = this.m_broker.getDescriptorRepository().getDescriptorFor(object.getClass());
        Iterator iterator = null;
        if (classDescriptor.getObjectReferenceDescriptors().size() > 0) {
            iterator = classDescriptor.getObjectReferenceDescriptors().iterator();
            while (iterator.hasNext()) {
                objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator.next();
                if (bl) {
                    this.m_broker.linkOneToOne(object, classDescriptor, objectReferenceDescriptor, bl2);
                    continue;
                }
                this.m_broker.unlinkFK(object, classDescriptor, objectReferenceDescriptor);
                objectReferenceDescriptor.getPersistentField().set(object, null);
            }
        }
        if (classDescriptor.getCollectionDescriptors().size() > 0) {
            iterator = classDescriptor.getCollectionDescriptors().iterator();
            while (iterator.hasNext()) {
                objectReferenceDescriptor = (CollectionDescriptor)iterator.next();
                if (bl) {
                    if (((CollectionDescriptor)objectReferenceDescriptor).isMtoNRelation()) {
                        this.m_broker.linkMtoN(object, (CollectionDescriptor)objectReferenceDescriptor, bl2);
                        continue;
                    }
                    this.m_broker.linkOneToMany(object, (CollectionDescriptor)objectReferenceDescriptor, bl2);
                    continue;
                }
                this.m_broker.unlinkXtoN(object, (CollectionDescriptor)objectReferenceDescriptor);
            }
        }
    }

    public boolean link(Object object, String string, boolean bl) {
        return this.linkOrUnlink(true, object, string, bl);
    }

    public boolean unlink(Object object, String string) {
        return this.linkOrUnlink(false, object, string, false);
    }

    private boolean linkOrUnlink(boolean bl, Object object, String string, boolean bl2) {
        boolean bl3 = false;
        ClassDescriptor classDescriptor = this.m_broker.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(object));
        ObjectReferenceDescriptor objectReferenceDescriptor = classDescriptor.getObjectReferenceDescriptorByName(string);
        if (objectReferenceDescriptor != null) {
            if (bl) {
                this.m_broker.linkOneToOne(object, classDescriptor, objectReferenceDescriptor, bl2);
            } else {
                this.m_broker.unlinkFK(object, classDescriptor, objectReferenceDescriptor);
                objectReferenceDescriptor.getPersistentField().set(object, null);
            }
            bl3 = true;
        } else {
            CollectionDescriptor collectionDescriptor = classDescriptor.getCollectionDescriptorByName(string);
            if (collectionDescriptor != null) {
                if (bl) {
                    if (collectionDescriptor.isMtoNRelation()) {
                        this.m_broker.linkMtoN(object, collectionDescriptor, bl2);
                    } else {
                        this.m_broker.linkOneToMany(object, collectionDescriptor, bl2);
                    }
                } else {
                    this.m_broker.unlinkXtoN(object, collectionDescriptor);
                }
                bl3 = true;
            }
        }
        return bl3;
    }

    public static Iterator getCollectionIterator(Object object) {
        ArrayIterator arrayIterator;
        if (object instanceof ManageableCollection) {
            arrayIterator = ((ManageableCollection)object).ojbIterator();
        } else if (object instanceof Collection) {
            arrayIterator = ((Collection)object).iterator();
        } else if (object.getClass().isArray()) {
            arrayIterator = new ArrayIterator(object);
        } else {
            throw new OJBRuntimeException("Given object collection of type " + object.getClass() + " can not be managed by OJB. Use Array, Collection or ManageableCollection instead!");
        }
        return arrayIterator;
    }
}

