/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.batch;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.WrappedConnection;
import org.apache.ojb.broker.util.batch.BatchPreparedStatement;
import org.apache.ojb.broker.util.batch.PreparedStatementInvocationHandler;

public class BatchConnection
extends WrappedConnection {
    private static final int MAX_COUNT = 100;
    private static HashMap _pbkeyToFKInfo = new HashMap();
    private boolean _useBatchInserts = true;
    private HashMap _statements = new HashMap();
    private ArrayList _order = new ArrayList();
    private HashMap _fkInfo;
    private HashSet _deleted;
    private HashSet _dontInsert;
    private HashSet _touched = new HashSet();
    private int count = 0;
    private JdbcConnectionDescriptor m_jcd;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$batch$BatchPreparedStatement;

    public BatchConnection(Connection connection, PersistenceBroker persistenceBroker) {
        super(connection);
        this.m_jcd = persistenceBroker.serviceConnectionManager().getConnectionDescriptor();
        this._fkInfo = (HashMap)_pbkeyToFKInfo.get(persistenceBroker.getPBKey());
        if (this._fkInfo != null) {
            return;
        }
        DescriptorRepository descriptorRepository = persistenceBroker.getDescriptorRepository();
        this._fkInfo = new HashMap();
        Iterator iterator = descriptorRepository.iterator();
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor;
            ObjectReferenceDescriptor objectReferenceDescriptor;
            Iterator iterator2;
            AbstractCollection abstractCollection;
            ClassDescriptor classDescriptor2 = (ClassDescriptor)iterator.next();
            Vector vector = classDescriptor2.getObjectReferenceDescriptors();
            if (!vector.isEmpty()) {
                abstractCollection = this.getFKTablesFor(classDescriptor2.getFullTableName());
                iterator2 = vector.iterator();
                while (iterator2.hasNext()) {
                    objectReferenceDescriptor = (ObjectReferenceDescriptor)iterator2.next();
                    classDescriptor = descriptorRepository.getDescriptorFor(objectReferenceDescriptor.getItemClass());
                    abstractCollection.addAll(this.getFullTableNames(classDescriptor, descriptorRepository));
                }
            }
            abstractCollection = classDescriptor2.getCollectionDescriptors();
            iterator2 = abstractCollection.iterator();
            while (iterator2.hasNext()) {
                HashSet hashSet;
                objectReferenceDescriptor = (CollectionDescriptor)iterator2.next();
                classDescriptor = descriptorRepository.getDescriptorFor(objectReferenceDescriptor.getItemClass());
                if (((CollectionDescriptor)objectReferenceDescriptor).isMtoNRelation()) {
                    hashSet = this.getFKTablesFor(((CollectionDescriptor)objectReferenceDescriptor).getIndirectionTable());
                    hashSet.addAll(this.getFullTableNames(classDescriptor2, descriptorRepository));
                    hashSet.addAll(this.getFullTableNames(classDescriptor, descriptorRepository));
                    continue;
                }
                hashSet = this.getFullTableNames(classDescriptor, descriptorRepository);
                Iterator iterator3 = hashSet.iterator();
                while (iterator3.hasNext()) {
                    HashSet hashSet2 = this.getFKTablesFor((String)iterator3.next());
                    hashSet2.addAll(this.getFullTableNames(classDescriptor2, descriptorRepository));
                }
            }
        }
        _pbkeyToFKInfo.put(persistenceBroker.getPBKey(), this._fkInfo);
    }

    private HashSet getFKTablesFor(String string) {
        HashSet hashSet = (HashSet)this._fkInfo.get(string);
        if (hashSet == null) {
            hashSet = new HashSet();
            this._fkInfo.put(string, hashSet);
        }
        return hashSet;
    }

    private HashSet getFullTableNames(ClassDescriptor classDescriptor, DescriptorRepository descriptorRepository) {
        HashSet<String> hashSet = new HashSet<String>();
        Vector vector = classDescriptor.getExtentClasses();
        String string = classDescriptor.getFullTableName();
        if (string != null) {
            hashSet.add(string);
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            ClassDescriptor classDescriptor2 = descriptorRepository.getDescriptorFor(clazz);
            string = classDescriptor2.getFullTableName();
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void setUseBatchInserts(boolean bl) {
        this._useBatchInserts = bl;
    }

    void nextExecuted(String string) throws SQLException {
        ++this.count;
        if (this._order.contains(string)) {
            return;
        }
        String string2 = string.substring(0, 7);
        String string3 = string.substring(string2.equals("UPDATE ") ? 7 : 12);
        String string4 = string3.substring(0, string3.indexOf(32));
        HashSet hashSet = (HashSet)this._fkInfo.get(string4);
        if (this._touched.contains(string4)) {
            this.executeBatch();
        }
        if (string2.equals("INSERT ")) {
            if (this._dontInsert != null && this._dontInsert.contains(string4)) {
                this.executeBatch();
            }
        } else if (this._deleted != null && hashSet != null) {
            HashSet hashSet2 = (HashSet)this._deleted.clone();
            hashSet2.retainAll(hashSet);
            if (!hashSet2.isEmpty()) {
                this.executeBatch();
            }
        }
        this._order.add(string);
        this._touched.add(string4);
        if (string2.equals("INSERT ")) {
            if (hashSet != null) {
                if (this._dontInsert == null) {
                    this._dontInsert = new HashSet();
                }
                this._dontInsert.addAll(hashSet);
            }
        } else if (string2.equals("DELETE ")) {
            if (this._deleted == null) {
                this._deleted = new HashSet();
            }
            this._deleted.add(string4);
        }
    }

    private PreparedStatement prepareBatchStatement(String string) {
        String string2 = string.substring(0, 7);
        if (string2.equals("UPDATE ") || string2.equals("DELETE ") || this._useBatchInserts && string2.equals("INSERT ")) {
            PreparedStatement preparedStatement = (PreparedStatement)this._statements.get(string);
            if (preparedStatement == null) {
                preparedStatement = (PreparedStatement)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = BatchConnection.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement, class$java$sql$Statement == null ? (class$java$sql$Statement = BatchConnection.class$("java.sql.Statement")) : class$java$sql$Statement, class$org$apache$ojb$broker$util$batch$BatchPreparedStatement == null ? (class$org$apache$ojb$broker$util$batch$BatchPreparedStatement = BatchConnection.class$("org.apache.ojb.broker.util.batch.BatchPreparedStatement")) : class$org$apache$ojb$broker$util$batch$BatchPreparedStatement}, (InvocationHandler)new PreparedStatementInvocationHandler(this, string, this.m_jcd));
                this._statements.put(string, preparedStatement);
            }
            return preparedStatement;
        }
        return null;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.prepareBatchStatement(string);
        if (preparedStatement == null) {
            preparedStatement = this.getDelegate().prepareStatement(string);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.prepareBatchStatement(string);
        if (preparedStatement == null) {
            preparedStatement = this.getDelegate().prepareStatement(string, n, n2);
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() throws SQLException {
        Connection connection = this.getDelegate();
        try {
            Iterator iterator = this._order.iterator();
            while (iterator.hasNext()) {
                BatchPreparedStatement batchPreparedStatement = (BatchPreparedStatement)this._statements.get(iterator.next());
                batchPreparedStatement.doExecute(connection);
            }
            Object var5_4 = null;
            this._order.clear();
            if (this._dontInsert != null) {
                this._dontInsert.clear();
            }
            if (this._deleted != null) {
                this._deleted.clear();
            }
            this._touched.clear();
            this.count = 0;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._order.clear();
            if (this._dontInsert != null) {
                this._dontInsert.clear();
            }
            if (this._deleted != null) {
                this._deleted.clear();
            }
            this._touched.clear();
            this.count = 0;
            throw throwable;
        }
    }

    public void executeBatchIfNecessary() throws SQLException {
        if (this.count >= 100) {
            this.executeBatch();
        }
    }

    public void clearBatch() {
        this._order.clear();
        this._statements.clear();
        if (this._dontInsert != null) {
            this._dontInsert.clear();
        }
        if (this._deleted != null) {
            this._deleted.clear();
        }
    }

    public void commit() throws SQLException {
        this.executeBatch();
        this._statements.clear();
        this.getDelegate().commit();
    }

    public void rollback() throws SQLException {
        this.clearBatch();
        this.getDelegate().rollback();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

