/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;

public class Log4jLoggerImpl
implements Logger {
    private static HashMap priorityMap;
    private transient org.apache.log4j.Logger logger;
    private String name;
    private static final String FQCN;
    private static boolean log4jConfigured;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl;

    private static synchronized boolean isLog4JConfigured() {
        if (log4jConfigured) {
            return true;
        }
        Enumeration enumeration = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
        if (!(enumeration instanceof NullEnumeration)) {
            log4jConfigured = true;
            return true;
        }
        Enumeration enumeration2 = LogManager.getCurrentLoggers();
        while (enumeration2.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)enumeration2.nextElement();
            if (logger.getAllAppenders() instanceof NullEnumeration) continue;
            log4jConfigured = true;
            return true;
        }
        return false;
    }

    private static synchronized void initializeLog4JSubSystem(String string) {
        LoggerFactory.getBootLogger().info("Initializing Log4J using file:" + string);
        if (string != null) {
            URL uRL = ClassHelper.getResource(string);
            LoggerFactory.getBootLogger().info("Initializing Log4J : resource from config file:" + uRL);
            if (uRL != null) {
                PropertyConfigurator.configure((URL)uRL);
            } else if (string != "") {
                PropertyConfigurator.configure((String)string);
            }
        }
    }

    public Log4jLoggerImpl(String string) {
        this.name = string;
        this.logger = org.apache.log4j.Logger.getLogger((String)string);
    }

    private org.apache.log4j.Logger getLogger() {
        if (this.logger == null) {
            this.logger = org.apache.log4j.Logger.getLogger((String)this.name);
        }
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    private Level getLevel() {
        return this.getLogger().getEffectiveLevel();
    }

    public final void debug(Object object) {
        this.getLogger().log(FQCN, (Priority)Level.DEBUG, object, null);
    }

    public final void info(Object object) {
        this.getLogger().log(FQCN, (Priority)Level.INFO, object, null);
    }

    public final void warn(Object object) {
        this.getLogger().log(FQCN, (Priority)Level.WARN, object, null);
    }

    public final void error(Object object) {
        this.getLogger().log(FQCN, (Priority)Level.ERROR, object, null);
    }

    public final void fatal(Object object) {
        this.getLogger().log(FQCN, (Priority)Level.FATAL, object, null);
    }

    public void debug(Object object, Throwable throwable) {
        this.getLogger().log(FQCN, (Priority)Level.DEBUG, object, throwable);
    }

    public void error(Object object, Throwable throwable) {
        this.getLogger().log(FQCN, (Priority)Level.ERROR, object, throwable);
    }

    public void fatal(Object object, Throwable throwable) {
        this.getLogger().log(FQCN, (Priority)Level.FATAL, object, throwable);
    }

    public void info(Object object, Throwable throwable) {
        this.getLogger().log(FQCN, (Priority)Level.INFO, object, throwable);
    }

    public void warn(Object object, Throwable throwable) {
        this.getLogger().log(FQCN, (Priority)Level.WARN, object, throwable);
    }

    public void safeDebug(String string, Object object) {
        if (Level.DEBUG.isGreaterOrEqual((Priority)this.getLevel())) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.debug(string + " : " + string2);
        }
    }

    public void safeDebug(String string, Object object, Throwable throwable) {
        if (Level.DEBUG.isGreaterOrEqual((Priority)this.getLevel())) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.debug(string + " : " + string2, throwable);
        }
    }

    public void safeInfo(String string, Object object) {
        if (Level.INFO.isGreaterOrEqual((Priority)this.getLevel())) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.info(string + " : " + string2);
        }
    }

    public void safeInfo(String string, Object object, Throwable throwable) {
        if (Level.INFO.isGreaterOrEqual((Priority)this.getLevel())) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.info(string + " : " + string2, throwable);
        }
    }

    public void safeWarn(String string, Object object) {
        if (Level.WARN.isGreaterOrEqual((Priority)this.getLevel())) {
            String string2 = null;
            try {
                string2 = object.toString();
            }
            catch (Throwable throwable) {
                string2 = "BAD toString() impl for " + object.getClass().getName();
            }
            this.warn(string + " : " + string2);
        }
    }

    public void safeWarn(String string, Object object, Throwable throwable) {
        if (Level.WARN.isGreaterOrEqual((Priority)this.getLevel())) {
            String string2 = null;
            try {
                string2 = object.toString();
            }
            catch (Throwable throwable2) {
                string2 = "BAD toString() impl for " + object.getClass().getName();
            }
            this.warn(string + " : " + string2, throwable);
        }
    }

    public void safeError(String string, Object object) {
        if (Level.ERROR.isGreaterOrEqual((Priority)this.getLevel())) {
            String string2 = null;
            try {
                string2 = object.toString();
            }
            catch (Throwable throwable) {
                string2 = "BAD toString() impl for " + object.getClass().getName();
            }
            this.error(string + " : " + string2);
        }
    }

    public void safeError(String string, Object object, Throwable throwable) {
        if (Level.ERROR.isGreaterOrEqual((Priority)this.getLevel())) {
            String string2 = null;
            try {
                string2 = object.toString();
            }
            catch (Throwable throwable2) {
                string2 = "BAD toString() impl for " + object.getClass().getName();
            }
            this.error(string + " : " + string2, throwable);
        }
    }

    public void safeFatal(String string, Object object) {
        if (Level.FATAL.isGreaterOrEqual((Priority)this.getLevel())) {
            String string2 = null;
            try {
                string2 = object.toString();
            }
            catch (Throwable throwable) {
                string2 = "BAD toString() impl for " + object.getClass().getName();
            }
            this.fatal(string + " : " + string2);
        }
    }

    public void safeFatal(String string, Object object, Throwable throwable) {
        if (Level.FATAL.isGreaterOrEqual((Priority)this.getLevel())) {
            String string2 = null;
            try {
                string2 = object.toString();
            }
            catch (Throwable throwable2) {
                string2 = "BAD toString() impl for " + object.getClass().getName();
            }
            this.fatal(string + " : " + string2, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isEnabledFor(int n) {
        return this.getLogger().isEnabledFor((Priority)((Level)priorityMap.get(new Integer(n))));
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (!Log4jLoggerImpl.isLog4JConfigured()) {
            LoggingConfiguration loggingConfiguration = (LoggingConfiguration)configuration;
            Log4jLoggerImpl.initializeLog4JSubSystem(loggingConfiguration.getLoggerConfigFile());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        FQCN = (class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl = Log4jLoggerImpl.class$("org.apache.ojb.broker.util.logging.Log4jLoggerImpl")) : class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl).getName();
        log4jConfigured = false;
        priorityMap = new HashMap();
        priorityMap.put(new Integer(1), Level.DEBUG);
        priorityMap.put(new Integer(2), Level.INFO);
        priorityMap.put(new Integer(3), Level.WARN);
        priorityMap.put(new Integer(4), Level.ERROR);
        priorityMap.put(new Integer(5), Level.FATAL);
    }
}

